/*
 * Decompiled with CFR 0.152.
 */
package document;

import document.MyObject;
import document.Renderable;
import document.events.Eventtype;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.handles.LineHandleController;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.math.MyMath;
import util.math.PointDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyLine
extends MyObject
implements Renderable {
    PointDouble p1 = new PointDouble();
    PointDouble p2 = new PointDouble();

    public MyLine(PointDouble p1, PointDouble p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.makeShape();
    }

    public MyLine() {
        this(new PointDouble(0.0, 0.0), new PointDouble(0.0, 0.0));
    }

    public void calculateMidWidthHeightAngle() {
        this.height = 0.0;
        this.width = this.p1.distanceTo(this.p2);
        PointDouble v2 = this.p2.getCopy();
        v2.sub(this.p1);
        PointDouble v1 = new PointDouble(1.0, 0.0);
        this.angle = MyMath.angle(v1, new PointDouble(0.0, 0.0), v2);
        this.midX = (this.p1.x + this.p2.x) / 2.0;
        this.midY = (this.p1.y + this.p2.y) / 2.0;
    }

    @Override
    public void copyTo(MyObject object) {
        super.copyTo(object);
        MyLine l = (MyLine)object;
        l.p1 = this.p1.getCopy();
        l.p2 = this.p2.getCopy();
        l.calculateMidWidthHeightAngle();
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.line;
    }

    @Override
    public boolean isInside(PointDouble pPage) {
        if (this.isInBoundigBox(pPage)) {
            PointDouble pz = pPage.getCopy();
            MyMath.rotate(pz, this.midX, this.midY, -this.angle);
            double x = pz.getX();
            double y = pz.getY();
            double halfStrokeWidth = this.getStrokeWidth() / 2.0;
            if (halfStrokeWidth < 0.05) {
                halfStrokeWidth = 0.05;
            }
            boolean inStroke = y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth && (x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX - this.width / 2.0 + halfStrokeWidth || x >= this.midX + this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth) || x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth && (y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY - this.height / 2.0 + halfStrokeWidth || y >= this.midY + this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth);
            return inStroke;
        }
        return false;
    }

    @Override
    protected void makeShape() {
        this.calculateMidWidthHeightAngle();
        this.shape = new Line2D.Double(this.p1, this.p2);
    }

    @Override
    public MyObject getCopy() {
        MyLine object = new MyLine(new PointDouble(0.0, 0.0), new PointDouble(0.0, 0.0));
        this.copyTo(object);
        object.makeShape();
        return object;
    }

    @Override
    public void getHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        this.getRotateHandle(handleList, pageViewPort);
        this.getLineHandles(handleList, pageViewPort);
    }

    @Override
    public void render(GraphicContext gc, boolean isPreview) {
        AffineTransform OldTransform = gc.getTransform();
        gc.setPageCoordinates();
        if (this.isStroked()) {
            this.setStroke(gc);
            gc.draw(this.getShape());
        }
        gc.setTransform(OldTransform);
    }

    public void setStartPointEndPoint(PointDouble p12, PointDouble p22) {
        this.p1 = p12.getCopy();
        this.p2 = p22.getCopy();
        this.makeShape();
    }

    @Override
    public void stretch(PointDouble center, double factor) {
        this.p1.stretch(center, factor);
        this.p2.stretch(center, factor);
        this.makeShape();
    }

    @Override
    public void stretch(PointDouble center, double factorHor, double factorVert) {
    }

    public void stretch(PointDouble center, double factorHor, double factorVert, double angle) {
        MyMath.rotate(this.p1, center.x, center.y, -angle);
        this.p1.x = (this.p1.x - center.x) * factorHor + center.x;
        this.p1.y = (this.p1.y - center.y) * factorVert + center.y;
        MyMath.rotate(this.p1, center.x, center.y, angle);
        MyMath.rotate(this.p2, center.x, center.y, -angle);
        this.p2.x = (this.p2.x - center.x) * factorHor + center.x;
        this.p2.y = (this.p2.y - center.y) * factorVert + center.y;
        MyMath.rotate(this.p2, center.x, center.y, angle);
        this.makeShape();
    }

    @Override
    public void move(double dx, double dy) {
        this.p1.x += dx;
        this.p1.y += dy;
        this.p2.x += dx;
        this.p2.y += dy;
        this.makeShape();
    }

    @Override
    public void moveTo(PointDouble newMid) {
        double dx = newMid.x - this.midX;
        double dy = newMid.y - this.midY;
        this.move(dx, dy);
    }

    @Override
    public void rotate(PointDouble center, double angle) {
        MyMath.rotate(this.p1, center.getX(), center.getY(), angle);
        MyMath.rotate(this.p2, center.getX(), center.getY(), angle);
        this.makeShape();
    }

    public void getLineHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        double strokeWidthHalf = this.getStrokeWidth() / 2.0;
        PointDouble mid = new PointDouble(this.midX, this.midY);
        double distanceOld = this.p1.distance(mid);
        double distance = distanceOld + strokeWidthHalf;
        distance += pageViewPort.pixelTocmX(MyObject.handleDistance);
        if (distanceOld > 1.0E-6) {
            PointDouble pHandle1 = this.p1.getCopy();
            pHandle1.stretch(mid, distance / distanceOld);
            PointDouble pHandle2 = this.p2.getCopy();
            pHandle2.stretch(mid, distance / distanceOld);
            double handleAngle = this.angle;
            int xPanel = pageViewPort.pageCmXtoPixel(pHandle1.getX(), this.page);
            int yPanel = pageViewPort.pageCmYtoPixel(pHandle1.getY(), this.page);
            LineHandleController handle = new LineHandleController(this, 1, xPanel, yPanel, handleAngle, this.p1, pageViewPort);
            handleList.add(handle);
            xPanel = pageViewPort.pageCmXtoPixel(pHandle2.getX(), this.page);
            yPanel = pageViewPort.pageCmYtoPixel(pHandle2.getY(), this.page);
            handle = new LineHandleController(this, 2, xPanel, yPanel, handleAngle, this.p2, pageViewPort);
            handleList.add(handle);
        }
    }

    public void setP1(PointDouble p) {
        this.p1 = p.getCopy();
        this.makeShape();
        if (!this.isPreviewObject()) {
            this.setDirty();
        }
    }

    public void setP2(PointDouble p) {
        this.p2 = p.getCopy();
        this.makeShape();
        if (!this.isPreviewObject()) {
            this.setDirty();
        }
    }

    public PointDouble getP1() {
        return this.p1.getCopy();
    }

    public PointDouble getP2() {
        return this.p2.getCopy();
    }

    public PointDouble getEndPoint(int pointIndex) {
        if (pointIndex == 1) {
            return this.p1.getCopy();
        }
        return this.p2.getCopy();
    }

    public void setEndPoint(int pointIndex, PointDouble p) {
        if (pointIndex == 1) {
            this.setP1(p);
        } else {
            this.setP2(p);
        }
    }

    public static String getXMLName() {
        return "line";
    }

    @Override
    public void deSerialize(Element element) {
        Double dy;
        super.deSerialize(element);
        Double dx = XMLReader.elementDoubleAttribute(element, "x1");
        if (dx != null && (dy = XMLReader.elementDoubleAttribute(element, "y1")) != null) {
            this.p1 = new PointDouble(dx, dy);
        }
        if ((dx = XMLReader.elementDoubleAttribute(element, "x2")) != null && (dy = XMLReader.elementDoubleAttribute(element, "y2")) != null) {
            this.p2 = new PointDouble(dx, dy);
        }
        this.makeShape();
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyLine.getXMLName(), parentElement);
        super.serialize(element);
        XMLWriter.addAttributeDouble(element, "x1", this.p1.x);
        XMLWriter.addAttributeDouble(element, "y1", this.p1.y);
        XMLWriter.addAttributeDouble(element, "x2", this.p2.x);
        XMLWriter.addAttributeDouble(element, "y2", this.p2.y);
        return element;
    }

    @Override
    public Eventtype[] getPossibleEvents() {
        return null;
    }
}

