/*
 * Decompiled with CFR 0.152.
 */
package document.marks;

import commands.changemarkfield.SetMarkValueCommand;
import document.marks.AbstractMarkModel;
import document.marks.IntegerMark;
import document.marks.Mark;
import document.marks.MyMarkField;

public class MarkModelAToD
extends AbstractMarkModel {
    private IntegerMark mark = new IntegerMark();
    private char[] chars1 = new char[]{'A', 'B', 'C', 'D'};
    private char[] chars2 = new char[]{'1', '2', '3', '4'};

    public MarkModelAToD(MyMarkField markfield) {
        super(markfield);
    }

    @Override
    public int getCursorPosition() {
        return 0;
    }

    @Override
    public int getInteger() {
        return this.mark.getIntValue();
    }

    @Override
    public String getText() {
        if (this.mark.getIntValue() >= 1) {
            return "" + this.chars1[this.mark.getIntValue() - 1];
        }
        return "---";
    }

    @Override
    public boolean hasCursor() {
        return false;
    }

    @Override
    public void resetInputState() {
    }

    @Override
    public boolean typeCharacter(char c) {
        int newMark = -1;
        int i = 0;
        while (i < this.chars1.length) {
            if (Character.toUpperCase(c) == this.chars1[i] || c == this.chars2[i]) {
                newMark = i + 1;
                break;
            }
            ++i;
        }
        char code = c;
        if (code == '\b' || code == '\u007f' || c == '-') {
            newMark = 0;
        }
        if (newMark != -1) {
            SetMarkValueCommand command = new SetMarkValueCommand(new Integer(newMark), this, this.markfield.getCommandManager());
            return true;
        }
        return false;
    }

    @Override
    public String getTypeString() {
        return "A ... D";
    }

    @Override
    public AbstractMarkModel getCopy(MyMarkField markfield) {
        MarkModelAToD model = new MarkModelAToD(markfield);
        model.mark = new IntegerMark();
        model.mark.setIntValue(this.mark.getIntValue());
        return model;
    }

    @Override
    public Mark getMarkObject() {
        return this.mark;
    }

    @Override
    public Object getMarkValue() {
        return this.mark.getValue();
    }

    @Override
    public void setMarkObject(Mark mark) {
        this.mark = (IntegerMark)mark;
    }

    @Override
    public void setMarkValue(Object value) {
        this.mark.setValue(value);
    }

    @Override
    public String getXMLName() {
        return "A-D";
    }

    @Override
    public void setMarkFromString(String markAsString) {
        int z = Integer.parseInt(markAsString);
        if (z >= 0 && z <= 6) {
            this.mark.setIntValue(z);
        }
    }

    @Override
    public AbstractMarkModel.MarkRange getType() {
        return AbstractMarkModel.MarkRange.mrAtoD;
    }
}

