/*
 * Decompiled with CFR 0.152.
 */
package document.marks;

import document.marks.AbstractMarkModel;
import document.marks.MarkModel1To6;
import document.marks.MarkModelAToD;
import document.marks.MarkModelSehrgutToUngenuegend;
import document.marks.MyMarkField;

public class MarkModelFactory {
    private static final int size = 3;
    private String[] XMLNames;
    private String[] TypeNames;
    private static MarkModelFactory instance;

    public static MarkModelFactory getInstance() {
        if (instance == null) {
            instance = new MarkModelFactory();
        }
        return instance;
    }

    private MarkModelFactory() {
        this.makeTypeInfo();
    }

    public AbstractMarkModel getMarkType(int index, MyMarkField markfield) {
        switch (index) {
            case 0: {
                return new MarkModel1To6(markfield);
            }
            case 1: {
                return new MarkModelSehrgutToUngenuegend(markfield);
            }
            case 2: {
                return new MarkModelAToD(markfield);
            }
        }
        return null;
    }

    public AbstractMarkModel getMarkType(String XMLName, MyMarkField markfield) {
        int i = 0;
        while (i < this.XMLNames.length) {
            if (this.XMLNames[i].compareTo(XMLName) == 0) {
                return this.getMarkType(i, markfield);
            }
            ++i;
        }
        return null;
    }

    public String[] getTypeNames() {
        return this.TypeNames;
    }

    public void makeTypeInfo() {
        this.XMLNames = new String[3];
        this.TypeNames = new String[3];
        int i = 0;
        while (i < 3) {
            AbstractMarkModel amt = this.getMarkType(i, null);
            this.TypeNames[i] = amt.getTypeString();
            this.XMLNames[i] = amt.getXMLName();
            ++i;
        }
    }

    public int getIndex(AbstractMarkModel markModel) {
        int i = 0;
        while (i < this.TypeNames.length) {
            if (this.TypeNames[i].compareTo(markModel.getTypeString()) == 0) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

