/*
 * Decompiled with CFR 0.152.
 */
package document.marks;

import commands.CommandManager;
import commands.RedoCommand;
import commands.UndoCommand;
import commands.changemarkfield.SetBoldCommand;
import data.scripting.ScrNotenfeld;
import data.scripting.ScriptableObject;
import document.AbstractKeyboardFocusable;
import document.MyDataSharingObject;
import document.MyObject;
import document.Renderable;
import document.TextStyleChangeable;
import document.events.Eventtype;
import document.marks.AbstractMarkModel;
import document.marks.BorderType;
import document.marks.Mark;
import document.marks.MarkModel1To6;
import document.marks.MarkModelFactory;
import document.marks.MarkModelSehrgutToUngenuegend;
import document.text.CursorShape;
import document.text.HorizontalAlignment;
import document.text.MyTextField;
import document.text.TextStyle;
import document.text.TextStyleFactory;
import document.text.VerticalAlignment;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.paintjobs.PaintJobPaintTextField;
import init.Settings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.math.MyMath;
import util.math.PointDouble;
import util.math.PointFloat;
import util.math.PointInt;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyMarkField
extends AbstractKeyboardFocusable
implements Renderable,
TextStyleChangeable {
    private static final Eventtype[] SCRIPTTYPES = new Eventtype[]{Eventtype.OBJECT_SETUP, Eventtype.OBJECT_LOOSE_FOCUS};
    private CommandManager commandManager = new CommandManager();
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.center;
    private VerticalAlignment verticalAlignment = VerticalAlignment.center;
    private TextStyle textStyle = TextStyleFactory.getInstance().getTextStyle("Arial", 10, Color.black, false, false, false);
    private float borderLeft = 0.1f;
    private float borderRight = 0.1f;
    private float borderTop = 0.1f;
    private float borderBottom = 0.1f;
    private PointFloat baselinestart;
    private PointFloat cursorStart;
    private PointFloat cursorEnd;
    private AbstractMarkModel markModel = new MarkModelSehrgutToUngenuegend(this);
    private boolean focus = false;
    private boolean validCharacter = false;

    public MyMarkField() {
        this.width = 1.0;
        this.height = 1.0;
        this.midX = 0.0;
        this.midY = 0.0;
        this.filling.setColorPaint(new Color(0xE0E0E0));
    }

    @Override
    public MyObject getCopy() {
        MyMarkField mf = new MyMarkField();
        super.copyTo(mf);
        mf.markModel = this.markModel.getCopy(mf);
        return mf;
    }

    @Override
    public void getHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        this.getDiagonalStretchingHandles(handleList, pageViewPort, false);
        this.getHorVertStretchingHandles(handleList, pageViewPort);
        this.getRotateHandle(handleList, pageViewPort);
    }

    @Override
    protected void makeShape() {
        this.shape = new Rectangle2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.width, this.height);
    }

    @Override
    public void render(GraphicContext gc, boolean isPreview) {
        gc.setObjectMetrics(this.midX, this.midY, this.angle, this.width, this.height);
        gc.setObjectCoordinates();
        if (this.isPainted()) {
            this.filling.setPaint(gc);
            gc.fill(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
        }
        if (this.isStroked() || isPreview) {
            this.setStroke(gc);
            if (isPreview) {
                gc.setColor(Color.black);
                gc.setStroke(new BasicStroke(1.0f / (float)gc.getTransform().getScaleX()));
            }
            gc.draw(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
        }
        String text = this.markModel.getText();
        this.calculateBaselineAndCursorCoordinates();
        gc.setFont(this.textStyle);
        gc.setColor(this.textStyle.getFontColor());
        gc.drawString(text, this.baselinestart.x, this.baselinestart.y);
        gc.setPageCoordinates();
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.markfield;
    }

    @Override
    public boolean isInside(PointDouble pPage) {
        boolean isInside;
        if (this.isInBoundigBox(pPage)) {
            MyMath.rotate(pPage, this.midX, this.midY, -this.angle);
            double x = pPage.getX();
            double y = pPage.getY();
            double halfStrokeWidth = this.getStrokeWidth() / 2.0;
            if (halfStrokeWidth < 0.05) {
                halfStrokeWidth = 0.05;
            }
            boolean inPaint = x >= this.midX - this.width / 2.0 && x <= this.midX + this.width / 2.0 && y >= this.midY - this.height / 2.0 && y <= this.midY + this.height / 2.0;
            boolean inStroke = y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth && (x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX - this.width / 2.0 + halfStrokeWidth || x >= this.midX + this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth) || x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth && (y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY - this.height / 2.0 + halfStrokeWidth || y >= this.midY + this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth);
            isInside = inPaint || inStroke;
        } else {
            isInside = false;
        }
        return isInside;
    }

    @Override
    public void ESCPressed() {
    }

    @Override
    public CursorShape getCursorShape() {
        this.calculateBaselineAndCursorCoordinates();
        CursorShape cs = new CursorShape(this.cursorStart.x, this.cursorStart.y, this.cursorEnd.x, this.cursorEnd.y, 1.0f);
        return cs;
    }

    public void calculateBaselineAndCursorCoordinates() {
        float y;
        float x;
        String text = this.markModel.getText();
        Rectangle2D bounds = this.textStyle.getStringBounds(text);
        float ascent = this.textStyle.getAscent(text);
        float descent = this.textStyle.getDescent(text);
        switch (this.horizontalAlignment) {
            case left: {
                x = this.borderLeft;
                break;
            }
            case right: {
                x = (float)(this.width - (double)this.borderRight - bounds.getWidth());
                break;
            }
            case justified: 
            case center: {
                x = (float)(this.width - bounds.getWidth()) / 2.0f;
                break;
            }
            default: {
                x = 0.0f;
            }
        }
        switch (this.verticalAlignment) {
            case center: {
                y = (float)(this.height - (this.height - (double)ascent - (double)descent) / 2.0 - (double)descent);
                break;
            }
            case bottom: {
                y = (float)(this.height - (double)this.borderBottom - (double)descent);
                break;
            }
            case top: {
                y = this.borderTop + ascent;
                break;
            }
            default: {
                y = 0.0f;
            }
        }
        PointDouble p1 = new PointDouble(x, y);
        PointDouble p2 = new PointDouble((double)x + bounds.getWidth(), y);
        PointDouble p3 = new PointDouble(x, y);
        p1 = this.objectCoordinatesToPageCoordinates(p1);
        p2 = this.objectCoordinatesToPageCoordinates(p2);
        this.cursorStart = new PointFloat(new Float(p1.x).floatValue(), new Float(p1.y).floatValue());
        this.cursorEnd = new PointFloat(new Float(p2.x).floatValue(), new Float(p2.y).floatValue());
        this.baselinestart = new PointFloat(new Float(p3.x).floatValue(), new Float(p3.y).floatValue());
    }

    @Override
    public boolean hasFocus() {
        return this.focus;
    }

    @Override
    public boolean isInTextArea(PointDouble p, double pickWidth) {
        p = this.pageCoordinatesToObjectCoordinates(p);
        return p.x >= 0.1 && p.x <= this.width - 0.1 && p.y >= 0.1 && p.y <= this.height - 0.1 && (Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.fillIn || p.x >= pickWidth && p.x <= this.width - pickWidth && p.y >= pickWidth && p.y <= this.height - pickWidth);
    }

    @Override
    public boolean keyTyped(KeyEvent e, PageViewPortController controller) {
        e.consume();
        this.setDirty();
        if (this.validCharacter) {
            this.validCharacter = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyboardpressed(KeyEvent e, PageViewPortController controller) {
        this.validCharacter = this.markModel.typeCharacter(e.getKeyChar());
        controller.updateCursor(true);
        this.addJobUpdateMarkfield(controller);
        e.consume();
        this.setDirty();
        return false;
    }

    @Override
    public void mouseLeftDown(PointDouble p, PointInt pControl, boolean shiftPressed, PageViewPortController controller) {
        controller.updateCursor(true);
    }

    @Override
    public void mouseLeftUp(PointDouble p, boolean shiftPressed, PageViewPortController controller) {
    }

    @Override
    public void mouseMoved(PointDouble p, MouseEvent e, PageViewPortController controller) {
    }

    @Override
    public void mouseRightDown(PointDouble p, boolean shiftPressed, PageViewPortController controller) {
    }

    @Override
    public void mouseRightUp(PointDouble p, PointInt pControl, boolean shiftPressed, PageViewPortController controller) {
    }

    @Override
    public boolean redoCommand() {
        RedoCommand cmd = new RedoCommand(this.commandManager);
        return true;
    }

    @Override
    public void renderActiveTextfield(GraphicContext gc, boolean onlyRenderDirtyRegions, PageViewPortController controller) {
        gc.setObjectMetrics(this.midX, this.midY, this.angle, this.width, this.height);
        gc.setObjectCoordinates();
        double lineWidth = this.getLineStyle().getLineWidth();
        if (this.hasFocus()) {
            gc.setColor(MyTextField.getActiveTextfieldColor());
        } else {
            this.filling.setPaint(gc);
        }
        gc.fill(new Rectangle2D.Double(0.0 + lineWidth / 2.0, 0.0 + lineWidth / 2.0, this.width - lineWidth, this.height - lineWidth));
        if (this.isPainted() && !this.hasFocus() && !onlyRenderDirtyRegions) {
            this.filling.setPaint(gc);
            gc.fill(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
        }
        if (this.isStroked() && !this.hasFocus()) {
            this.setStroke(gc);
            gc.draw(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
        }
        String text = this.markModel.getText();
        this.calculateBaselineAndCursorCoordinates();
        gc.setFont(this.textStyle);
        gc.setColor(this.textStyle.getFontColor());
        gc.drawString(text, this.baselinestart.x, this.baselinestart.y);
        gc.setPageCoordinates();
    }

    @Override
    public void setFocus(boolean focus, PageViewPortController controller) {
        if (focus != this.focus) {
            this.focus = focus;
            PaintJobPaintTextField job = new PaintJobPaintTextField(this, controller, !focus, false, !focus);
            controller.getPageViewport().addJob(job);
            controller.getPageViewport().repaint(controller.getPanelRect(this.midX, this.midY, this.height / 2.0, this.height / 2.0, this.width / 2.0, this.width / 2.0, this.angle, this.page));
        }
    }

    @Override
    public boolean undoCommand() {
        UndoCommand cmd = new UndoCommand(this.commandManager);
        return true;
    }

    private void addJobUpdateMarkfield(PageViewPortController controller) {
        PaintJobPaintTextField job = new PaintJobPaintTextField(this, controller, false, true, false);
        controller.getPageViewport().addJob(job);
        controller.getPageViewport().repaint(controller.getPanelRect(this.midX, this.midY, this.height / 2.0, this.height / 2.0, this.width / 2.0, this.width / 2.0, this.angle, this.page));
    }

    @Override
    public void setBold(boolean bold) {
        SetBoldCommand command = new SetBoldCommand(bold, this, this.commandManager);
        this.setDirty();
    }

    @Override
    public void setFontName(String fontname) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(fontname, this.textStyle.getSize(), this.textStyle.getFontColor(), this.textStyle.isUnderlined(), this.textStyle.isBold(), this.textStyle.isItalic());
        this.setDirty();
    }

    @Override
    public void setFontSize(int fontSize) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(this.textStyle.getFontName(), fontSize, this.textStyle.getFontColor(), this.textStyle.isUnderlined(), this.textStyle.isBold(), this.textStyle.isItalic());
        this.setDirty();
    }

    @Override
    public void setItalics(boolean italics) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(this.textStyle.getFontName(), this.textStyle.getSize(), this.textStyle.getFontColor(), this.textStyle.isUnderlined(), this.textStyle.isBold(), italics);
        this.setDirty();
    }

    @Override
    public void setUnderlined(boolean underlined) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(this.textStyle.getFontName(), this.textStyle.getSize(), this.textStyle.getFontColor(), underlined, this.textStyle.isBold(), this.textStyle.isItalic());
        this.setDirty();
    }

    @Override
    public void setFontColor(Color color) {
        this.textStyle = TextStyleFactory.getInstance().getTextStyle(this.textStyle.getFontName(), this.textStyle.getSize(), color, this.textStyle.isUnderlined(), this.textStyle.isBold(), this.textStyle.isItalic());
        this.setDirty();
    }

    @Override
    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    @Override
    public void setTextStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
        this.setDirty();
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.setDirty();
    }

    @Override
    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.setDirty();
    }

    @Override
    public float getBorder(BorderType borderType) {
        switch (borderType) {
            case left: {
                return this.borderLeft;
            }
            case right: {
                return this.borderRight;
            }
            case bottom: {
                return this.borderBottom;
            }
            case top: {
                return this.borderTop;
            }
        }
        return 0.0f;
    }

    @Override
    public void setBorder(BorderType borderType, float value) {
        if (value >= 0.0f) {
            switch (borderType) {
                case left: {
                    if (!((double)value <= this.width - (double)this.borderRight)) break;
                    this.borderLeft = value;
                    break;
                }
                case right: {
                    if (!((double)value <= this.width - (double)this.borderLeft)) break;
                    this.borderRight = value;
                    break;
                }
                case top: {
                    if (!((double)value <= this.height - (double)this.borderBottom)) break;
                    this.borderTop = value;
                    break;
                }
                case bottom: {
                    if (!((double)value <= this.height - (double)this.borderTop)) break;
                    this.borderBottom = value;
                }
            }
        }
        this.setDirty();
    }

    @Override
    public void deSerialize(Element element) {
        AbstractMarkModel amodel;
        String model;
        String mm;
        Float borderBottom;
        Float borderTop;
        Float borderRight;
        super.deSerialize(element);
        String vAlign = XMLReader.attribute(element, "verticalalignment");
        if (vAlign != null) {
            this.setVerticalAlignment(VerticalAlignment.valueOf(vAlign));
        } else {
            this.setVerticalAlignment(VerticalAlignment.center);
        }
        String hAlign = XMLReader.attribute(element, "horizontalalignment");
        if (hAlign != null) {
            this.setHorizontalAlignment(HorizontalAlignment.valueOf(hAlign));
        } else {
            this.setHorizontalAlignment(HorizontalAlignment.center);
        }
        Float borderLeft = XMLReader.elementFloatAttribute(element, "borderleft");
        if (borderLeft != null) {
            this.borderLeft = borderLeft.floatValue();
        }
        if ((borderRight = XMLReader.elementFloatAttribute(element, "borderright")) != null) {
            this.borderRight = borderRight.floatValue();
        }
        if ((borderTop = XMLReader.elementFloatAttribute(element, "bordertop")) != null) {
            this.borderTop = borderTop.floatValue();
        }
        if ((borderBottom = XMLReader.elementFloatAttribute(element, "borderbottom")) != null) {
            this.borderBottom = borderBottom.floatValue();
        }
        if ((mm = XMLReader.attribute(element, "markmodel")) != null) {
            this.markModel = MarkModelFactory.getInstance().getMarkType(mm, this);
            if (this.markModel == null) {
                this.markModel = new MarkModel1To6(this);
            }
        }
        if ((model = XMLReader.attribute(element, "markmodel")) != null && (amodel = MarkModelFactory.getInstance().getMarkType(model, this)) != null) {
            this.markModel = amodel;
        }
        this.deserializeSchuelerZeugnisData(element);
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyMarkField.getXMLName(), parentElement);
        super.serialize(element);
        XMLWriter.addAttribute(element, "verticalalignment", this.getVerticalAlignment().toString());
        XMLWriter.addAttribute(element, "horizontalalignment", this.getHorizontalAlignment().toString());
        XMLWriter.addAttributeFloat(element, "borderleft", this.borderLeft);
        XMLWriter.addAttributeFloat(element, "borderright", this.borderRight);
        XMLWriter.addAttributeFloat(element, "bordertop", this.borderTop);
        XMLWriter.addAttributeFloat(element, "borderbottom", this.borderBottom);
        XMLWriter.addAttribute(element, "markmodel", this.markModel.getXMLName());
        this.serializeSchuelerZeugnisData(element);
        return element;
    }

    public static String getXMLName() {
        return "markfield";
    }

    public AbstractMarkModel getModel() {
        return this.markModel;
    }

    public void setModel(AbstractMarkModel markmodel) {
        if (this.markModel != null && markmodel != null && this.markModel.getType() == this.markModel.getType()) {
            this.markModel.setMarkValue(this.markModel.getMarkValue());
        }
        this.markModel = markmodel;
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void setDataSource(MyDataSharingObject dataSource) {
        MyMarkField source = (MyMarkField)dataSource;
        if (dataSource != null) {
            this.markModel.setMarkObject(source.getModel().getMarkObject());
            this.dataSource = dataSource;
            dataSource.addDataSharer(this);
        } else if (this.getDataSource() != null) {
            this.markModel = MarkModelFactory.getInstance().getMarkType(this.markModel.getXMLName(), this);
            dataSource.deregisterDataSharer(this);
            this.dataSource = null;
        }
    }

    @Override
    public Object getData() {
        return this.markModel.getMarkObject();
    }

    @Override
    public void setData(Object data) {
        this.markModel.setMarkObject((Mark)data);
    }

    @Override
    public Cursor getTextCursor() {
        return Cursor.getPredefinedCursor(2);
    }

    @Override
    protected void deserializeSchuelerZeugnisData(Element element) {
        String mark = XMLReader.attribute(element, "mark");
        if (mark != null) {
            this.markModel.setMarkFromString(mark);
        }
        this.makeShape();
    }

    @Override
    public boolean hasSchuelerZeugnisData() {
        return this.getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed && this.getDataSource() == null;
    }

    @Override
    protected void serializeSchuelerZeugnisData(Element element) {
        XMLWriter.addAttribute(element, "mark", this.markModel.getMarkValue().toString());
    }

    @Override
    public Eventtype[] getPossibleEvents() {
        return SCRIPTTYPES;
    }

    @Override
    public ScriptableObject getScriptableObject() {
        return new ScrNotenfeld(this);
    }
}

