/*
 * Decompiled with CFR 0.152.
 */
package document.text;

import document.Serializable;
import document.text.AlignmentUndoInformation;
import document.text.ChunkPosition;
import document.text.HorizontalAlignment;
import document.text.TextStyle;
import document.text.TextStyleFactory;
import document.text.chunks.Chunk;
import document.text.chunks.LineBreak;
import document.text.chunks.TextChunk;
import document.text.chunks.WhiteSpace;
import document.text.menutext.TextMenu;
import document.text.textstylechanger.TextStyleChanger;
import init.Settings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.w3c.dom.Element;
import util.clipboard.ClipboardHelper;
import util.fontmanager.FontManager;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class AttributedText
implements Serializable {
    private long timeStamp = 0L;
    public ArrayList<Chunk> chunks = new ArrayList();
    private Stack<Element> textStyles = new Stack();
    private static ArrayList<Chunk> clipBoard = null;

    public AttributedText() {
        LineBreak lineBreak = new LineBreak(this);
        String fontName = FontManager.getInstance().getFirstFont();
        if (fontName == null) {
            fontName = "Arial";
        }
        lineBreak.setTextStyle(TextStyleFactory.getInstance().getTextStyle(fontName, 12, Color.black, false, false, false));
        this.chunks.add(lineBreak);
    }

    public static String getXMLName() {
        return "attributedText";
    }

    public Chunk getNextChunk(Chunk chunk) {
        int index = this.chunks.indexOf(chunk);
        if (index < this.chunks.size() - 1) {
            return this.chunks.get(index + 1);
        }
        return null;
    }

    public Chunk getPreviousChunk(Chunk chunk) {
        int index = this.chunks.indexOf(chunk);
        if (index > 0) {
            return this.chunks.get(index - 1);
        }
        return null;
    }

    public TextStyle getTextStyle(ChunkPosition chunkPosition) {
        Chunk chunk = chunkPosition.getChunk();
        Chunk previousChunk = chunk.getPreviousChunk();
        if (chunk.isLineBreak()) {
            if (previousChunk != null) {
                return previousChunk.getTextStyle();
            }
            return chunk.getTextStyle();
        }
        if (chunkPosition.getPosition() > 0 || previousChunk == null || previousChunk.isLineBreak()) {
            return chunk.getTextStyle();
        }
        return previousChunk.getTextStyle();
    }

    public TextStyle getTextStyle(int position) {
        return this.getTextStyle(this.intToChunkPosition(position));
    }

    public ChunkPosition insertAt(String s, ChunkPosition cp, TextStyle textStyle, TextMenu textMenu, boolean mergeChunks) {
        Chunk leftChunk;
        Chunk rightChunk;
        if (textStyle == null) {
            textStyle = cp.getChunk().getTextStyle();
        }
        LineBreak lineBreak = this.getNextLineBreak(cp.getChunk());
        if (cp.getPosition() == 0) {
            rightChunk = cp.getChunk();
            leftChunk = rightChunk.getPreviousChunk();
        } else {
            leftChunk = cp.getChunk();
            leftChunk.split(cp.getPosition());
            rightChunk = leftChunk.getNextChunk();
        }
        int index = leftChunk == null ? 0 : leftChunk.getIndex() + 1;
        if (rightChunk != null) {
            rightChunk.setTimeStamp(this.getTimeStamp());
        }
        int pos = 0;
        Chunk newChunk = null;
        while (pos < s.length()) {
            char c = s.charAt(pos);
            int posRight = pos;
            String part = "";
            switch (c) {
                case ' ': {
                    while (posRight < s.length() && s.charAt(posRight) == ' ') {
                        ++posRight;
                    }
                    break;
                }
                case '\n': {
                    ++posRight;
                    break;
                }
                default: {
                    while (posRight < s.length() && s.charAt(posRight) != ' ' && s.charAt(posRight) != '\n') {
                        ++posRight;
                    }
                    break block0;
                }
            }
            part = s.substring(pos, posRight);
            c = part.charAt(0);
            switch (c) {
                case ' ': {
                    newChunk = new WhiteSpace(part.length(), this);
                    break;
                }
                case '\n': {
                    newChunk = lineBreak.getCopy();
                    break;
                }
                default: {
                    newChunk = new TextChunk(part, this);
                    ((TextChunk)newChunk).setTextMenu(textMenu);
                }
            }
            newChunk.setTextStyle(textStyle);
            this.chunks.add(index, newChunk);
            ++index;
            pos = posRight;
        }
        ChunkPosition cpRight = newChunk != null ? new ChunkPosition(newChunk, newChunk.getLength()) : cp;
        if (leftChunk != null && mergeChunks) {
            leftChunk.merge(this.chunks);
        }
        if (rightChunk != null && mergeChunks) {
            rightChunk.getPreviousChunk().merge(this.chunks);
        }
        return cpRight;
    }

    public ChunkPosition insertAt(ArrayList<Chunk> chunkList, ChunkPosition cp) {
        Chunk leftChunk;
        Chunk rightChunk;
        if (cp.getPosition() == 0) {
            rightChunk = cp.getChunk();
            leftChunk = rightChunk.getPreviousChunk();
        } else {
            leftChunk = cp.getChunk();
            leftChunk.split(cp.getPosition());
            rightChunk = leftChunk.getNextChunk();
        }
        int index = leftChunk == null ? 0 : leftChunk.getIndex() + 1;
        if (rightChunk != null) {
            rightChunk.setTimeStamp(this.getTimeStamp());
        }
        Chunk copy = null;
        for (Chunk chunk : chunkList) {
            copy = chunk.getCopy();
            copy.setAttributedText(this);
            this.chunks.add(index, copy);
            if (copy.getTimeStamp() > this.timeStamp) {
                this.timeStamp = copy.getTimeStamp();
            }
            ++index;
        }
        Chunk lastInsertedChunk = copy;
        ChunkPosition cpRight = lastInsertedChunk != null ? new ChunkPosition(lastInsertedChunk, lastInsertedChunk.getLength()) : cp;
        if (leftChunk != null) {
            leftChunk.merge(this.chunks);
        }
        if (rightChunk != null) {
            rightChunk.getPreviousChunk().merge(this.chunks);
        }
        return cpRight;
    }

    public LineBreak getNextLineBreak(Chunk chunk) {
        int index = this.chunks.indexOf(chunk);
        if (index != -1) {
            return this.getNextLineBreak(index);
        }
        return null;
    }

    public LineBreak getNextLineBreak(int index) {
        LineBreak nextLineBreak = null;
        int i = index;
        while (i < this.chunks.size()) {
            if (this.chunks.get(i).isLineBreak()) {
                nextLineBreak = (LineBreak)this.chunks.get(i);
                break;
            }
            ++i;
        }
        return nextLineBreak;
    }

    public AttributedText getCopy() {
        AttributedText at = new AttributedText();
        at.insertAt(this.chunks, new ChunkPosition(at.chunks.get(0), 0));
        at.chunks.remove(at.chunks.size() - 1);
        return at;
    }

    public ChunkPosition intToChunkPosition(int position) {
        ChunkPosition cpFound = null;
        int pos = 0;
        int chunkIndex = 0;
        Chunk chunk = this.chunks.get(0);
        while (cpFound == null && chunk != null && chunkIndex < this.chunks.size()) {
            chunk = this.chunks.get(chunkIndex);
            int firstPositionInChunk = pos;
            int lastPositionInChunk = pos + chunk.getLength();
            if (firstPositionInChunk <= position && position < lastPositionInChunk) {
                cpFound = new ChunkPosition(chunk, position - firstPositionInChunk);
                continue;
            }
            pos = lastPositionInChunk;
            ++chunkIndex;
        }
        if (cpFound == null) {
            cpFound = new ChunkPosition(this.chunks.get(0), 0);
        }
        return cpFound;
    }

    public int chunkPositionToint(ChunkPosition cp) {
        int pos = 0;
        int chunkIndex = cp.getChunk().getIndex();
        int i = 0;
        while (i < chunkIndex) {
            pos += this.chunks.get(i).getLength();
            ++i;
        }
        return pos += cp.getPosition();
    }

    public ArrayList<Chunk> deleteCopySubtext(ChunkPosition from, ChunkPosition to, boolean isDelete) {
        ArrayList<Chunk> ct = new ArrayList<Chunk>();
        if (from.getChunk() == to.getChunk()) {
            if (from.getPosition() != to.getPosition()) {
                Chunk chunk = from.getChunk();
                if (chunk.isTextChunk() && isDelete) {
                    this.deleteTextMenu(((TextChunk)chunk).getTextMenu());
                }
                if ((chunk = from.getChunk().getSubChunkMid(from.getPosition(), to.getPosition())) != null) {
                    ct.add(chunk);
                }
                if (isDelete) {
                    Chunk leftChunk = from.getChunk().getSubChunkLeft(from.getPosition());
                    Chunk rightChunk = from.getChunk().getSubChunkRight(to.getPosition());
                    int index = from.getChunk().getIndex();
                    this.chunks.remove(index);
                    if (rightChunk != null) {
                        this.chunks.add(index, rightChunk);
                    }
                    if (leftChunk != null) {
                        this.chunks.add(index, leftChunk);
                    }
                    if (leftChunk != null || rightChunk != null) {
                        this.chunks.get(index).merge(this.chunks);
                    }
                }
            }
        } else {
            int i;
            Chunk chunk = from.getChunk().getSubChunkRight(from.getPosition());
            if (chunk != null) {
                ct.add(chunk);
            }
            int startIndex = from.getChunk().getIndex();
            int endIndex = to.getChunk().getIndex();
            if (isDelete) {
                i = startIndex + 1;
                while (i < endIndex) {
                    Chunk c = this.chunks.get(startIndex + 1);
                    if (c.isTextChunk()) {
                        this.deleteTextMenu(((TextChunk)c).getTextMenu());
                    }
                    ct.add(this.chunks.get(startIndex + 1));
                    this.chunks.remove(startIndex + 1);
                    ++i;
                }
            } else {
                i = startIndex + 1;
                while (i < endIndex) {
                    ct.add(this.chunks.get(i).getCopy());
                    ++i;
                }
            }
            chunk = to.getChunk().getSubChunkLeft(to.getPosition());
            if (chunk != null) {
                if (isDelete && chunk.isTextChunk()) {
                    this.deleteTextMenu(((TextChunk)chunk).getTextMenu());
                }
                ct.add(chunk);
            }
            if (isDelete) {
                int index = from.getChunk().getIndex();
                chunk = from.getChunk().getSubChunkLeft(from.getPosition());
                if (chunk != null) {
                    this.chunks.set(index, chunk);
                } else {
                    this.chunks.remove(index);
                }
                index = to.getChunk().getIndex();
                chunk = to.getChunk().getSubChunkRight(to.getPosition());
                if (chunk != null) {
                    this.chunks.set(index, chunk);
                } else {
                    this.chunks.remove(index);
                }
                if (index - 1 > 0 && index - 1 < this.chunks.size()) {
                    this.chunks.get(index - 1).merge(this.chunks);
                }
            }
        }
        return ct;
    }

    public ArrayList<Chunk> changeTextStyle(int ifrom, int ito, TextStyleChanger textStyleChanger) {
        Chunk rightChunk;
        Chunk leftChunk;
        Chunk chunk;
        int lastIndexToMerge;
        int firstIndexToMerge;
        ArrayList<Chunk> cl = new ArrayList<Chunk>();
        if (ifrom > ito) {
            int z = ifrom;
            ifrom = ito;
            ito = z;
        }
        ChunkPosition from = this.intToChunkPosition(ifrom);
        ChunkPosition to = this.intToChunkPosition(ito);
        ChunkPosition cp = to.getCopy();
        cp.normalizeStringEndTo0();
        if (cp.getChunk() == this.chunks.get(this.chunks.size() - 1)) {
            cp.getChunk().setTextStyle(textStyleChanger.changeTextStyle(cp.getChunk().getTextStyle(), TextStyleFactory.getInstance()));
        }
        if ((firstIndexToMerge = from.getChunk().getIndex() - 1) < 0) {
            firstIndexToMerge = 0;
        }
        if ((lastIndexToMerge = to.getChunk().getIndex() + 2) > this.chunks.size() - 2) {
            lastIndexToMerge = this.chunks.size() - 2;
        }
        if (from.getChunk() == to.getChunk()) {
            if (from.getPosition() != to.getPosition() && (chunk = from.getChunk().getSubChunkMid(from.getPosition(), to.getPosition())) != null) {
                cl.add(chunk.getCopy());
                chunk.setTextStyle(textStyleChanger.changeTextStyle(chunk.getTextStyle(), TextStyleFactory.getInstance()));
                leftChunk = from.getChunk().getSubChunkLeft(from.getPosition());
                rightChunk = from.getChunk().getSubChunkRight(to.getPosition());
                int index = from.getChunk().getIndex();
                this.chunks.remove(index);
                if (rightChunk != null) {
                    this.chunks.add(index, rightChunk);
                }
                if (chunk != null) {
                    this.chunks.add(index, chunk);
                }
                if (leftChunk != null) {
                    this.chunks.add(index, leftChunk);
                }
            }
        } else {
            rightChunk = from.getChunk().getSubChunkRight(from.getPosition());
            if (rightChunk != null) {
                cl.add(rightChunk.getCopy());
                rightChunk.setTextStyle(textStyleChanger.changeTextStyle(rightChunk.getTextStyle(), TextStyleFactory.getInstance()));
            }
            int startIndex = from.getChunk().getIndex();
            int endIndex = to.getChunk().getIndex();
            int i = startIndex + 1;
            while (i < endIndex) {
                Chunk ch = this.chunks.get(i);
                cl.add(ch.getCopy());
                ch.setTextStyle(textStyleChanger.changeTextStyle(ch.getTextStyle(), TextStyleFactory.getInstance()));
                ++i;
            }
            leftChunk = to.getChunk().getSubChunkLeft(to.getPosition());
            if (leftChunk != null) {
                cl.add(leftChunk.getCopy());
                leftChunk.setTextStyle(textStyleChanger.changeTextStyle(leftChunk.getTextStyle(), TextStyleFactory.getInstance()));
            }
            int index = from.getChunk().getIndex();
            chunk = from.getChunk().getSubChunkLeft(from.getPosition());
            this.chunks.remove(index);
            if (rightChunk != null) {
                this.chunks.add(index, rightChunk);
            }
            if (chunk != null) {
                this.chunks.add(index, chunk);
            }
            index = to.getChunk().getIndex();
            chunk = to.getChunk().getSubChunkRight(to.getPosition());
            this.chunks.remove(index);
            if (chunk != null) {
                this.chunks.add(index, chunk);
            }
            if (leftChunk != null) {
                this.chunks.add(index, leftChunk);
            }
        }
        int i = firstIndexToMerge;
        while (i <= lastIndexToMerge) {
            if (i >= 0 && i < this.chunks.size()) {
                this.chunks.get(i).merge(this.chunks);
            }
            ++i;
        }
        return cl;
    }

    public void undoFormatChange(ArrayList<Chunk> newChunks, int ifrom, int ito) {
        ChunkPosition from = this.intToChunkPosition(ifrom);
        ChunkPosition to = this.intToChunkPosition(ito);
        int insertPosition = this.chunkPositionToint(from);
        this.deleteCopySubtext(from, to, true);
        this.insertAt(newChunks, this.intToChunkPosition(insertPosition));
    }

    public ArrayList<Chunk> copySubText(ChunkPosition from, ChunkPosition to) {
        return this.deleteCopySubtext(from, to, false);
    }

    public ArrayList<Chunk> deleteSubText(ChunkPosition from, ChunkPosition to) {
        return this.deleteCopySubtext(from, to, true);
    }

    public int getTextLength() {
        Chunk lastChunk = this.chunks.get(this.chunks.size() - 1);
        ChunkPosition cp = new ChunkPosition(lastChunk, 0);
        return this.chunkPositionToint(cp);
    }

    public String toString() {
        String s = "";
        for (Chunk chunk : this.chunks) {
            s = String.valueOf(s) + chunk.toString() + "\n";
        }
        return s;
    }

    public ArrayList<AlignmentUndoInformation> setAlignment(HorizontalAlignment alignment, int from, int to) {
        int indexBegin;
        ArrayList<AlignmentUndoInformation> undoInfo = new ArrayList<AlignmentUndoInformation>();
        if (to != -1 && from > to) {
            int z = from;
            from = to;
            to = z;
        }
        int indexEnd = to != -1 ? this.intToChunkPosition(to).getChunk().getIndex() : this.chunks.size() - 1;
        int i = indexBegin = this.intToChunkPosition(from).getChunk().getIndex();
        while (i <= this.chunks.size() - 1) {
            Chunk chunk = this.chunks.get(i);
            if (chunk instanceof LineBreak) {
                AlignmentUndoInformation undo = new AlignmentUndoInformation(((LineBreak)chunk).getAlignment(), this.chunkPositionToint(new ChunkPosition(chunk, 0)));
                undoInfo.add(undo);
                ((LineBreak)chunk).setAlignment(alignment);
                if (to == -1 || i >= indexEnd) break;
            }
            ++i;
        }
        return undoInfo;
    }

    public void undoSetAlignment(ArrayList<AlignmentUndoInformation> undoInfo) {
        for (AlignmentUndoInformation aui : undoInfo) {
            LineBreak lb = (LineBreak)this.intToChunkPosition(aui.getPosition()).getChunk();
            lb.setAlignment(aui.getAlignment());
        }
    }

    private void deSerializeMenus(Element element) {
        ArrayList<TextMenu> menus = new ArrayList<TextMenu>();
        List<Element> elements = XMLReader.elements(element, TextMenu.getXMLName());
        for (Element childElement : elements) {
            TextMenu tm = new TextMenu();
            tm.deSerialize(childElement);
            menus.add(tm);
        }
        for (TextMenu textMenu : menus) {
            TextChunk tcfrom = (TextChunk)this.chunks.get(textMenu.getFromChunk());
            TextChunk tcto = (TextChunk)this.chunks.get(textMenu.getToChunk());
            tcfrom.setTextMenu(textMenu);
            tcfrom.setTextMenuFrom(textMenu.getFromChar());
            if (tcfrom != tcto) {
                tcto.setTextMenu(textMenu);
            }
            tcto.setTextMenuTo(textMenu.getToChar());
            if (textMenu.getToChunk() <= textMenu.getFromChunk() + 1) continue;
            int i = textMenu.getFromChunk() + 1;
            while (i < textMenu.getToChunk()) {
                Chunk c = this.chunks.get(i);
                if (c.isTextChunk()) {
                    ((TextChunk)c).setTextMenu(textMenu);
                }
                ++i;
            }
        }
    }

    @Override
    public void deSerialize(Element element) {
        TextStyle ts = new TextStyle("none", 111, new Color(65793), false, false, false);
        this.chunks.clear();
        this.deSerializeChildren(element, ts, null);
        this.deSerializeMenus(element);
    }

    private TextStyle deSerializeTag(Element element, TextStyle ts, TextStyle currentStyle) {
        String s;
        if (element.getNodeName().compareTo("i") == 0) {
            ts.setItalic(true);
            this.deSerializeChildren(element, ts, null);
            ts.setItalic(false);
        }
        if (element.getNodeName().compareTo("b") == 0) {
            ts.setBold(true);
            this.deSerializeChildren(element, ts, null);
            ts.setBold(false);
        }
        if (element.getNodeName().compareTo("u") == 0) {
            ts.setUnderlined(true);
            this.deSerializeChildren(element, ts, null);
            ts.setUnderlined(false);
        }
        if (element.getNodeName().compareTo("font") == 0) {
            String name = XMLReader.attribute(element, "name");
            String oldName = ts.getFontName();
            if (name != null) {
                ts.setFontName(name);
            }
            this.deSerializeChildren(element, ts, null);
            ts.setFontName(oldName);
        }
        if (element.getNodeName().compareTo("size") == 0) {
            Integer size = XMLReader.elementIntegerAttribute(element, "size");
            int oldSize = ts.getSize();
            if (size != null) {
                ts.setSize(size);
            }
            this.deSerializeChildren(element, ts, null);
            ts.setSize(oldSize);
        }
        if (element.getNodeName().compareTo("color") == 0) {
            Color color = XMLReader.elementColorAttribute(element, "color");
            Color oldColor = ts.getFontColor();
            if (color != null) {
                ts.setFontColor(color);
            }
            this.deSerializeChildren(element, ts, null);
            ts.setFontColor(oldColor);
        }
        if (element.getNodeName().compareTo("text") == 0) {
            String text = XMLReader.attribute(element, "t");
            if (currentStyle == null) {
                currentStyle = TextStyleFactory.getInstance().getTextStyle(ts.getFontName(), ts.getSize(), ts.getFontColor(), ts.isUnderlined(), ts.isBold(), ts.isItalic());
            }
            if (text != null) {
                s = "";
                int whiteSpaceCount = 0;
                int i = 0;
                while (i < text.length()) {
                    Chunk chunk;
                    char ch = text.charAt(i);
                    if (ch == ' ') {
                        ++whiteSpaceCount;
                        if (s.compareTo("") != 0) {
                            chunk = new TextChunk(s, this);
                            chunk.setTextStyle(currentStyle);
                            this.chunks.add(chunk);
                            s = "";
                        }
                    } else {
                        s = String.valueOf(s) + ch;
                        if (whiteSpaceCount != 0) {
                            chunk = new WhiteSpace(whiteSpaceCount, this);
                            chunk.setTextStyle(currentStyle);
                            this.chunks.add(chunk);
                            whiteSpaceCount = 0;
                        }
                    }
                    ++i;
                }
                if (s.compareTo("") != 0) {
                    TextChunk chunk = new TextChunk(s, this);
                    chunk.setTextStyle(currentStyle);
                    this.chunks.add(chunk);
                    s = "";
                }
                if (whiteSpaceCount != 0) {
                    WhiteSpace chunk = new WhiteSpace(whiteSpaceCount, this);
                    chunk.setTextStyle(currentStyle);
                    this.chunks.add(chunk);
                    whiteSpaceCount = 0;
                }
            }
        }
        if (element.getNodeName().compareTo("br") == 0) {
            if (currentStyle == null) {
                currentStyle = TextStyleFactory.getInstance().getTextStyle(ts.getFontName(), ts.getSize(), ts.getFontColor(), ts.isUnderlined(), ts.isBold(), ts.isItalic());
            }
            LineBreak chunk = new LineBreak(this);
            chunk.setTextStyle(currentStyle);
            s = XMLReader.attribute(element, "alignment");
            if (s != null) {
                chunk.setAlignmentFromString(s);
            }
            this.chunks.add(chunk);
        }
        return currentStyle;
    }

    private void deSerializeChildren(Element element, TextStyle ts, TextStyle currentStyle) {
        List<Element> elements = XMLReader.elements(element);
        for (Element child : elements) {
            currentStyle = this.deSerializeTag(child, ts, currentStyle);
        }
    }

    private void serializeMenus(Element element) {
        ArrayList<TextMenu> menus = new ArrayList<TextMenu>();
        for (Chunk chunk : this.chunks) {
            TextChunk tc;
            if (!chunk.isTextChunk() || (tc = (TextChunk)chunk).getTextMenu() == null || menus.contains(tc.getTextMenu())) continue;
            TextMenu tm = tc.getTextMenu();
            menus.add(tm);
            tm.resetChunkIndices();
        }
        TextMenu lastMenu = null;
        int i = 0;
        while (i < this.chunks.size()) {
            TextChunk tc;
            TextMenu tm;
            Chunk chunk = this.chunks.get(i);
            if (chunk.isTextChunk() && (tm = (tc = (TextChunk)chunk).getTextMenu()) != null) {
                tm.setToChunk(i);
                tm.setToChar(tc.getTextMenuTo());
                if (lastMenu != tm) {
                    tm.setFromChunk(i);
                    tm.setFromChar(tc.getTextMenuFrom());
                    lastMenu = tm;
                }
            }
            ++i;
        }
        for (TextMenu textMenu : menus) {
            textMenu.serialize(element);
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement("attributedtext", parentElement);
        this.serializeMenus(element);
        String text = "";
        TextStyle oldStyle = null;
        this.textStyles.clear();
        this.textStyles.add(element);
        for (Chunk chunk : this.chunks) {
            TextStyle newStyle = chunk.getTextStyle();
            if ((newStyle != oldStyle || chunk.isLineBreak()) && text.length() > 0) {
                Element element1 = XMLWriter.addElement("text", this.textStyles.peek());
                XMLWriter.addAttribute(element1, "t", text);
                text = "";
            }
            if (newStyle != oldStyle) {
                this.closeTextStyleTags(oldStyle, newStyle);
                this.openTextStyleTags(oldStyle, newStyle);
            }
            if (chunk.isLineBreak()) {
                chunk.serialize(this.textStyles.peek());
            } else {
                text = String.valueOf(text) + chunk.getAsString();
            }
            oldStyle = newStyle;
        }
        this.closeTextStyleTags(null, null);
        this.textStyles.clear();
        return parentElement;
    }

    private void openTextStyleTags(TextStyle oldStyle, TextStyle newStyle) {
        Element fElement;
        if (!this.tagIsOpen("font")) {
            fElement = XMLWriter.addElement("font", this.textStyles.peek());
            XMLWriter.addAttribute(fElement, "name", newStyle.getFontName());
            this.textStyles.push(fElement);
        }
        if (!this.tagIsOpen("size")) {
            fElement = XMLWriter.addElement("size", this.textStyles.peek());
            XMLWriter.addAttributeInt(fElement, "size", newStyle.getSize());
            this.textStyles.push(fElement);
        }
        if (!this.tagIsOpen("color")) {
            fElement = XMLWriter.addElement("color", this.textStyles.peek());
            XMLWriter.addAttributeColor(fElement, "color", newStyle.getFontColor());
            this.textStyles.push(fElement);
        }
        if (newStyle.isBold() && !this.tagIsOpen("b") && newStyle.isBold()) {
            fElement = XMLWriter.addElement("b", this.textStyles.peek());
            this.textStyles.push(fElement);
        }
        if (newStyle.isItalic() && !this.tagIsOpen("i") && newStyle.isItalic()) {
            fElement = XMLWriter.addElement("i", this.textStyles.peek());
            this.textStyles.push(fElement);
        }
        if (newStyle.isUnderlined() && !this.tagIsOpen("u") && newStyle.isUnderlined()) {
            fElement = XMLWriter.addElement("u", this.textStyles.peek());
            this.textStyles.push(fElement);
        }
    }

    private boolean tagIsOpen(String tagName) {
        boolean isSet = false;
        int i = 1;
        while (i < this.textStyles.size()) {
            if (((Element)this.textStyles.get(i)).getNodeName().compareTo(tagName) == 0) {
                isSet = true;
                break;
            }
            ++i;
        }
        return isSet;
    }

    private void closeTextStyleTags(TextStyle oldStyle, TextStyle newStyle) {
        if (oldStyle == null || oldStyle.getFontName().compareTo(newStyle.getFontName()) != 0) {
            this.popUntilElementName("font");
        }
        if (oldStyle == null || oldStyle.getSize() != newStyle.getSize()) {
            this.popUntilElementName("size");
        }
        if (oldStyle == null || oldStyle.getFontColor().getRGB() != newStyle.getFontColor().getRGB()) {
            this.popUntilElementName("color");
        }
        if (oldStyle == null || oldStyle.isBold() && !newStyle.isBold()) {
            this.popUntilElementName("b");
        }
        if (oldStyle == null || oldStyle.isItalic() && !newStyle.isItalic()) {
            this.popUntilElementName("i");
        }
        if (oldStyle == null || oldStyle.isUnderlined() && !newStyle.isUnderlined()) {
            this.popUntilElementName("u");
        }
    }

    private void popUntilElementName(String name) {
        while (this.textStyles.size() > 1 && this.textStyles.peek().getNodeName().compareTo(name) != 0) {
            this.textStyles.pop();
        }
        if (this.textStyles.size() > 1 && this.textStyles.peek().getNodeName().compareTo(name) == 0) {
            this.textStyles.pop();
        }
    }

    public void insertManualHyphenation(int position) {
        ChunkPosition cp = this.intToChunkPosition(position);
        if (cp.getChunk().isTextChunk()) {
            ((TextChunk)cp.getChunk()).addManualHyphenationPosition(cp.getPosition());
        } else if (cp.getPosition() == 0 && cp.getChunk().getPreviousChunk().isTextChunk()) {
            ((TextChunk)cp.getChunk().getPreviousChunk()).addManualHyphenationPosition(cp.getChunk().getPreviousChunk().getLength());
        }
    }

    public void removeManualHyphenation(int position) {
        ChunkPosition cp = this.intToChunkPosition(position);
        if (cp.getChunk().isTextChunk()) {
            ((TextChunk)cp.getChunk()).removeManualHyphenationPosition(position);
        }
    }

    public long getTimeStamp() {
        ++this.timeStamp;
        return this.timeStamp;
    }

    public long peekTimeStamp() {
        return this.timeStamp;
    }

    public String getText() {
        return AttributedText.toText(this.chunks);
    }

    public void copyToClipBoard(int fromPosition, int toPosition, boolean delete) {
        ChunkPosition from = this.intToChunkPosition(fromPosition);
        ChunkPosition to = this.intToChunkPosition(toPosition);
        clipBoard = this.deleteCopySubtext(from, to, delete);
        ClipboardHelper.getInstance().setClipboardContents(AttributedText.toText(clipBoard));
    }

    public static ArrayList<Chunk> getClipBoard() {
        return clipBoard;
    }

    public static void setClipBoard(ArrayList<Chunk> clipBoard) {
        AttributedText.clipBoard = clipBoard;
    }

    public static ArrayList<Chunk> getCopy(ArrayList<Chunk> chunks) {
        if (chunks != null) {
            ArrayList<Chunk> ret = new ArrayList<Chunk>();
            for (Chunk chunk : chunks) {
                ret.add(chunk.getCopy());
            }
            return ret;
        }
        return null;
    }

    public static String toText(ArrayList<Chunk> chunks) {
        StringBuffer buffer = new StringBuffer(1000);
        for (Chunk c : chunks) {
            buffer.append(c.getAsString());
        }
        return buffer.toString();
    }

    public void switchEditMode(Settings.ToggleEditModus editmode) {
        for (Chunk chunk : this.chunks) {
            if (!chunk.isTextChunk()) continue;
            ((TextChunk)chunk).switchEditMode(editmode);
        }
        this.getTimeStamp();
    }

    public void replaceText(String oldText, String newText) {
        Chunk oldChunk = null;
        for (Chunk chunk : this.chunks) {
            if (!chunk.isTextChunk() || ((TextChunk)chunk).getText().compareTo(oldText) != 0) continue;
            oldChunk = (TextChunk)chunk;
            break;
        }
        if (oldChunk != null) {
            ChunkPosition cp = new ChunkPosition(oldChunk.getNextChunk(), 0);
            this.chunks.remove(oldChunk);
            this.insertTextWithMenus(newText, cp, oldChunk.getTextStyle());
            this.getTimeStamp();
        }
    }

    public void deleteTextMenu(TextMenu textMenu) {
        for (Chunk chunk : this.chunks) {
            TextChunk tc;
            if (!chunk.isTextChunk() || (tc = (TextChunk)chunk).getTextMenu() != textMenu) continue;
            tc.setTextMenu(null);
        }
    }

    public int getStartOfTextMenu(TextMenu textMenu) {
        int startIndex = -1;
        int i = 0;
        while (i < this.chunks.size()) {
            Chunk chunk = this.chunks.get(i);
            if (chunk.isTextChunk() && ((TextChunk)chunk).getTextMenu() == textMenu) {
                startIndex = i;
                break;
            }
            ++i;
        }
        if (startIndex != -1) {
            return this.chunkPositionToint(new ChunkPosition(this.chunks.get(startIndex), ((TextChunk)this.chunks.get(startIndex)).getTextMenuFrom()));
        }
        return -1;
    }

    public int getEndOfTextMenu(TextMenu textMenu) {
        int endIndex = -1;
        int i = this.chunks.size() - 1;
        while (i >= 0) {
            Chunk chunk = this.chunks.get(i);
            if (chunk.isTextChunk() && ((TextChunk)chunk).getTextMenu() == textMenu) {
                endIndex = i;
                break;
            }
            --i;
        }
        if (endIndex != -1) {
            return this.chunkPositionToint(new ChunkPosition(this.chunks.get(endIndex), ((TextChunk)this.chunks.get(endIndex)).getTextMenuTo()));
        }
        return -1;
    }

    public int insertTextWithMenus(String text, int position, TextStyle textStyle) {
        return this.chunkPositionToint(this.insertTextWithMenus(text, this.intToChunkPosition(position), textStyle));
    }

    public ChunkPosition insertTextWithMenus(String text, ChunkPosition cp, TextStyle textStyle) {
        if (textStyle == null) {
            textStyle = this.getTextStyle(cp);
        }
        int p1 = 0;
        int p2 = 0;
        ScanMode scanMode = ScanMode.SCANTEXT;
        TextMenu textMenu = null;
        while (p2 < text.length()) {
            char c2 = text.charAt(p2);
            int c2next = 32;
            if (p2 + 1 < text.length()) {
                c2next = text.charAt(p2 + 1);
            }
            boolean isBeginMenu = c2 == '[' && c2next == 91;
            boolean isEndMenu = c2 == ']' && c2next == 93;
            boolean isPipe = c2 == '|' && c2next != 124;
            boolean isDoublePipe = c2 == '|' && c2next == 124;
            switch (scanMode) {
                case SCANTEXT: {
                    if (isBeginMenu) {
                        if (p2 > p1) {
                            cp = this.insertAt(text.substring(p1, p2), cp, textStyle, null, true);
                        }
                        p1 = p2 + 2;
                        p2 += 2;
                        scanMode = ScanMode.SCANNAMEORMENUITEM;
                        textMenu = new TextMenu();
                        break;
                    }
                    ++p2;
                    break;
                }
                case SCANNAMEORMENUITEM: {
                    if (isPipe) {
                        if (p2 > p1) {
                            textMenu.addItem(text.substring(p1, p2));
                        }
                        p1 = p2 + 1;
                        ++p2;
                        break;
                    }
                    if (isDoublePipe) {
                        if (p2 > p1) {
                            textMenu.setName(text.substring(p1, p2));
                        }
                        p1 = p2 + 2;
                        p2 += 2;
                        break;
                    }
                    if (isEndMenu) {
                        if (p2 > p1) {
                            textMenu.addItem(text.substring(p1, p2));
                        }
                        if (textMenu.getMenuitems().size() > 0) {
                            cp = this.insertAt(textMenu.getItem(0), cp, textStyle, textMenu, false);
                        }
                        p1 = p2 + 2;
                        p2 += 2;
                        scanMode = ScanMode.SCANTEXT;
                        break;
                    }
                    ++p2;
                    break;
                }
            }
        }
        if (scanMode == ScanMode.SCANTEXT && p2 > p1) {
            cp = this.insertAt(text.substring(p1, p2), cp, textStyle, null, true);
        }
        return cp;
    }

    private static enum ScanMode {
        SCANTEXT,
        SCANNAMEORMENUITEM;

    }
}

