/*
 * Decompiled with CFR 0.152.
 */
package document.text;

import document.text.chunks.Chunk;

public class ChunkPosition {
    private static long HASHSHIFT = 18L;
    private Chunk chunk;
    private int position;

    public ChunkPosition(Chunk textChunkOrSpace, int position) {
        this.chunk = textChunkOrSpace;
        this.position = position;
    }

    public ChunkPosition getCopy() {
        return new ChunkPosition(this.chunk, this.position);
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public void setChunk(Chunk textChunkOrSpace) {
        this.chunk = textChunkOrSpace;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public ChunkPosition getNextChunkStart() {
        return new ChunkPosition(this.chunk.getNextChunk(), 0);
    }

    public void normalizeStringEndTo0() {
        if (this.position == this.chunk.getLength() && this.chunk.getNextChunk() != null) {
            this.chunk = this.chunk.getNextChunk();
            this.position = 0;
        }
    }

    public void normalize0ToStringEnd() {
        if (this.position == 0 && this.chunk.getIndex() > 0) {
            this.chunk = this.chunk.getPreviousChunk();
            this.position = this.chunk.getLength();
        }
    }

    public ChunkPosition getNextPositionOrSame() {
        this.normalizeStringEndTo0();
        if (this.position < this.chunk.getLength() - 1) {
            ChunkPosition cp = new ChunkPosition(this.chunk, this.position + 1);
            cp.normalizeStringEndTo0();
            return cp;
        }
        if (this.chunk.getNextChunk() != null) {
            return new ChunkPosition(this.chunk.getNextChunk(), 0);
        }
        return this;
    }

    public ChunkPosition getNextPositionOrNull() {
        ChunkPosition cp = this.getNextPositionOrSame();
        if (cp == this) {
            return null;
        }
        return cp;
    }

    public ChunkPosition getPreviousPosition() {
        if (this.position > 0) {
            return new ChunkPosition(this.chunk, this.position - 1);
        }
        if (this.chunk.getPreviousChunk() != null) {
            return new ChunkPosition(this.chunk.getPreviousChunk(), this.chunk.getPreviousChunk().getLength() - 1);
        }
        return this;
    }

    public int hashCode() {
        return this.chunk.getChunkNumber() ^ this.position >>> (int)HASHSHIFT;
    }

    public boolean equals(Object obj) {
        ChunkPosition cp = (ChunkPosition)obj;
        return cp.chunk == this.chunk && cp.position == this.position;
    }

    public static long getHash(Chunk chunk, int position) {
        return chunk.getChunkNumber() ^ position >>> (int)HASHSHIFT;
    }
}

