/*
 * Decompiled with CFR 0.152.
 */
package document.text;

import commands.RedoCommand;
import commands.UndoCommand;
import commands.changetext.InsertCharactersCommand;
import data.scripting.ScrTextfeld;
import data.scripting.ScriptableObject;
import document.AbstractKeyboardFocusable;
import document.MyDataSharingObject;
import document.MyObject;
import document.Renderable;
import document.TextStyleChangeable;
import document.events.Eventtype;
import document.marks.BorderType;
import document.text.AttributedText;
import document.text.CursorShape;
import document.text.HorizontalAlignment;
import document.text.Suggestions;
import document.text.TextFieldController;
import document.text.TextFieldView;
import document.text.TextStyle;
import document.text.VerticalAlignment;
import document.text.chunks.TextChunk;
import document.text.menutext.TextMenu;
import gui.components.mainpanel.MainPanelController;
import gui.components.pageviewport.PageScrollPaneController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.GraphicContext;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.paintjobs.PaintJobPaintTextField;
import gui.components.popupmenus.contextmenu.TextContextmenuPopup;
import gui.components.popupmenus.textpopupmenu.TextPopupMenu;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import gui.icons.ViewportIcon;
import init.Settings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.math.MyMath;
import util.math.PointDouble;
import util.math.PointFloat;
import util.math.PointInt;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class MyTextField
extends AbstractKeyboardFocusable
implements Renderable,
TextFieldView,
TextStyleChangeable {
    private VerticalAlignment verticalAlignment = VerticalAlignment.top;
    private TextFieldController textfieldController;
    private GraphicContext gc;
    private TextStyle oldTextStyle;
    private static final Color additionalTextBackgroundColor = new Color(110, 40, 255);
    private static final Color activeTextfieldColor = new Color(255, 255, 240);
    private static final Color linkColor = new Color(255);
    private static final Eventtype[] SCRIPTTYPES = new Eventtype[]{Eventtype.OBJECT_SETUP, Eventtype.OBJECT_LOOSE_FOCUS, Eventtype.TEXTFIELD_CHOOSE_BEMERKUNG};
    private ViewportIcon bewareLongTextIcon = new ViewportIcon("data/img/layout/beware_long_text1.png", null, null, ViewportIcon.IconPosition.rightBorderTop, new PointDouble(0.0, 0.0), new Point(5, 5), this);
    private PageViewPortController pageViewPortController = null;
    private double lastExtraHeight = 0.0;
    private double clipExtraHeight = 0.0;

    public MyTextField() {
        this(1.0, 1.0, 1.0, 1.0, 0.0);
    }

    public MyTextField(double midx, double midy, double width, double height, double angle) {
        this.midX = midx;
        this.midY = midy;
        this.width = width;
        this.height = height;
        this.angle = angle;
        this.setTextfieldController(new TextFieldController(this));
        this.makeShape();
        this.getIcons().add(this.bewareLongTextIcon);
        this.bewareLongTextIcon.setMouseState(ViewportIcon.MouseState.invisible);
    }

    @Override
    public void copyTo(MyObject object) {
        super.copyTo(object);
        MyTextField tf = (MyTextField)object;
        this.getTextfieldController().copyTo(tf.getTextfieldController());
        tf.setVerticalAlignment(this.verticalAlignment);
        tf.bewareLongTextIcon.setMouseState(this.bewareLongTextIcon.getMouseState());
        tf.makeShape();
    }

    @Override
    public Renderable.ObjectType getType() {
        return Renderable.ObjectType.textfield;
    }

    @Override
    public boolean isInside(PointDouble pPage) {
        PointDouble unRotatedpPage = pPage.getCopy();
        boolean isInTextfield = false;
        boolean isInAdditionalSpace = false;
        MyMath.rotate(pPage, this.midX, this.midY, -this.angle);
        double x = pPage.getX();
        double y = pPage.getY();
        if (this.getTextfieldController().hasFocus()) {
            PointDouble p = new PointDouble(x - (this.midX - this.width / 2.0), y - (this.midY - this.height / 2.0));
            isInAdditionalSpace = this.getTextfieldController().getAdditionalTextRectangle().contains(p);
        }
        if (this.isInBoundigBox(unRotatedpPage)) {
            double halfStrokeWidth = this.getStrokeWidth() / 2.0;
            if (halfStrokeWidth < 0.05) {
                halfStrokeWidth = 0.05;
            }
            boolean inPaint = x >= this.midX - this.width / 2.0 && x <= this.midX + this.width / 2.0 && y >= this.midY - this.height / 2.0 && y <= this.midY + this.height / 2.0;
            boolean inStroke = y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth && (x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX - this.width / 2.0 + halfStrokeWidth || x >= this.midX + this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth) || x >= this.midX - this.width / 2.0 - halfStrokeWidth && x <= this.midX + this.width / 2.0 + halfStrokeWidth && (y >= this.midY - this.height / 2.0 - halfStrokeWidth && y <= this.midY - this.height / 2.0 + halfStrokeWidth || y >= this.midY + this.height / 2.0 - halfStrokeWidth && y <= this.midY + this.height / 2.0 + halfStrokeWidth);
            isInTextfield = inPaint || inStroke;
        } else {
            isInTextfield = false;
        }
        return this.getTextfieldController().hasFocus() && isInAdditionalSpace || isInTextfield;
    }

    @Override
    protected void makeShape() {
        this.shape = new Rectangle2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.width, this.height);
        this.setMetrics();
    }

    @Override
    public MyObject getCopy() {
        MyTextField object = new MyTextField(0.0, 0.0, 0.0, 0.0, 0.0);
        this.copyTo(object);
        return object;
    }

    @Override
    public void getHandles(ArrayList<HandleController> handleList, PageViewport pageViewPort) {
        this.getDiagonalStretchingHandles(handleList, pageViewPort, false);
        this.getHorVertStretchingHandles(handleList, pageViewPort);
        this.getRotateHandle(handleList, pageViewPort);
        this.getMoveHandle(handleList, pageViewPort);
    }

    @Override
    public void invertRectangle(Rectangle2D.Float rect) {
        this.gc.setXORMode(Color.white);
        this.gc.setColor(Color.black);
        this.gc.fill(rect);
        this.gc.setPaintMode();
    }

    @Override
    public void eraseBackground(float fromY, float toY) {
        if (this.getTextfieldController().hasFocus()) {
            Color c = this.gc.getColor();
            float bottom = this.getTextfieldController().getBottomOfTextArea();
            Rectangle2D.Double r = new Rectangle2D.Double();
            double lineWidth = this.getLineStyle().getLineWidth();
            if (fromY < bottom) {
                float to = toY <= bottom ? toY : bottom;
                ((Rectangle2D)r).setRect(0.0 + lineWidth, fromY, this.width - 2.0 * lineWidth, to - fromY);
                this.gc.setColor(activeTextfieldColor);
                this.gc.fill(r);
            }
            if (toY >= bottom) {
                float from = fromY <= bottom ? bottom : fromY;
                ((Rectangle2D)r).setRect(0.0, from, this.getTextfieldController().getWidth(), toY - from);
                this.gc.setColor(additionalTextBackgroundColor);
                this.gc.fill(r);
            }
            this.gc.setColor(c);
        }
    }

    @Override
    public void renderText(float x, float y, TextChunk textChunk, int start, int end) {
        float xp;
        boolean isLinkColor;
        String text = start > 0 || end < textChunk.getLength() ? textChunk.getText().substring(start, end) : textChunk.getText();
        if (end < textChunk.getLength()) {
            text = String.valueOf(text) + "-";
        }
        TextStyle textStyle = textChunk.getTextStyle();
        boolean bl = isLinkColor = this.gc.getColor() == linkColor;
        if (Settings.getInstance().isKerning()) {
            this.gc.drawString(text, x, y);
        } else {
            xp = x;
            int i = 0;
            while (i < text.length()) {
                if (!this.gc.isPrinter()) {
                    if (textChunk.getTextMenu() != null && i + start >= textChunk.getTextMenuFrom() && i + start <= textChunk.getTextMenuTo()) {
                        if (!isLinkColor) {
                            this.gc.setColor(linkColor);
                        }
                    } else if (isLinkColor) {
                        this.gc.setColor(Color.black);
                    }
                }
                char ch = text.charAt(i);
                String s = "" + ch;
                this.gc.drawString(s, xp, y);
                xp += textStyle.getAdvance(ch);
                ++i;
            }
        }
        if (textChunk.hasManualHyphenationPositions() && !this.gc.isPrinter()) {
            xp = x;
            ViewportGraphicContext vgc = (ViewportGraphicContext)this.gc;
            float height = (float)this.gc.getStringBounds(text).getHeight();
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                if (textChunk.isManualHyphenationPosition(i + start)) {
                    vgc.drawHyphenationLine(xp, y, y - height);
                }
                xp += textStyle.getAdvance(ch);
                ++i;
            }
        }
        if (!textChunk.isSpellingCorrect() && !this.gc.isPrinter()) {
            Color c = this.gc.getColor();
            float width = (float)this.gc.getStringBounds(text).getWidth();
            float descent = this.gc.getDescent(text);
            ViewportGraphicContext vgc = (ViewportGraphicContext)this.gc;
            vgc.drawSpellCheckLine(x, x + width, y + descent);
            this.gc.setColor(c);
        }
    }

    @Override
    public void setTextStyle(TextStyle textStyle) {
        if (textStyle != this.oldTextStyle) {
            this.oldTextStyle = textStyle;
            this.gc.setFont(textStyle);
            this.gc.setColor(textStyle.getFontColor());
        }
    }

    public void renderTextfields(GraphicContext gc) {
        this.gc = gc;
        this.oldTextStyle = null;
        gc.setObjectMetrics(this.midX, this.midY, this.angle, this.width, this.height);
        gc.setObjectCoordinates();
        Shape oldClip = gc.getClip();
        Rectangle2D boundsRect = gc.getBoundsRect2D();
        if (Math.abs(this.getAngle()) > 1.0E-6) {
            boundsRect = null;
        }
        this.getTextfieldController().render(boundsRect, false, true);
        gc.setClip(oldClip);
        this.gc = null;
    }

    private void setMetrics() {
        if (!this.isPreviewObject()) {
            this.getTextfieldController().setWidthHeight((float)this.width, (float)this.height);
            this.getTextfieldController().setTopLeft(0.0f, 0.0f);
        }
    }

    @Override
    public PointFloat mouseCoordinatesToObjectCoordinates(PointFloat mousePos) {
        PointDouble mousePosd = new PointDouble(mousePos.x, mousePos.y);
        mousePosd = this.pageCoordinatesToObjectCoordinates(mousePosd);
        PointFloat mousePosf = new PointFloat((float)mousePosd.x, (float)mousePosd.y);
        return mousePosf;
    }

    @Override
    public void render(GraphicContext gc, boolean isPreview) {
        AffineTransform OldTransform = gc.getTransform();
        gc.setPageCoordinates();
        float scale = (float)gc.getTransform().getScaleX();
        if (Math.abs(this.getAngle()) > 1.0E-4) {
            gc.rotate(-this.getAngle(), this.getMidX(), this.getMidY());
        }
        if (this.isPainted()) {
            this.setPaint(gc);
            gc.fill(this.getShape());
        }
        if (this.isStroked() || isPreview || !gc.isPrinter() && Settings.getInstance().isEditMode() && Settings.getInstance().isBlue_Frames()) {
            if (this.isStroked()) {
                this.setStroke(gc);
            } else if (!isPreview && Settings.getInstance().isBlue_Frames()) {
                gc.setColor(new Color(0x8080FF));
                gc.setStroke(new BasicStroke(1.0f / scale));
            }
            if (isPreview) {
                gc.setColor(Color.black);
                gc.setStroke(new BasicStroke(1.0f / scale));
            }
            gc.draw(this.getShape());
        }
        if (!(this.getTextfieldController().hasFocus() && !gc.isPrinter() || isPreview)) {
            this.renderTextfields(gc);
        }
        gc.setTransform(OldTransform);
    }

    @Override
    public void renderActiveTextfield(GraphicContext gc, boolean onlyRenderDirtyRegions, PageViewPortController controller) {
        this.oldTextStyle = null;
        this.gc = gc;
        this.pageViewPortController = controller;
        gc.setObjectMetrics(this.midX, this.midY, this.angle, this.width, this.height);
        gc.setObjectCoordinates();
        Rectangle2D boundsRect = gc.getBoundsRect2D();
        if (Math.abs(this.getAngle()) > 1.0E-6) {
            boundsRect = null;
        }
        if (this.textfieldController != null) {
            if (!onlyRenderDirtyRegions) {
                Rectangle2D.Float rect = new Rectangle2D.Float(this.textfieldController.getLeft(), this.textfieldController.getTop(), this.textfieldController.getLeft() + this.textfieldController.getWidth(), this.textfieldController.getTop() + this.textfieldController.getHeight());
                double lineWidth = (double)this.getLineStyle().getLineWidth() + 1.0 / gc.getTransform().getScaleX();
                if (this.hasFocus()) {
                    gc.setColor(activeTextfieldColor);
                } else {
                    gc.setColor(Color.white);
                }
                gc.fill(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
                if (this.isPainted() && !this.hasFocus()) {
                    this.filling.setPaint(gc);
                    gc.fill(rect);
                }
                if (this.isStroked()) {
                    this.setStroke(gc);
                    gc.draw(new Rectangle2D.Double(0.0, 0.0, this.width, this.height));
                }
                if (this.hasFocus()) {
                    gc.setColor(additionalTextBackgroundColor);
                    gc.fill(this.textfieldController.getAdditionalTextRectangle());
                }
            }
            this.textfieldController.render(boundsRect, onlyRenderDirtyRegions, gc.isPrinter());
        }
        ((ViewportGraphicContext)gc).setPanelCoordinates();
        this.gc = null;
    }

    public static String getXMLName() {
        return "textfield";
    }

    @Override
    public void deSerialize(Element element) {
        Element textElement;
        Float borderBottom;
        Float borderTop;
        Float borderRight;
        super.deSerialize(element);
        String vAlign = XMLReader.attribute(element, "verticalalignment");
        if (vAlign != null) {
            this.setVerticalAlignment(VerticalAlignment.valueOf(vAlign));
        } else {
            this.setVerticalAlignment(VerticalAlignment.top);
        }
        Float borderLeft = XMLReader.elementFloatAttribute(element, "borderleft");
        if (borderLeft != null) {
            this.textfieldController.setBorderLeft(borderLeft.floatValue());
        }
        if ((borderRight = XMLReader.elementFloatAttribute(element, "borderright")) != null) {
            this.textfieldController.setBorderRight(borderRight.floatValue());
        }
        if ((borderTop = XMLReader.elementFloatAttribute(element, "bordertop")) != null) {
            this.textfieldController.setBorderTop(borderTop.floatValue());
        }
        if ((borderBottom = XMLReader.elementFloatAttribute(element, "borderbottom")) != null) {
            this.textfieldController.setBorderBottom(borderBottom.floatValue());
        }
        if (this.getDataSource() == null && (textElement = XMLReader.element(element, "attributedtext")) != null) {
            this.getTextfieldController().getAttributedText().deSerialize(textElement);
            this.getTextfieldController().identifyActiveTextStyle();
        }
        this.makeShape();
        this.textfieldController.reformatWholeLayout();
        this.iconUpdateNecessary();
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(MyTextField.getXMLName(), parentElement);
        super.serialize(element);
        XMLWriter.addAttribute(element, "verticalalignment", this.getVerticalAlignment().toString());
        XMLWriter.addAttributeFloat(element, "borderleft", this.textfieldController.getBorderLeft());
        XMLWriter.addAttributeFloat(element, "borderright", this.textfieldController.getBorderRight());
        XMLWriter.addAttributeFloat(element, "bordertop", this.textfieldController.getBorderTop());
        XMLWriter.addAttributeFloat(element, "borderbottom", this.textfieldController.getBorderBottom());
        this.getTextfieldController().getAttributedText().serialize(element);
        return element;
    }

    @Override
    public void copyToPreviewObject() {
        if (this.previewObject == null) {
            this.makePreview();
        }
        MyTextField pvt = (MyTextField)this.previewObject;
        pvt.midX = this.midX;
        pvt.midY = this.midY;
        pvt.angle = this.angle;
        pvt.width = this.width;
        pvt.height = this.height;
        pvt.makeShape();
    }

    @Override
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (this.getTextfieldController() != null) {
            this.getTextfieldController().setVerticalAlignment(verticalAlignment);
        }
        this.verticalAlignment = verticalAlignment;
    }

    void setTextfieldController(TextFieldController controller) {
        this.textfieldController = controller;
        controller.setVerticalAlignment(this.verticalAlignment);
    }

    public TextFieldController getTextfieldController() {
        return this.textfieldController;
    }

    @Override
    public boolean hasFocus() {
        return this.textfieldController.hasFocus();
    }

    @Override
    public boolean keyTyped(KeyEvent e, PageViewPortController controller) {
        if (this.textfieldController.keyTyped(e)) {
            controller.updateCursor(true);
            e.consume();
            this.addJobUpdateTextfield(controller, true);
        }
        this.setDirty();
        return false;
    }

    @Override
    public boolean keyboardpressed(KeyEvent e, PageViewPortController controller) {
        boolean textfieldUpdateNecessary = this.textfieldController.keyboardpressed(e);
        if (e.getKeyCode() == 112) {
            if (MainPanelController.getInstance().isBemerkungspanelOpen()) {
                MainPanelController.getInstance().enableBemerkungsSplitPane(false);
                controller.getStateInfo().setOpenBemerkungsPanelPending(false);
            } else {
                this.fireEvent(Eventtype.TEXTFIELD_CHOOSE_BEMERKUNG);
            }
        } else {
            if (e.isConsumed()) {
                controller.updateCursor(true);
                if (textfieldUpdateNecessary) {
                    this.addJobUpdateTextfield(controller, true);
                } else {
                    controller.getCursorController().setNextPaintBlack();
                    controller.getCursorController().forceAddRepaintJobs();
                    controller.getCursorController().doRepaint();
                }
            }
            this.setDirty();
        }
        return false;
    }

    @Override
    public void mouseLeftDown(PointDouble p, PointInt pControl, boolean shiftPressed, PageViewPortController controller) {
        p = this.pageCoordinatesToObjectCoordinates(p);
        TextMenu textMenu = this.textfieldController.getTextMenu((float)p.x, (float)p.y);
        if (textMenu != null) {
            TextPopupMenu tpm = new TextPopupMenu(textMenu, controller, this);
            controller.getStateInfo().setPopupMenu(true);
            tpm.show(controller.getPageViewport(), pControl.getX(), pControl.getY());
        } else {
            this.setFocus(true, controller);
            this.textfieldController.mouseLeftDown((float)p.x, (float)p.y, shiftPressed);
            controller.updateCursor(true);
            this.addJobUpdateTextfield(controller, false);
        }
    }

    public boolean isOverMenu(PointDouble p) {
        p = this.pageCoordinatesToObjectCoordinates(p);
        return this.textfieldController.getTextMenu((float)p.x, (float)p.y) != null;
    }

    @Override
    public void mouseLeftUp(PointDouble p, boolean shiftPressed, PageViewPortController controller) {
        p = this.pageCoordinatesToObjectCoordinates(p);
        this.textfieldController.mouseLeftUp((float)p.x, (float)p.y);
        controller.updateCursor(false);
        this.addJobUpdateTextfield(controller, false);
    }

    @Override
    public void mouseMoved(PointDouble p, MouseEvent e, PageViewPortController controller) {
        if ((e.getModifiersEx() & 0x400) != 0) {
            p = this.pageCoordinatesToObjectCoordinates(p);
            this.textfieldController.mouseMoved((float)p.x, (float)p.y, e);
            controller.updateCursor(false);
            this.addJobUpdateTextfield(controller, true);
        }
    }

    @Override
    public void mouseRightDown(PointDouble p, boolean shiftPressed, PageViewPortController controller) {
    }

    @Override
    public void mouseRightUp(PointDouble p, PointInt pControl, boolean shiftPressed, PageViewPortController controller) {
        p = this.pageCoordinatesToObjectCoordinates(p);
        Suggestions suggestions = this.textfieldController.getSuggestions((float)p.x, (float)p.y);
        TextContextmenuPopup contextMenu = new TextContextmenuPopup(this, suggestions);
        contextMenu.show(controller.getPageViewport(), pControl.getX(), pControl.getY());
        controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void setFocus(boolean focus, PageViewPortController controller) {
        if (this.textfieldController.hasFocus() != focus) {
            this.textfieldController.setFocus(focus);
            PaintJobPaintTextField job = new PaintJobPaintTextField(this, controller, !focus, false, !focus);
            controller.getPageViewport().addJob(job);
        }
        this.repaint(controller, !focus);
    }

    private void addJobUpdateTextfield(PageViewPortController controller, boolean onlyPaintDirtyRegions) {
        PaintJobPaintTextField job = new PaintJobPaintTextField(this, controller, false, onlyPaintDirtyRegions, false);
        controller.getPageViewport().addJob(job);
        this.repaint(controller, true);
    }

    private void repaint(PageViewPortController controller, boolean withExtraTextHeight) {
        double extraheight = this.textfieldController.getAdditionalTextRectangle().getHeight();
        if (!withExtraTextHeight) {
            extraheight = 0.0;
        }
        if (this.lastExtraHeight > extraheight) {
            double z = extraheight;
            extraheight = this.lastExtraHeight;
            this.lastExtraHeight = z;
        } else {
            this.lastExtraHeight = extraheight;
        }
        this.clipExtraHeight = extraheight;
        double extrawidth = 0.0;
        extrawidth = controller.getPageViewport().pixelTocmX((int)extrawidth);
        controller.getPageViewport().repaint(controller.getPanelRect(this.midX, this.midY, this.height / 2.0, this.height / 2.0 + extraheight, this.width / 2.0, this.width / 2.0 + extrawidth, this.angle, this.page));
    }

    @Override
    public Rectangle2D getRealSizeRectangle() {
        return new Rectangle2D.Double(this.midX - this.width / 2.0, this.midY - this.height / 2.0, this.width, this.height + this.clipExtraHeight);
    }

    @Override
    public void ESCPressed() {
    }

    @Override
    public boolean isInTextArea(PointDouble p, double pickWidth) {
        p = this.pageCoordinatesToObjectCoordinates(p);
        double additionalHeight = this.textfieldController.hasFocus() ? this.textfieldController.getAdditionalTextRectangle().getHeight() + (double)this.textfieldController.getBorderBottom() : 0.0;
        return p.x >= (double)this.textfieldController.getBorderLeft() && p.x <= this.width - (double)this.textfieldController.getBorderRight() && p.y >= (double)this.textfieldController.getBorderTop() && p.y <= this.height - (double)this.textfieldController.getBorderBottom() + additionalHeight && (Settings.getInstance().getToggleEditModus() == Settings.ToggleEditModus.fillIn || p.x >= pickWidth && p.x <= this.width - pickWidth && p.y >= pickWidth && p.y <= this.height - (double)this.textfieldController.getBorderBottom() + additionalHeight - pickWidth);
    }

    @Override
    public CursorShape getCursorShape() {
        CursorShape cs = this.textfieldController.getCursorShape();
        PointDouble p1 = new PointDouble(cs.getX1(), cs.getY1());
        PointDouble p2 = new PointDouble(cs.getX2(), cs.getY2());
        p1 = this.objectCoordinatesToPageCoordinates(p1);
        p2 = this.objectCoordinatesToPageCoordinates(p2);
        cs.setCoordinates((float)p1.x, (float)p1.y, (float)p2.x, (float)p2.y);
        return cs;
    }

    @Override
    public boolean redoCommand() {
        RedoCommand cmd = new RedoCommand(this.textfieldController.getCommandManager());
        this.textfieldController.invalidateAndReformatWholeLayout();
        return true;
    }

    @Override
    public boolean undoCommand() {
        UndoCommand cmd = new UndoCommand(this.textfieldController.getCommandManager());
        this.textfieldController.invalidateAndReformatWholeLayout();
        return true;
    }

    public static Color getActiveTextfieldColor() {
        return activeTextfieldColor;
    }

    @Override
    public void setBold(boolean bold) {
        this.textfieldController.setBold(bold);
    }

    @Override
    public void setFontName(String fontname) {
        this.textfieldController.setFontName(fontname);
        this.setDirty();
    }

    @Override
    public void setFontSize(int fontSize) {
        this.textfieldController.setFontSize(fontSize);
        this.setDirty();
    }

    @Override
    public void setItalics(boolean italics) {
        this.textfieldController.setItalics(italics);
        this.setDirty();
    }

    @Override
    public void setUnderlined(boolean underlined) {
        this.textfieldController.setUnderlined(underlined);
        this.setDirty();
    }

    @Override
    public void setFontColor(Color color) {
        this.setDirty();
    }

    @Override
    public TextStyle getTextStyle() {
        return this.textfieldController.getActiveTextStyle();
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return HorizontalAlignment.left;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.textfieldController.setHorizontalAlignment(horizontalAlignment);
        this.setDirty();
    }

    @Override
    public float getBorder(BorderType borderType) {
        switch (borderType) {
            case left: {
                return this.textfieldController.getBorderLeft();
            }
            case right: {
                return this.textfieldController.getBorderRight();
            }
            case top: {
                return this.textfieldController.getBorderTop();
            }
            case bottom: {
                return this.textfieldController.getBorderBottom();
            }
        }
        return 0.0f;
    }

    @Override
    public void setBorder(BorderType borderType, float value) {
        switch (borderType) {
            case left: {
                if (!(value >= 0.0f) || !((double)value <= this.width - (double)this.getBorder(BorderType.right))) break;
                this.textfieldController.setBorderLeft(value);
                break;
            }
            case right: {
                if (!(value >= 0.0f) || !((double)value <= this.width - (double)this.getBorder(BorderType.left))) break;
                this.textfieldController.setBorderRight(value);
                break;
            }
            case top: {
                if (!(value >= 0.0f) || !((double)value <= this.height - (double)this.getBorder(BorderType.bottom))) break;
                this.textfieldController.setBorderTop(value);
                break;
            }
            case bottom: {
                if (!(value >= 0.0f) || !((double)value <= this.height - (double)this.getBorder(BorderType.top))) break;
                this.textfieldController.setBorderBottom(value);
                break;
            }
        }
        this.textfieldController.setWidthHeight((float)this.width, (float)this.height);
        this.textfieldController.invalidateAndReformatWholeLayout();
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void setDataSource(MyDataSharingObject dataSource) {
        if (dataSource != null && dataSource instanceof MyTextField) {
            this.textfieldController.setAttributedText(((MyTextField)dataSource).getTextfieldController().getAttributedText());
            this.dataSource = dataSource;
            dataSource.registerDataSharer(this);
        } else if (this.getDataSource() != null && dataSource == null) {
            this.getDataSource().deregisterDataSharer(this);
            this.textfieldController.setAttributedText(new AttributedText());
            this.dataSource = null;
        }
    }

    @Override
    public Object getData() {
        return this.textfieldController.getAttributedText();
    }

    @Override
    public void setData(Object data) {
        this.textfieldController.setAttributedText((AttributedText)data);
    }

    private boolean hasAdditionalText() {
        return this.textfieldController.hasAdditionalText();
    }

    @Override
    public boolean iconUpdateNecessary() {
        boolean ret;
        if (this.hasAdditionalText()) {
            ret = this.bewareLongTextIcon.getMouseState() != ViewportIcon.MouseState.normal;
            this.bewareLongTextIcon.setMouseState(ViewportIcon.MouseState.normal);
        } else {
            ret = this.bewareLongTextIcon.getMouseState() != ViewportIcon.MouseState.invisible;
            this.bewareLongTextIcon.setMouseState(ViewportIcon.MouseState.invisible);
        }
        return ret;
    }

    @Override
    public boolean hasMarking() {
        return this.textfieldController.isMarkingActive();
    }

    @Override
    public void copyTextToClipboard(boolean deleteCopiedText) {
        this.textfieldController.copyToClipboard(deleteCopiedText);
    }

    @Override
    public void pasteTextFromClipboard() {
        this.textfieldController.pasteTextFromClipboard(false);
    }

    @Override
    public Cursor getTextCursor() {
        return Cursor.getPredefinedCursor(2);
    }

    public void switchEditMode(Settings.ToggleEditModus editmode) {
        this.textfieldController.getAttributedText().switchEditMode(editmode);
    }

    @Override
    public void restoreBackground(float fromY, float toY) {
        PageViewport pageViewport = this.pageViewPortController.getPageViewport();
        fromY = (float)((double)fromY + (this.midY - this.height / 2.0));
        toY = (float)((double)toY + (this.midY - this.height / 2.0));
        double midYRect = (fromY + toY) / 2.0f;
        Rectangle r = this.pageViewPortController.getPanelRect(this.midX, midYRect, midYRect - (double)fromY, (double)toY - midYRect, this.width / 2.0, this.width / 2.0, 0.0, this.page);
        ((ViewportGraphicContext)this.gc).setPanelCoordinates();
        PointDouble p = new PointDouble(this.midX - this.width / 2.0, this.midY - this.height / 2.0);
        p = pageViewport.pageCmToPixel(p, this.page);
        this.gc.translate(-((int)p.x), -((int)p.y));
        this.pageViewPortController.getPageViewport().repaintRectangleWithBackgroundimage(r, this.gc);
        this.gc.translate((int)p.x, (int)p.y);
        ((ViewportGraphicContext)this.gc).setObjectCoordinates();
    }

    @Override
    public void underline(float fromX, float toX, float y, float width) {
        Line2D.Float line = new Line2D.Float(fromX, y, toX, y);
        this.gc.setStroke(new BasicStroke(width));
        this.gc.draw(line);
    }

    @Override
    protected void deserializeSchuelerZeugnisData(Element element) {
        if (this.getDataSource() == null) {
            this.getTextfieldController().getAttributedText().deSerialize(element);
            this.getTextfieldController().identifyActiveTextStyle();
        }
        this.makeShape();
        this.textfieldController.reformatWholeLayout();
        this.iconUpdateNecessary();
    }

    @Override
    public boolean hasSchuelerZeugnisData() {
        return this.getIsEditingAllowedInFillinModus() == MyObject.EditingAllowedInFillinModus.allowed && this.getDataSource() == null;
    }

    @Override
    protected void serializeSchuelerZeugnisData(Element element) {
        this.getTextfieldController().getAttributedText().serialize(element);
    }

    @Override
    public Eventtype[] getPossibleEvents() {
        return SCRIPTTYPES;
    }

    @Override
    public ScriptableObject getScriptableObject() {
        return new ScrTextfeld(this);
    }

    public void replaceText(String oldText, String newText) {
        this.textfieldController.getAttributedText().replaceText(oldText, newText);
    }

    public void insert(Suggestions suggestions, String s) {
        InsertCharactersCommand cmd = new InsertCharactersCommand(suggestions.getReplaceFrom(), this.textfieldController.getCursorPos(), this.textfieldController.getCursorPos(), suggestions.getReplaceFrom(), suggestions.getReplaceTo(), s, null, this.textfieldController, this.textfieldController.getCommandManager(), null);
        if (!this.hasFocus()) {
            DocumentTabbedPaneController.getInstance().getTabbedPane().repaint();
        } else {
            PageScrollPaneController spc = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController();
            PageViewPortController vpc = spc.getPageViewPortController();
            vpc.updateCursor(true);
            vpc.addJobPaintActiveTextfield(false);
        }
    }
}

