/*
 * Decompiled with CFR 0.152.
 */
package document.text;

import document.text.CursorShape;
import document.text.DeviceIndependentFontMetrics;
import init.Settings;
import java.awt.Color;
import java.awt.Font;
import util.fontmanager.FontManager;
import util.math.PointFloat;

public class TextStyle
extends DeviceIndependentFontMetrics {
    private int size;
    private Color fontColor;
    private boolean isUnderlined;
    private boolean isBold;
    private boolean isItalic;
    private float[] characterAdvance = new float[256];

    public TextStyle(String fontName, int size, Color fontColor, boolean isUnderlined, boolean isBold, boolean isItalic) {
        int i = 0;
        while (i < this.characterAdvance.length) {
            this.characterAdvance[i] = -1001.0f;
            ++i;
        }
        this.fontName = fontName;
        this.size = size;
        this.fontColor = fontColor;
        this.isUnderlined = isUnderlined;
        this.isBold = isBold;
        this.isItalic = isItalic;
        this.setFont(fontName, size, isBold, isItalic);
    }

    public float getAdvance(char ch) {
        float advance;
        char index = ch;
        if (index >= '\u0000' && index < this.characterAdvance.length) {
            if (this.characterAdvance[index] > -999.0f) {
                advance = this.characterAdvance[index];
            } else {
                this.characterAdvance[index] = advance = this.getStringAdvance("" + ch);
            }
        } else {
            advance = this.getStringAdvance("" + ch);
        }
        return advance;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public boolean isUnderlined() {
        return this.isUnderlined;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getSize() {
        return this.size;
    }

    public float getUnderlineThickness() {
        return this.getLineMetrics("Text").getUnderlineThickness();
    }

    public float getUnderlineOffset() {
        return this.getLineMetrics("Text").getUnderlineOffset();
    }

    public CursorShape getCursorShape(PointFloat p) {
        if (p != null) {
            float slope = this.isItalic ? 0.2f : 0.0f;
            float ascent = this.getAscent("Mg");
            float descent = this.getDescent("Mg");
            float x2 = p.x + ascent * slope;
            float y2 = p.y - ascent;
            float x1 = p.x - descent * slope;
            float y1 = p.y + descent;
            CursorShape shape = new CursorShape(x1, y1, x2, y2, 0.05f);
            return shape;
        }
        return new CursorShape(0.0f, 0.0f, 0.0f, 0.0f, 0.05f);
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void setUnderlined(boolean isUnderlined) {
        this.isUnderlined = isUnderlined;
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
    }

    public void setItalic(boolean isItalic) {
        this.isItalic = isItalic;
    }

    public float getStringWidth(String text, int startPosition, int endPosition) {
        if (Settings.getInstance().isKerning()) {
            return this.getStringAdvance(text, startPosition, endPosition);
        }
        float width = 0.0f;
        int i = startPosition;
        while (i < endPosition) {
            width += this.getAdvance(text.charAt(i));
            ++i;
        }
        return width;
    }

    public Font getPdfFont() {
        int style = 0;
        if (this.isBold) {
            style |= 1;
        }
        if (this.isItalic) {
            style |= 2;
        }
        return FontManager.getInstance().getPdfFont(this.fontName, style, this.size);
    }
}

