/*
 * Decompiled with CFR 0.152.
 */
package document.text.chunks;

import document.text.AttributedText;
import document.text.ChunkPosition;
import document.text.DeviceIndependentFontMetrics;
import document.text.HorizontalAlignment;
import document.text.Line;
import document.text.chunks.Chunk;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import org.w3c.dom.Element;
import util.math.PointFloat;

public class WhiteSpace
extends Chunk {
    private int numberOfWhiteSpaces = 1;

    public WhiteSpace(int numberOfWhiteSpaces, AttributedText attributedText) {
        super(attributedText);
        this.type = Chunk.ChunkType.whitespace;
        this.numberOfWhiteSpaces = numberOfWhiteSpaces;
        this.calculateMetrics();
    }

    @Override
    public void calculateMetrics() {
        this.width = this.textStyle.getWhiteSpaceWidth() * (float)this.numberOfWhiteSpaces;
        TextLayout tl = this.textStyle.getTextLayout("M");
        this.ascent = tl.getAscent() * DeviceIndependentFontMetrics.getCmFactor();
        this.descent = tl.getDescent() * DeviceIndependentFontMetrics.getCmFactor();
        this.leading = tl.getLeading() * DeviceIndependentFontMetrics.getCmFactor();
        this.advance = tl.getAdvance() * DeviceIndependentFontMetrics.getCmFactor();
        this.setDirty();
    }

    public int getNumberOfWhiteSpaces() {
        return this.numberOfWhiteSpaces;
    }

    public void setNumberOfWhiteSpaces(int numberOfWhiteSpaces) {
        this.numberOfWhiteSpaces = numberOfWhiteSpaces;
        this.calculateMetrics();
    }

    @Override
    public int getLength() {
        return this.numberOfWhiteSpaces;
    }

    @Override
    public void split(int position) {
        if (position != 0 && position != this.getLength()) {
            WhiteSpace rightChunk = new WhiteSpace(this.getLength() - position, this.attributedText);
            rightChunk.setTextStyle(this.textStyle);
            this.numberOfWhiteSpaces = position;
            int index = this.attributedText.chunks.indexOf(this);
            this.attributedText.chunks.add(index + 1, rightChunk);
            this.calculateMetrics();
        }
    }

    @Override
    public void merge(ArrayList<Chunk> chunks) {
        Chunk nextChunk = null;
        int index = chunks.indexOf(this);
        if (index >= 0 && index < chunks.size() - 1) {
            nextChunk = chunks.get(index + 1);
        }
        if (nextChunk != null && nextChunk.isWhiteSpace() && nextChunk.textStyle == this.textStyle) {
            this.numberOfWhiteSpaces += ((WhiteSpace)nextChunk).getNumberOfWhiteSpaces();
            this.calculateMetrics();
            chunks.remove(nextChunk);
        }
    }

    @Override
    public Chunk getCopyOfPart(int fromPosition, int toPosition) {
        WhiteSpace copy = new WhiteSpace(toPosition - fromPosition, this.attributedText);
        copy.setTextStyle(this.textStyle);
        copy.calculateMetrics();
        return copy;
    }

    @Override
    public Chunk getCopy() {
        WhiteSpace copy = new WhiteSpace(this.numberOfWhiteSpaces, this.attributedText);
        copy.setTextStyle(this.textStyle);
        copy.calculateMetrics();
        return copy;
    }

    @Override
    public ChunkPosition getHitPosition(float x, float y, Line line, float chunkX, float chunkBaseline, int startPos) {
        float whiteSpaceWidth = line.getAlignment() == HorizontalAlignment.justified ? line.getJustifiedWhiteSpaceWidth() : this.textStyle.getWhiteSpaceWidth();
        int charIndex = Math.round((x - chunkX) / whiteSpaceWidth);
        if (charIndex < 0) {
            charIndex = 0;
        }
        if (charIndex > this.numberOfWhiteSpaces) {
            charIndex = this.numberOfWhiteSpaces;
        }
        return new ChunkPosition(this, charIndex);
    }

    @Override
    public PointFloat getPosition(float xp, float yp, int position, Line line) {
        float whiteSpaceWidth = line.getAlignment() == HorizontalAlignment.justified ? line.getJustifiedWhiteSpaceWidth() : this.textStyle.getWhiteSpaceWidth();
        PointFloat pos = new PointFloat(xp + (float)position * whiteSpaceWidth, yp);
        return pos;
    }

    @Override
    public Chunk getSubChunkLeft(int toPosition) {
        if (toPosition > 0) {
            WhiteSpace ws = (WhiteSpace)this.getCopy();
            ws.setNumberOfWhiteSpaces(toPosition);
            return ws;
        }
        return null;
    }

    @Override
    public Chunk getSubChunkMid(int fromPosition, int toPosition) {
        if (toPosition > 0 && fromPosition < this.getLength() && toPosition > fromPosition) {
            WhiteSpace ws = (WhiteSpace)this.getCopy();
            ws.setNumberOfWhiteSpaces(toPosition - fromPosition);
            return ws;
        }
        return null;
    }

    @Override
    public Chunk getSubChunkRight(int fromPosition) {
        if (fromPosition < this.getLength()) {
            WhiteSpace ws = (WhiteSpace)this.getCopy();
            ws.setNumberOfWhiteSpaces(this.getLength() - fromPosition);
            return ws;
        }
        return null;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.getIndex() + " WS: " + super.toString() + " " + "length: " + this.getLength();
        return s;
    }

    @Override
    public void deSerialize(Element element) {
    }

    @Override
    public Element serialize(Element parentElement) {
        return null;
    }

    @Override
    public String getAsString() {
        String s = "";
        int i = 1;
        while (i <= this.numberOfWhiteSpaces) {
            s = String.valueOf(s) + " ";
            ++i;
        }
        return s;
    }
}

