/*
 * Decompiled with CFR 0.152.
 */
package document.view;

import document.Serializable;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import gui.components.pageviewport.ruler.RulerInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;
import org.w3c.dom.Element;
import util.math.PointDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class ArtificialLine
implements Serializable {
    private RulerInfo.Direction direction = RulerInfo.Direction.vertical;
    private PointDouble position;
    public static Color artificialLineColor = new Color(0x8080FF);
    private static Color activeArtificialLineColor = new Color(0x80FF80);
    private static float[] dashs = new float[]{3.0f, 3.0f};
    private boolean active = false;

    public ArtificialLine(RulerInfo.Direction direction, Origin origin, double offset, double pageWidth, double pageHeight) {
        this.direction = direction;
        this.calculatePosition(direction, origin, offset, pageWidth, pageHeight);
    }

    private void calculatePosition(RulerInfo.Direction direction, Origin origin, double offset, double pageWidth, double pageHeight) {
        this.position = new PointDouble(offset, offset);
        switch (origin) {
            case topleft: {
                break;
            }
            case center: {
                this.position.x += pageWidth / 2.0;
                this.position.y += pageHeight / 2.0;
                break;
            }
            case bottomright: {
                this.position.x = pageWidth - this.position.x;
                this.position.y = pageHeight - this.position.y;
                break;
            }
        }
    }

    public static void setStrokeForArtificialLines(ViewportGraphicContext vgc) {
        vgc.setColor(artificialLineColor);
        ArtificialLine.setStroke(vgc);
    }

    public static void setStrokeForActiveArtificialLines(ViewportGraphicContext vgc) {
        vgc.setColor(activeArtificialLineColor);
        ArtificialLine.setStroke(vgc);
    }

    private static void setStroke(ViewportGraphicContext vgc) {
        double pixelWidth = 1.0 / vgc.getTransform().getScaleX();
        ArtificialLine.dashs[0] = (float)(3.0 * pixelWidth);
        ArtificialLine.dashs[1] = (float)(3.0 * pixelWidth);
        vgc.setStroke(new BasicStroke((float)pixelWidth, 0, 0, 1.0f, dashs, 0.0f));
    }

    public void drawLine(ViewportGraphicContext gc, boolean onlyifactive) {
        if (!onlyifactive || this.active) {
            Line2D.Float line;
            switch (this.direction) {
                case horizontal: {
                    line = new Line2D.Float(0.0f, (float)this.position.y, (float)gc.getPageWidthCm(), (float)this.position.y);
                    break;
                }
                case vertical: {
                    line = new Line2D.Float((float)this.position.x, 0.0f, (float)this.position.x, (float)gc.getPageHeightCm());
                    break;
                }
                default: {
                    line = null;
                }
            }
            gc.draw(line);
        }
    }

    public void snap(PointDouble positionToSnap, PointDouble positionToAlter, SnapInfo snapInfo, double delta) {
        switch (this.direction) {
            case horizontal: {
                if (!(Math.abs(positionToSnap.y - this.position.y) < delta) || snapInfo.yCoordinateGotSnapped) break;
                positionToAlter.y += this.position.y - positionToSnap.y;
                snapInfo.yCoordinateGotSnapped = true;
                this.active = true;
                break;
            }
            case vertical: {
                if (!(Math.abs(positionToSnap.x - this.position.x) < delta) || snapInfo.xCoordinateGotSnapped) break;
                positionToAlter.x += this.position.x - positionToSnap.x;
                snapInfo.xCoordinateGotSnapped = true;
                this.active = true;
                break;
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public RulerInfo.Direction getDirection() {
        return this.direction;
    }

    public PointDouble getPosition() {
        return this.position;
    }

    public double getPositionDouble() {
        if (this.direction == RulerInfo.Direction.horizontal) {
            return this.position.y;
        }
        return this.position.x;
    }

    public void setPosition(PointDouble position) {
        this.position = position;
    }

    public void setPosition(double position) {
        if (this.direction == RulerInfo.Direction.horizontal) {
            this.setPosition(new PointDouble(0.0, position));
        } else {
            this.setPosition(new PointDouble(position, 0.0));
        }
    }

    @Override
    public void deSerialize(Element element) {
        Double posY;
        Double posX;
        String dir = XMLReader.attribute(element, "direction");
        if (dir != null) {
            this.direction = RulerInfo.Direction.valueOf(dir);
        }
        if ((posX = XMLReader.elementDoubleAttribute(element, "positionx")) != null) {
            this.position.x = posX;
        }
        if ((posY = XMLReader.elementDoubleAttribute(element, "positiony")) != null) {
            this.position.y = posY;
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(ArtificialLine.getXMLName(), parentElement);
        XMLWriter.addAttribute(element, "direction", this.direction.toString());
        XMLWriter.addAttributeDouble(element, "positionx", this.position.x);
        XMLWriter.addAttributeDouble(element, "positiony", this.position.y);
        return null;
    }

    public static String getXMLName() {
        return "aline";
    }

    public ArtificialLine getCopy() {
        ArtificialLine al = new ArtificialLine(this.direction, Origin.topleft, 0.0, 19.0, 29.0);
        al.position = this.position.getCopy();
        al.active = this.active;
        return al;
    }

    public static enum Origin {
        topleft,
        center,
        bottomright;

    }
}

