/*
 * Decompiled with CFR 0.152.
 */
package document.view;

import document.Serializable;
import document.view.ArtificialLine;
import document.view.MyView;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import gui.components.pageviewport.ruler.RulerInfo;
import gui.components.pageviewport.ruler.RulerMarkSource;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import util.math.PointDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class ArtificialLines
implements RulerMarkSource,
Serializable {
    private ArrayList<ArtificialLine> artificialLinesHor = new ArrayList();
    private ArrayList<ArtificialLine> artificialLinesVert = new ArrayList();
    private MyView view;

    public ArtificialLines(MyView view) {
        this.view = view;
    }

    public void addArtificialLine(ArtificialLine artificialLine) {
        if (artificialLine.getDirection() == RulerInfo.Direction.horizontal) {
            this.artificialLinesHor.add(artificialLine);
        } else {
            this.artificialLinesVert.add(artificialLine);
        }
    }

    public void addArtificialLine(RulerInfo.Direction direction, ArtificialLine.Origin origin, double offset) {
        ArtificialLine al = new ArtificialLine(direction, origin, offset, this.view.getMaxPageWidth(), this.view.getMaxPageHeight());
        this.addArtificialLine(al);
    }

    public void snapAtArtificialLines(PointDouble p, PointDouble positionToAlter, SnapInfo snapInfo, double delta) {
        for (ArtificialLine al : this.artificialLinesHor) {
            al.snap(p, positionToAlter, snapInfo, delta);
        }
        for (ArtificialLine al : this.artificialLinesVert) {
            al.snap(p, positionToAlter, snapInfo, delta);
        }
    }

    public void drawArtificialLines(ViewportGraphicContext vgc, boolean onlyIfActive) {
        if (onlyIfActive) {
            ArtificialLine.setStrokeForActiveArtificialLines(vgc);
        } else {
            ArtificialLine.setStrokeForArtificialLines(vgc);
        }
        for (ArtificialLine al : this.artificialLinesHor) {
            al.drawLine(vgc, onlyIfActive);
        }
        for (ArtificialLine al : this.artificialLinesVert) {
            al.drawLine(vgc, onlyIfActive);
        }
    }

    public void setAllArtificialLinesInactive() {
        for (ArtificialLine artificialLine : this.artificialLinesHor) {
            artificialLine.setActive(false);
        }
        for (ArtificialLine artificialLine : this.artificialLinesVert) {
            artificialLine.setActive(false);
        }
    }

    @Override
    public void deleteRulerMark(RulerInfo.Direction direction, int index) {
        ArrayList<ArtificialLine> all = direction == RulerInfo.Direction.horizontal ? this.artificialLinesHor : this.artificialLinesVert;
        all.remove(index);
    }

    @Override
    public void drawRulerMark(int posPixelX, int posPixelY, Graphics2D g2d) {
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(2.0f));
        Line2D.Float line = new Line2D.Float(posPixelX, posPixelY - 4, posPixelX, posPixelY);
        g2d.draw(line);
        line = new Line2D.Float(posPixelX - 2, posPixelY - 1, posPixelX + 2, posPixelY - 1);
        g2d.draw(line);
    }

    @Override
    public void moveRulerMark(RulerInfo.Direction direction, int index, double newPosition) {
        this.getArrayList(direction).get(index).setPosition(newPosition);
    }

    private ArrayList<ArtificialLine> getArrayList(RulerInfo.Direction direction) {
        if (direction == RulerInfo.Direction.horizontal) {
            return this.artificialLinesHor;
        }
        return this.artificialLinesVert;
    }

    @Override
    public int getRulerMarkCount(RulerInfo.Direction direction) {
        return this.getArrayList(direction).size();
    }

    @Override
    public int getRulerMarkIndex(RulerInfo.Direction direction, double position, double delta) {
        int index = -1;
        ArrayList<ArtificialLine> all = this.getArrayList(direction);
        int i = 0;
        while (i < all.size()) {
            ArtificialLine al = all.get(i);
            if (Math.abs(al.getPositionDouble() - position) < delta) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    @Override
    public double getRulerMarkPosition(RulerInfo.Direction direction, int index) {
        return this.getArrayList(direction).get(index).getPositionDouble();
    }

    @Override
    public void deSerialize(Element element) {
        List<Element> elements = XMLReader.elements(element);
        for (Element childElement : elements) {
            if (childElement.getNodeName().compareTo(ArtificialLine.getXMLName()) != 0) continue;
            ArtificialLine al = new ArtificialLine(RulerInfo.Direction.horizontal, ArtificialLine.Origin.topleft, 0.0, 10.0, 10.0);
            al.deSerialize(childElement);
            if (al.getDirection() == RulerInfo.Direction.horizontal) {
                this.artificialLinesHor.add(al);
                continue;
            }
            this.artificialLinesVert.add(al);
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(ArtificialLines.getXMLName(), parentElement);
        for (ArtificialLine artificialLine : this.artificialLinesHor) {
            artificialLine.serialize(element);
        }
        for (ArtificialLine artificialLine : this.artificialLinesVert) {
            artificialLine.serialize(element);
        }
        return element;
    }

    public static String getXMLName() {
        return "alines";
    }

    public ArtificialLines getCopy(MyView newView) {
        ArtificialLines al = new ArtificialLines(newView);
        for (ArtificialLine aline : this.artificialLinesHor) {
            al.artificialLinesHor.add(aline.getCopy());
        }
        for (ArtificialLine aline : this.artificialLinesVert) {
            al.artificialLinesVert.add(aline.getCopy());
        }
        return al;
    }
}

