/*
 * Decompiled with CFR 0.152.
 */
package document.view;

import commands.SetBorderOfViewCommand;
import document.Serializable;
import document.view.MyView;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import gui.components.pageviewport.ruler.RulerInfo;
import gui.components.pageviewport.ruler.RulerMarkSource;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.w3c.dom.Element;
import util.math.PointDouble;
import util.xml.XMLReader;
import util.xml.XMLWriter;

public class Borders
implements Serializable,
RulerMarkSource {
    private float[] bordersHor = new float[]{2.0f, 2.0f};
    private float[] bordersVert = new float[]{1.0f, 1.0f};
    private boolean[] active = new boolean[4];
    private static final Color borderLineColor = new Color(0xE0E0FF);
    private static final Color activeBorderLineColor = Color.black;
    private static final float[] dashs = new float[2];
    private MyView view;

    public Borders(MyView view) {
        this.view = view;
        this.setAllBorderLinesInactive();
    }

    public void drawBorderLines(ViewportGraphicContext vgc, boolean onlyIfActive) {
        Line2D.Float line;
        float pixelWidth = 1.0f / (float)vgc.getTransform().getScaleX();
        float height = (float)vgc.getPageHeightCm();
        float width = (float)vgc.getPageWidthCm();
        if (onlyIfActive) {
            vgc.setColor(activeBorderLineColor);
            Borders.dashs[0] = 3.0f * pixelWidth;
            Borders.dashs[1] = 3.0f * pixelWidth;
            vgc.setStroke(new BasicStroke(pixelWidth, 0, 0, 1.0f, dashs, 0.0f));
        } else {
            vgc.setColor(borderLineColor);
            vgc.setStroke(new BasicStroke(pixelWidth));
        }
        if (this.active[0] || !onlyIfActive) {
            line = new Line2D.Float(this.getLeft(), 0.0f, this.getLeft(), height);
            vgc.draw(line);
        }
        if (this.active[1] || !onlyIfActive) {
            line = new Line2D.Float(width - this.getRight(), 0.0f, width - this.getRight(), height);
            vgc.draw(line);
        }
        if (this.active[2] || !onlyIfActive) {
            line = new Line2D.Float(0.0f, this.getTop(), width, this.getTop());
            vgc.draw(line);
        }
        if (this.active[3] || !onlyIfActive) {
            line = new Line2D.Float(0.0f, height - this.getBottom(), width, height - this.getBottom());
            vgc.draw(line);
        }
    }

    public void snap(SnapInfo snapInfo, PointDouble p, PointDouble positionToAlter, double delta) {
        if (!snapInfo.xCoordinateGotSnapped && Math.abs(p.x - (double)this.getLeft()) < delta) {
            positionToAlter.x += (double)this.getLeft() - p.x;
            snapInfo.xCoordinateGotSnapped = true;
            this.active[0] = true;
        }
        if (!snapInfo.xCoordinateGotSnapped && Math.abs(p.x - (double)this.getRightAbsolute()) < delta) {
            positionToAlter.x += (double)this.getRightAbsolute() - p.x;
            snapInfo.xCoordinateGotSnapped = true;
            this.active[1] = true;
        }
        if (!snapInfo.yCoordinateGotSnapped && Math.abs(p.y - (double)this.getTop()) < delta) {
            positionToAlter.y += (double)this.getTop() - p.y;
            snapInfo.yCoordinateGotSnapped = true;
            this.active[2] = true;
        }
        if (!snapInfo.yCoordinateGotSnapped && Math.abs(p.y - (double)this.getBottomAbsolute()) < delta) {
            positionToAlter.y += (double)this.getBottomAbsolute() - p.y;
            snapInfo.yCoordinateGotSnapped = true;
            this.active[3] = true;
        }
    }

    @Override
    public void deSerialize(Element element) {
        Float z = XMLReader.elementFloatAttribute(element, "left");
        if (z != null) {
            this.setLeft(z.floatValue());
        }
        if ((z = XMLReader.elementFloatAttribute(element, "right")) != null) {
            this.setRight(z.floatValue());
        }
        if ((z = XMLReader.elementFloatAttribute(element, "top")) != null) {
            this.setTop(z.floatValue());
        }
        if ((z = XMLReader.elementFloatAttribute(element, "bottom")) != null) {
            this.setBottom(z.floatValue());
        }
    }

    @Override
    public Element serialize(Element parentElement) {
        Element element = XMLWriter.addElement(Borders.getXMLName(), parentElement);
        XMLWriter.addAttributeFloat(element, "left", this.getLeft());
        XMLWriter.addAttributeFloat(element, "right", this.getRight());
        XMLWriter.addAttributeFloat(element, "top", this.getTop());
        XMLWriter.addAttributeFloat(element, "bottom", this.getBottom());
        return element;
    }

    public static String getXMLName() {
        return "borders";
    }

    public MyView getView() {
        return this.view;
    }

    @Override
    public void deleteRulerMark(RulerInfo.Direction direction, int index) {
    }

    @Override
    public void drawRulerMark(int posPixelX, int posPixelY, Graphics2D g2d) {
    }

    @Override
    public int getRulerMarkCount(RulerInfo.Direction direction) {
        return 2;
    }

    @Override
    public int getRulerMarkIndex(RulerInfo.Direction direction, double position, double delta) {
        int ret = -1;
        if (direction == RulerInfo.Direction.vertical) {
            if (Math.abs((double)this.getLeft() - position) < delta) {
                ret = 0;
            }
            if (Math.abs((double)this.getRightAbsolute() - position) < delta) {
                ret = 1;
            }
        } else {
            if (Math.abs((double)this.getTop() - position) < delta) {
                ret = 0;
            }
            if (Math.abs((double)this.getBottomAbsolute() - position) < delta) {
                ret = 1;
            }
        }
        return ret;
    }

    @Override
    public double getRulerMarkPosition(RulerInfo.Direction direction, int index) {
        if (direction == RulerInfo.Direction.horizontal) {
            if (index == 0) {
                return this.bordersVert[0];
            }
            return this.view.getMaxPageHeight() - (double)this.bordersVert[1];
        }
        if (index == 0) {
            return this.bordersHor[0];
        }
        return this.view.getMaxPageWidth() - (double)this.bordersHor[1];
    }

    @Override
    public void moveRulerMark(RulerInfo.Direction direction, int index, double newPosition) {
        float np = (float)newPosition;
        if (direction == RulerInfo.Direction.horizontal) {
            if (index == 0) {
                SetBorderOfViewCommand cmd = new SetBorderOfViewCommand(SetBorderOfViewCommand.BorderLocation.top, np, this.view);
            } else {
                SetBorderOfViewCommand cmd = new SetBorderOfViewCommand(SetBorderOfViewCommand.BorderLocation.bottom, (float)this.view.getMaxPageHeight() - np, this.view);
            }
        } else if (index == 0) {
            SetBorderOfViewCommand cmd = new SetBorderOfViewCommand(SetBorderOfViewCommand.BorderLocation.left, np, this.view);
        } else {
            SetBorderOfViewCommand setBorderOfViewCommand = new SetBorderOfViewCommand(SetBorderOfViewCommand.BorderLocation.right, (float)this.view.getMaxPageWidth() - np, this.view);
        }
    }

    public float getLeft() {
        return this.bordersHor[0];
    }

    public void setLeft(float left) {
        this.bordersHor[0] = left;
    }

    public float getRight() {
        return this.bordersHor[1];
    }

    public void setRight(float right) {
        this.bordersHor[1] = right;
    }

    public float getTop() {
        return this.bordersVert[0];
    }

    public void setTop(float top) {
        this.bordersVert[0] = top;
    }

    public float getBottom() {
        return this.bordersVert[1];
    }

    public void setBottom(float bottom) {
        this.bordersVert[1] = bottom;
    }

    public void setAllBorderLinesInactive() {
        int i = 0;
        while (i < this.active.length) {
            this.active[i] = false;
            ++i;
        }
    }

    public float getRightAbsolute() {
        return (float)this.view.getMaxPageWidth() - this.getRight();
    }

    public float getBottomAbsolute() {
        return (float)this.view.getMaxPageHeight() - this.getBottom();
    }

    public Borders getCopy(MyView newView) {
        Borders copy = new Borders(newView);
        int i = 0;
        while (i < this.bordersHor.length) {
            copy.bordersHor[i] = this.bordersHor[i];
            ++i;
        }
        i = 0;
        while (i < this.bordersVert.length) {
            copy.bordersVert[i] = this.bordersVert[i];
            ++i;
        }
        i = 0;
        while (i < this.active.length) {
            copy.active[i] = this.active[i];
            ++i;
        }
        return copy;
    }
}

