/*
 * Decompiled with CFR 0.152.
 */
package gui.actions;

import gui.actions.MyAction;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.taborderedit.StateTOEIdle;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import gui.components.toolbars.CommandBar;
import gui.components.toolbars.DrawBar;
import init.Settings;
import java.awt.event.ActionEvent;

public class ToggleTabOrderEditAction
extends MyAction {
    private static ToggleTabOrderEditAction instance;

    public static ToggleTabOrderEditAction getInstance() {
        if (instance == null) {
            instance = new ToggleTabOrderEditAction();
        }
        return instance;
    }

    private ToggleTabOrderEditAction() {
        super("Tabreihenfolge bearbeiten", "data/img/menu/16/edit_taborder_off.png");
        this.setState();
    }

    public void setState() {
        if (Settings.getInstance().isTabOrderEditModus()) {
            this.setImage("data/img/menu/16/edit_taborder.png");
            this.setTooltip("Taborder-Bearbeitungsmodus.");
        } else {
            this.setImage("data/img/menu/16/edit_taborder_off.png");
            this.setTooltip("Taborder-Bearbeitungsmodus ist ausgeschaltet.");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        Settings.getInstance().setTabOrderEditModus(!Settings.getInstance().isTabOrderEditModus());
        if (Settings.getInstance().isTabOrderEditModus()) {
            controller.stateChanged(StateTOEIdle.enter(controller));
            this.setState();
            this.setSelected(true);
            DrawBar.getInstance().setDrawButtonsEnabled(false);
            CommandBar.getInstance().setButtonsEnabled(false);
        } else {
            controller.getState().ESCpressed();
            this.setSelected(false);
            DrawBar.getInstance().setDrawButtonsEnabled(true);
            CommandBar.getInstance().setButtonsEnabled(true);
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

