/*
 * Decompiled with CFR 0.152.
 */
package gui.actions.textstyle;

import commands.changemarkfield.SetHorizontalAlignmentCommand;
import document.AbstractKeyboardFocusable;
import document.TextStyleChangeable;
import document.text.HorizontalAlignment;
import document.text.MyTextField;
import gui.actions.MyAction;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.event.ActionEvent;

public class SetAlignmentJustifiedAction
extends MyAction {
    private static SetAlignmentJustifiedAction instance;

    public static SetAlignmentJustifiedAction getInstance() {
        if (instance == null) {
            instance = new SetAlignmentJustifiedAction();
        }
        return instance;
    }

    private SetAlignmentJustifiedAction() {
        super("Blocksatz", "data/img/menu/16/text_align_justify.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PageViewPortController controller = DocumentTabbedPaneController.getInstance().getActivePageScrollPaneController().getPageViewPortController();
        MarkedObjectsAndHandles info = controller.getStateInfo();
        AbstractKeyboardFocusable kf = info.getKeyboardFocusableObject();
        if (kf != null && kf instanceof MyTextField) {
            MyTextField tf = (MyTextField)kf;
            tf.getTextfieldController().setHorizontalAlignment(HorizontalAlignment.justified);
            controller.updateCursor(true);
            controller.addJobPaintTextfield(kf, false);
            controller.doRepaint();
        } else {
            TextStyleChangeable tsc = null;
            if (kf instanceof TextStyleChangeable) {
                tsc = (TextStyleChangeable)((Object)kf);
            }
            if (tsc == null && info.getMarkedObjects().size() == 1 && info.getMarkedObjects().get(0) instanceof TextStyleChangeable) {
                tsc = (TextStyleChangeable)((Object)info.getMarkedObjects().get(0));
            }
            if (tsc != null) {
                SetHorizontalAlignmentCommand command = new SetHorizontalAlignmentCommand(HorizontalAlignment.justified, tsc);
                controller.updateCursor(true);
                controller.addJobPaintTextfield((AbstractKeyboardFocusable)((Object)tsc), false);
                controller.doRepaint();
            }
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

