/*
 * Decompiled with CFR 0.152.
 */
package gui.actions.usermode;

import data.localdatabase.DBExchangeObject;
import data.localdatabase.DataProvider;
import gui.actions.MyAction;
import gui.components.mainpanel.MainPanelController;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.io.XMLFilter;
import util.xml.XMLWriter;

public class SaveAsActionUserMode
extends MyAction {
    private static final long serialVersionUID = 1L;
    private static SaveAsActionUserMode instance;

    public static SaveAsActionUserMode getInstance() {
        if (instance == null) {
            instance = new SaveAsActionUserMode();
        }
        return instance;
    }

    private SaveAsActionUserMode() {
        super("Datendatei Speichern unter ...", "data/img/menu/16/filesaveas.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MainPanelController mpc = MainPanelController.getInstance();
        mpc.serializeCurrentEditedZeugnis();
        DataProvider dp = mpc.getDataProvider();
        DBExchangeObject dbe = dp.getExchangeObject();
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new XMLFilter());
        int returnVal = fc.showSaveDialog(MainPanelController.getInstance().getMainPanel());
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                if (!file.getName().endsWith(".xml")) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
                }
                Document doc = XMLWriter.createEmptyDocument();
                Element element = doc.createElement("zeugnisdaten");
                doc.appendChild(element);
                dbe.serialize(element);
                XMLWriter.writeToFile(doc, file);
                dp.setFilename(file.getAbsolutePath());
            }
            catch (Exception ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    protected void dispose() {
        instance = null;
    }
}

