/*
 * Decompiled with CFR 0.152.
 */
package gui.components.attributepanel;

import document.Scriptable;
import document.events.Eventtype;
import document.events.Script;
import gui.components.attributepanel.AttributePanelController;
import gui.components.attributepanel.EventTableModel;
import gui.components.attributepanel.SpringUtilities;
import gui.nbcomponents.components.MyJLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttributePanel
extends JPanel
implements KeyListener {
    private JPanel panelLeft;
    private JPanel panelRight;
    private JTextField textfieldName = new JTextField();
    private JTextArea textAreaScript;
    private JTable eventTable;
    private EventTableModel eventTableModel;
    private AttributePanelController controller;
    private Eventtype currentEventtype = null;
    private Scriptable scriptable = null;

    public AttributePanel(AttributePanelController controller) {
        this.controller = controller;
        this.panelLeft = new JPanel();
        this.panelRight = new JPanel();
        JSplitPane splitPane = new JSplitPane(1, this.panelLeft, this.panelRight);
        splitPane.setDividerLocation(150);
        splitPane.setResizeWeight(0.0);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.textAreaScript = new JTextArea();
        JScrollPane scrollPaneRight = new JScrollPane(this.textAreaScript);
        this.panelRight.setLayout(new BorderLayout());
        this.panelRight.add((Component)scrollPaneRight, "Center");
        MyJLabel scriptLabel = new MyJLabel();
        scriptLabel.setText("Script:");
        this.panelRight.add((Component)scriptLabel, "North");
        this.panelLeft.setLayout(new BorderLayout());
        this.panelLeft.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelLeftCenter = new JPanel();
        panelLeftCenter.setLayout(new BoxLayout(panelLeftCenter, 1));
        this.panelLeft.add((Component)panelLeftCenter, "Center");
        this.eventTable = new JTable();
        JScrollPane eventScroller = new JScrollPane(this.eventTable);
        panelLeftCenter.add(eventScroller);
        this.eventTable.getSelectionModel().addListSelectionListener(new RowListener());
        this.eventTable.setSelectionMode(0);
        this.eventTable.setRowSelectionAllowed(true);
        this.eventTable.setColumnSelectionAllowed(false);
        String[] labels = new String[]{"Name: "};
        int numPairs = labels.length;
        JComponent[] inputfields = new JComponent[]{this.textfieldName};
        JPanel panelLeftTop = new JPanel(new SpringLayout());
        int i = 0;
        while (i < numPairs) {
            MyJLabel l = new MyJLabel();
            l.setText(labels[i]);
            panelLeftTop.add(l);
            l.setLabelFor(inputfields[i]);
            panelLeftTop.add(inputfields[i]);
            ++i;
        }
        SpringUtilities.makeCompactGrid(panelLeftTop, numPairs, 2, 0, 0, 6, 6);
        this.panelLeft.add((Component)panelLeftTop, "North");
        this.textfieldName.addKeyListener(this);
        this.textfieldName.setEnabled(false);
        this.setScriptTextAreaEnabled(false);
    }

    public void setScriptTextAreaEnabled(boolean enabled) {
        this.textAreaScript.setEnabled(enabled);
        if (enabled) {
            this.textAreaScript.setBackground(new Color(0xFFFFFF));
        } else {
            this.textAreaScript.setBackground(SystemColor.control);
            this.textAreaScript.setText("");
        }
    }

    public void setScriptable(Scriptable scriptable) {
        this.storeCurrentScript();
        this.scriptable = scriptable;
        this.eventTableModel = new EventTableModel(scriptable);
        this.eventTable.setModel(this.eventTableModel);
        this.eventTableModel.fireTableStructureChanged();
        if (scriptable != null && scriptable.getPossibleEvents() != null && scriptable.getPossibleEvents().length > 0) {
            this.setScriptTextAreaEnabled(true);
            this.setScriptText(0);
            this.eventTable.setRowSelectionInterval(0, 0);
        } else {
            this.setScriptTextAreaEnabled(false);
        }
    }

    private void eventChosen(int index) {
        this.storeCurrentScript();
        this.setScriptText(index);
    }

    private void setScriptText(int index) {
        if (this.scriptable.getPossibleEvents().length > 0) {
            this.currentEventtype = this.scriptable.getPossibleEvents()[index];
            Script script = this.scriptable.getScript(this.currentEventtype);
            String scriptText = "";
            if (script != null) {
                scriptText = script.getScript();
            }
            this.textAreaScript.setText(scriptText);
        }
    }

    public void storeCurrentScript() {
        if (this.scriptable != null && this.scriptable.getPossibleEvents() != null && this.scriptable.getPossibleEvents().length > 0) {
            this.scriptable.setScriptText(this.currentEventtype, this.textAreaScript.getText());
        }
    }

    public void setNameText(String name) {
        this.textfieldName.setText(name);
    }

    public String getNameText() {
        return this.textfieldName.getText();
    }

    public void setNameTextFieldEnabled(boolean enabled) {
        this.textfieldName.setEnabled(enabled);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.controller.storeNameOfNamedObject();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == ' ') {
            e.consume();
        }
    }

    private class RowListener
    implements ListSelectionListener {
        private RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            int rowIndex = AttributePanel.this.eventTable.getSelectionModel().getLeadSelectionIndex();
            if (rowIndex >= 0) {
                AttributePanel.this.eventChosen(rowIndex);
            }
        }
    }
}

