/*
 * Decompiled with CFR 0.152.
 */
package gui.components.bemerkungspanel;

import gui.components.bemerkungspanel.Bemerkung;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class BemerkungsListRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Bemerkung bem = (Bemerkung)value;
        label.setText(this.makeHtml(bem.toString()));
        return label;
    }

    private String makeHtml(String text) {
        boolean isHtml = false;
        String htmlString = "";
        int p1 = 0;
        int p2 = 0;
        ScanMode scanMode = ScanMode.SCANTEXT;
        Object textMenu = null;
        while (p2 < text.length()) {
            char c2 = text.charAt(p2);
            int c2next = 32;
            if (p2 + 1 < text.length()) {
                c2next = text.charAt(p2 + 1);
            }
            boolean isBeginMenu = c2 == '[' && c2next == 91;
            boolean isEndMenu = c2 == ']' && c2next == 93;
            boolean isPipe = c2 == '|' && c2next != 124;
            boolean isDoublePipe = c2 == '|' && c2next == 124;
            switch (scanMode) {
                case SCANTEXT: {
                    if (isBeginMenu) {
                        if (p2 > p1) {
                            htmlString = String.valueOf(htmlString) + text.substring(p1, p2);
                        }
                        p1 = p2 + 2;
                        p2 += 2;
                        scanMode = ScanMode.SCANNAMEORMENUITEM;
                        htmlString = String.valueOf(htmlString) + "<font color=\"blue\">";
                        isHtml = true;
                        break;
                    }
                    ++p2;
                    break;
                }
                case SCANNAMEORMENUITEM: {
                    if (isPipe) {
                        if (p2 > p1) {
                            htmlString = String.valueOf(htmlString) + text.substring(p1, p2) + "/";
                        }
                        p1 = p2 + 1;
                        ++p2;
                        break;
                    }
                    if (isDoublePipe) {
                        p1 = p2 + 2;
                        p2 += 2;
                        break;
                    }
                    if (isEndMenu) {
                        if (p2 > p1) {
                            htmlString = String.valueOf(htmlString) + text.substring(p1, p2) + "</font>";
                        }
                        p1 = p2 + 2;
                        p2 += 2;
                        scanMode = ScanMode.SCANTEXT;
                        break;
                    }
                    ++p2;
                    break;
                }
            }
        }
        if (scanMode == ScanMode.SCANTEXT && p2 > p1) {
            htmlString = String.valueOf(htmlString) + text.substring(p1, p2);
        }
        if (isHtml) {
            htmlString = "<html>" + htmlString + "</html>";
        }
        return htmlString;
    }

    private static enum ScanMode {
        SCANTEXT,
        SCANNAMEORMENUITEM;

    }
}

