/*
 * Decompiled with CFR 0.152.
 */
package gui.components.bemerkungspanel;

import document.text.TextFieldController;
import gui.components.bemerkungspanel.Bemerkung;
import gui.components.bemerkungspanel.Bemerkungen;
import gui.components.bemerkungspanel.BemerkungsPanel;
import java.util.ArrayList;

public class BemerkungsPanelController {
    private BemerkungsPanel bemerkungsPanel;
    private Bemerkungen bemerkungsFile = new Bemerkungen();
    private ArrayList<Bemerkung> bemerkungenForCurrentField = new ArrayList();
    private TextFieldController textfieldcontroller;
    private String vorname;
    private char time;
    private char sex;

    public BemerkungsPanelController() {
        this.bemerkungsPanel = new BemerkungsPanel(this);
    }

    public BemerkungsPanel getBemerkungsPanel() {
        return this.bemerkungsPanel;
    }

    public void setupBemerkungsPanel(String filename, String field, char sex, String vorname, char time, TextFieldController tfc) {
        this.textfieldcontroller = tfc;
        this.vorname = vorname;
        this.time = time;
        this.sex = sex;
        this.bemerkungsPanel.setName(vorname);
        this.bemerkungsPanel.setAlleBemerkungen(this.bemerkungsFile);
        if (filename.compareTo(this.bemerkungsFile.getFilename()) != 0) {
            this.bemerkungsFile.getFromFile(filename);
        }
        this.bemerkungenForCurrentField.clear();
        for (Bemerkung bemerkung : this.bemerkungsFile.getBemerkungen()) {
            if (bemerkung.getField().compareToIgnoreCase(field) != 0) continue;
            this.bemerkungenForCurrentField.add(bemerkung);
        }
        this.initializeLevelsAndSubfields();
        this.setupBemerkungen();
        this.bemerkungsPanel.validate();
    }

    public void setupBemerkungen() {
        char persoenlich = this.textfieldcontroller.isPersonalInsertSuggestion(this.vorname) ? (char)'p' : 'u';
        this.bemerkungsPanel.setRadiobuttonStatus(this.sex, this.time, persoenlich);
        this.bemerkungsPanel.setBemerkungen(this.bemerkungenForCurrentField);
        this.bemerkungsPanel.updateBemerkungsList(this.vorname);
    }

    private void initializeLevelsAndSubfields() {
        ArrayList<String> levels = new ArrayList<String>();
        ArrayList<String> subfields = new ArrayList<String>();
        for (Bemerkung b : this.bemerkungenForCurrentField) {
            if (!this.contains(levels, b.getLevel())) {
                levels.add(b.getLevel());
            }
            if (this.contains(subfields, b.getSubfield())) continue;
            subfields.add(b.getSubfield());
        }
        this.bemerkungsPanel.setupLevelPanel(levels);
        this.bemerkungsPanel.setupSubfieldPanel(subfields);
    }

    private boolean contains(ArrayList<String> list, String s) {
        for (String string : list) {
            if (s.compareTo(string) != 0) continue;
            return true;
        }
        return false;
    }

    public void insertBemerkung(String bemerkung) {
        this.textfieldcontroller.insertBemerkung(bemerkung);
    }
}

