/*
 * Decompiled with CFR 0.152.
 */
package gui.components.mainpanel;

import data.localdatabase.DBKlassenDaten;
import data.localdatabase.DBSchuelerDaten;
import data.localdatabase.DBSchuelerZeugnisDaten;
import data.localdatabase.DBSchulDaten;
import data.localdatabase.DBZeugnisDaten;
import data.localdatabase.DataProvider;
import data.scripting.DocumentScriptingContext;
import document.MyDocument;
import document.Scriptable;
import document.view.MyView;
import gui.actions.AddQuickviewAction;
import gui.actions.MyAction;
import gui.actions.RemoveQuickviewAction;
import gui.actions.SaveAction;
import gui.actions.usermode.SaveActionUserMode;
import gui.components.attributepanel.AttributePanelController;
import gui.components.bemerkungspanel.BemerkungsPanel;
import gui.components.bemerkungspanel.BemerkungsPanelController;
import gui.components.choosepupilpanel.ChoosePupilPanel;
import gui.components.mainpanel.MainPanel;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import init.App;
import init.Settings;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import util.language.Lang;

public class MainPanelController {
    private DocumentTabbedPaneController dTPC;
    private static MainPanelController instance;
    private App.ApplicationMode applicationMode = App.ApplicationMode.editMode_in_ASV;
    private MainPanel mainPanel = new MainPanel(this);
    private JSplitPane pupilListSplitPane;
    private JSplitPane eventSplitPane;
    private JSplitPane bemerkungsSplitPane;
    private ChoosePupilPanel pupilPanel;
    private DataProvider dataProvider;
    private DBSchuelerDaten currentEditedPupil = null;
    private MyDocument currentEditedDocument = null;
    private DBSchuelerZeugnisDaten currentEditedSchuelerZeugnis = null;
    private AttributePanelController attributePanelController = null;
    private BemerkungsPanelController bemerkungsPanelController;
    private int bemerkungsSplitPaneDividerLocation;

    public static MainPanelController getInstance(App.ApplicationMode applicationMode, DataProvider dataProvider) {
        if (instance == null) {
            instance = new MainPanelController();
            MainPanelController.instance.applicationMode = applicationMode;
            MainPanelController.instance.dataProvider = dataProvider;
            instance.init();
        }
        return instance;
    }

    public static MainPanelController getInstance() {
        if (instance == null) {
            instance = new MainPanelController();
            instance.init();
        }
        return instance;
    }

    public void dispose() {
        instance = null;
        MyAction.disposeAll();
        Settings.dispose();
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void init() {
        this.dTPC = DocumentTabbedPaneController.getInstance();
        if (this.applicationMode == App.ApplicationMode.standalone_userMode || this.applicationMode == App.ApplicationMode.userMode_in_ASV) {
            this.pupilPanel = new ChoosePupilPanel(this.dataProvider);
            this.pupilListSplitPane = new JSplitPane(1, this.dTPC.getTabbedPane(), this.pupilPanel);
            this.pupilListSplitPane.setOneTouchExpandable(true);
            Dimension minimumSize = new Dimension(150, 50);
            this.pupilPanel.setMinimumSize(minimumSize);
            this.dTPC.getTabbedPane().setMinimumSize(minimumSize);
            this.pupilPanel.setDataProvidedStatus();
            this.bemerkungsPanelController = new BemerkungsPanelController();
            BemerkungsPanel bemerkungsPanel = this.bemerkungsPanelController.getBemerkungsPanel();
            this.bemerkungsPanelController = new BemerkungsPanelController();
            bemerkungsPanel = this.bemerkungsPanelController.getBemerkungsPanel();
            this.bemerkungsSplitPane = new JSplitPane(0, this.pupilListSplitPane, bemerkungsPanel);
            this.bemerkungsSplitPane.setOneTouchExpandable(true);
            minimumSize = new Dimension(150, 50);
            this.pupilListSplitPane.setMinimumSize(minimumSize);
            minimumSize = new Dimension(0, 0);
            bemerkungsPanel.setMinimumSize(minimumSize);
            this.bemerkungsSplitPane.setDividerLocation(1.0);
            this.bemerkungsSplitPane.setResizeWeight(1.0);
            this.enableBemerkungsSplitPane(false);
            this.mainPanel.add((Component)this.bemerkungsSplitPane, "Center");
            this.bemerkungsSplitPane.setDividerSize(0);
            this.pupilListSplitPane.setResizeWeight(1.0);
        } else {
            this.attributePanelController = new AttributePanelController();
            this.eventSplitPane = new JSplitPane(0, this.dTPC.getTabbedPane(), this.attributePanelController.getAttributePanel());
            this.eventSplitPane.setOneTouchExpandable(true);
            Dimension minimumSize = new Dimension(100, 50);
            this.attributePanelController.getAttributePanel().setMinimumSize(minimumSize);
            this.dTPC.getTabbedPane().setMinimumSize(minimumSize);
            this.mainPanel.add((Component)this.eventSplitPane, "Center");
            this.eventSplitPane.setResizeWeight(1.0);
        }
    }

    public void enableSouthEastPanel(boolean enabled) {
        if (enabled) {
            Dimension minimumSize = new Dimension(150, 50);
            this.pupilPanel.setMinimumSize(minimumSize);
            this.dTPC.getTabbedPane().setMinimumSize(minimumSize);
        } else {
            Dimension minimumSize = new Dimension(0, 0);
            this.pupilPanel.setMinimumSize(minimumSize);
            if (this.applicationMode == App.ApplicationMode.standalone_userMode || this.applicationMode == App.ApplicationMode.userMode_in_ASV) {
                this.pupilListSplitPane.setDividerLocation(1.0);
            } else {
                this.eventSplitPane.setDividerLocation(1.0);
            }
        }
    }

    public void setInitialSplitPanePosition(int windowWidth, int windowHeight) {
        if (this.applicationMode == App.ApplicationMode.standalone_userMode || this.applicationMode == App.ApplicationMode.userMode_in_ASV) {
            this.pupilListSplitPane.setDividerLocation(windowWidth - 180);
            this.bemerkungsSplitPane.setDividerLocation(1.0);
            this.bemerkungsSplitPaneDividerLocation = windowHeight - 100;
        } else {
            this.eventSplitPane.setDividerLocation(windowHeight - 180);
        }
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    private boolean windowClosingEditMode() {
        ArrayList<MyDocument> dirtyDocuments = this.dTPC.getDirtyDocuments();
        boolean closingPermitted = true;
        boolean closeOrCancel = false;
        while (dirtyDocuments.size() > 0 && !closeOrCancel) {
            closingPermitted = false;
            MyDocument documentToSave = dirtyDocuments.get(0);
            int i = this.dTPC.getIndexOfView(documentToSave.getPrintView());
            this.dTPC.setVisibleTab(i);
            Object[] options = new Object[]{Lang.get("\u00c4nderungen Speichern"), Lang.get("Schlie\u00dfen, \u00c4nderungen verwerfen"), Lang.get("Abbrechen")};
            int n = JOptionPane.showOptionDialog(this.mainPanel, Lang.get("Mindestens ein Dokument wurde seit der letzten \u00c4nderung noch nicht gespeichert. Wollen Sie die Anwendung wirklich schlie\u00dfen?"), Lang.get("Warnung"), 1, 2, null, options, options[2]);
            switch (n) {
                case 0: {
                    SaveAction.getInstance().actionPerformed(null);
                    dirtyDocuments = this.dTPC.getDirtyDocuments();
                    closingPermitted = true;
                    break;
                }
                case 1: {
                    closingPermitted = true;
                    closeOrCancel = true;
                    break;
                }
                case 2: {
                    closingPermitted = false;
                    closeOrCancel = true;
                    break;
                }
            }
        }
        return closingPermitted;
    }

    private boolean windowClosingUserMode() {
        boolean closingPermitted = true;
        boolean closeOrCancel = false;
        while (this.isDataProviderDirty() && !closeOrCancel) {
            closingPermitted = false;
            Object[] options = new Object[]{Lang.get("\u00c4nderungen Speichern"), Lang.get("Schlie\u00dfen, \u00c4nderungen verwerfen"), Lang.get("Abbrechen")};
            int n = JOptionPane.showOptionDialog(this.mainPanel, Lang.get("Seit dem letzten Speichern wurden \u00c4nderungen vorgenommen. Wollen Sie die Anwendung wirklich schlie\u00dfen?"), Lang.get("Warnung"), 1, 2, null, options, options[2]);
            switch (n) {
                case 0: {
                    SaveActionUserMode.getInstance().actionPerformed(null);
                    closingPermitted = this.isDataProviderDirty();
                    break;
                }
                case 1: {
                    closingPermitted = true;
                    closeOrCancel = true;
                    break;
                }
                case 2: {
                    closingPermitted = false;
                    closeOrCancel = true;
                    break;
                }
            }
        }
        return closingPermitted;
    }

    public boolean windowClosing(WindowEvent e) {
        if (Settings.getInstance().isEditMode()) {
            return this.windowClosingEditMode();
        }
        return this.windowClosingUserMode();
    }

    public void closeAllTabs() {
        this.dTPC.closeAllTabsWithoutAsking();
    }

    public void choosePupilAndZeugnis(DBSchuelerDaten schueler, DBZeugnisDaten zeugnis, DBSchulDaten schule, DBKlassenDaten klasse) {
        MyDocument document;
        if (this.currentEditedDocument != null && this.currentEditedPupil != null & this.currentEditedSchuelerZeugnis != null) {
            this.currentEditedDocument.serializeSchuelerZeugnisData(this.currentEditedSchuelerZeugnis);
        }
        this.closeAllTabs();
        DBSchuelerZeugnisDaten schuelerZeugnis = schueler.getSchuelerZeugnis(zeugnis);
        this.currentEditedDocument = document = zeugnis.getZeugnisVorlage().getCopy();
        this.currentEditedPupil = schueler;
        this.currentEditedSchuelerZeugnis = schuelerZeugnis;
        DocumentScriptingContext dscr = new DocumentScriptingContext(document, schule, klasse, zeugnis, schueler, schuelerZeugnis, this.dataProvider.getExchangeObject().getSchuljahr());
        document.setDocumentScriptingContext(dscr);
        document.deserializeSchuelerZeugnisData(schuelerZeugnis);
        for (MyView view : document.views) {
            this.dTPC.addView(view);
        }
        document.setDirty(false);
        this.getMainPanel().setupToolbarsAccordingToToggleEditMode(true);
        RemoveQuickviewAction.getInstance().setEnabledStatus();
        AddQuickviewAction.getInstance().setEnabledStatus();
        this.mainPanel.repaint();
    }

    public void serializeCurrentEditedZeugnis() {
        if (this.currentEditedDocument != null && this.currentEditedSchuelerZeugnis != null) {
            this.currentEditedDocument.serializeSchuelerZeugnisData(this.currentEditedSchuelerZeugnis);
            if (this.dataProvider != null) {
                this.dataProvider.setDirty(this.dataProvider.isDirty() || this.currentEditedDocument.isDirty());
            }
        }
    }

    public void setCursor(Cursor cursor) {
        this.mainPanel.setCursor(cursor);
    }

    public void setScriptable(Scriptable scriptable) {
        if (this.attributePanelController != null) {
            this.attributePanelController.setScriptable(scriptable);
        }
    }

    public void saveCurrentEventScript() {
        this.attributePanelController.saveCurrentEventScript();
    }

    public ChoosePupilPanel getPupilPanel() {
        return this.pupilPanel;
    }

    public AttributePanelController getAttributePanelController() {
        return this.attributePanelController;
    }

    public boolean isDataProviderDirty() {
        boolean ret = false;
        if (this.dataProvider != null) {
            boolean bl = ret = ret || this.dataProvider.isDirty();
        }
        if (this.currentEditedDocument != null) {
            ret = ret || this.currentEditedDocument.isDirty();
        }
        return ret;
    }

    public void setDataProviderDirty(boolean dirty) {
        if (this.dataProvider != null) {
            this.dataProvider.setDirty(dirty);
        }
        if (this.currentEditedDocument != null) {
            this.currentEditedDocument.setDirty(dirty);
        }
    }

    public boolean isBemerkungspanelOpen() {
        if (this.bemerkungsSplitPane != null) {
            return this.bemerkungsSplitPane.getDividerSize() > 0;
        }
        return false;
    }

    public void enableBemerkungsSplitPane(boolean enabled) {
        if (enabled) {
            if (!this.isBemerkungspanelOpen()) {
                this.bemerkungsSplitPane.setDividerSize(6);
                this.bemerkungsPanelController.getBemerkungsPanel().validate();
                int preferredDividerLocation = this.bemerkungsSplitPane.getMaximumDividerLocation() - this.bemerkungsPanelController.getBemerkungsPanel().getPreferredSize().height;
                if (preferredDividerLocation > this.bemerkungsSplitPaneDividerLocation) {
                    preferredDividerLocation = this.bemerkungsSplitPaneDividerLocation;
                }
                this.bemerkungsSplitPane.setDividerLocation(preferredDividerLocation);
            }
        } else {
            this.bemerkungsSplitPane.setDividerSize(0);
            this.bemerkungsSplitPaneDividerLocation = this.bemerkungsSplitPane.getDividerLocation();
            this.bemerkungsSplitPane.setDividerLocation(1.0);
        }
    }

    public BemerkungsPanelController getBemerkungsPanelController() {
        return this.bemerkungsPanelController;
    }
}

