/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.graphiccontext;

import gui.components.pageviewport.graphiccontext.GraphicContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import util.math.PointDouble;
import util.math.PointInt;

public class ViewportGraphicContext
extends GraphicContext {
    private double zoomfactor = 1.0;
    private double dotsPerCm;
    private int pageOffsetX = 0;
    private int pageOffsetY = 0;
    private double pageWidthCm;
    private double pageHeightCm;
    private Shape oldClip;
    private AffineTransform panelTransform;
    private AffineTransform inversePanelTransform;
    private AffineTransform pageTransform;
    private AffineTransform objectTransform = null;
    double width;
    double height;
    double midX;
    double midY;
    double angle;
    private BasicStroke hyphenationStroke = new BasicStroke(1.0f);
    private float[] dash1 = new float[]{1.0f, 3.0f};
    private float[] dash2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private float[] dash3 = new float[]{1.0f, 3.0f};
    private float dashphase1 = 0.0f;
    private float dashphase2 = 1.0f;
    private float dashphase3 = 1.0f;
    private BasicStroke stroke1 = new BasicStroke(1.0f, 0, 0, 1.0f, this.dash1, this.dashphase1);
    private BasicStroke stroke2 = new BasicStroke(1.0f, 0, 0, 1.0f, this.dash2, this.dashphase2);
    private BasicStroke stroke3 = new BasicStroke(1.0f, 0, 0, 1.0f, this.dash3, this.dashphase3);
    private Rectangle2D boundsRect2DPanelCoordinates;
    private Rectangle2D.Double boundsRect2DObjectCoordinates;
    private Rectangle2D.Double boundsRect2DPageCoordinates;

    public ViewportGraphicContext(double dotsPerCm, double zoomfactor, int pageOffsetX, int pageOffsetY, double pageWidthCm, double pageHeightCm, Graphics2D g2d, Rectangle boundsRect) {
        super(g2d);
        Rectangle r = boundsRect == null ? g2d.getClipBounds() : boundsRect;
        this.boundsRect2DPanelCoordinates = r != null ? new Rectangle2D.Double(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight()) : null;
        this.zoomfactor = zoomfactor;
        this.pageOffsetX = pageOffsetX;
        this.pageOffsetY = pageOffsetY;
        this.dotsPerCm = dotsPerCm;
        this.pageHeightCm = pageHeightCm;
        this.pageWidthCm = pageWidthCm;
        this.oldClip = g2d.getClip();
        this.panelTransform = g2d.getTransform();
        try {
            this.inversePanelTransform = this.panelTransform.createInverse();
        }
        catch (Exception ex) {
            this.inversePanelTransform = new AffineTransform();
            this.inversePanelTransform.setToIdentity();
        }
        this.pageTransform = g2d.getTransform();
        double factor = dotsPerCm * zoomfactor;
        this.pageTransform.scale(factor, factor);
        this.pageTransform.translate((double)pageOffsetX / factor, (double)pageOffsetY / factor);
        if (this.boundsRect2DPanelCoordinates != null) {
            try {
                AffineTransform at = this.pageTransform.createInverse();
                PointDouble p1 = new PointDouble(this.boundsRect2DPanelCoordinates.getMinX(), this.boundsRect2DPanelCoordinates.getMinY());
                PointDouble p2 = new PointDouble();
                this.panelTransform.transform(p1, p2);
                at.transform(p2, p1);
                double width1 = this.boundsRect2DPanelCoordinates.getWidth() * at.getScaleX();
                double height1 = this.boundsRect2DPanelCoordinates.getHeight() * at.getScaleY();
                this.boundsRect2DPageCoordinates = new Rectangle2D.Double(p1.getX(), p1.getY(), width1, height1);
            }
            catch (Exception exception) {}
        } else {
            this.boundsRect2DPageCoordinates = null;
        }
    }

    @Override
    public void setObjectMetrics(double midX, double midY, double angle, double width, double height) {
        this.width = width;
        this.height = height;
        this.midX = midX;
        this.midY = midY;
        this.angle = angle;
        this.objectTransform = new AffineTransform(this.panelTransform);
        double factor = this.dotsPerCm * this.zoomfactor;
        this.objectTransform.scale(factor, factor);
        this.objectTransform.translate((double)this.pageOffsetX / factor, (double)this.pageOffsetY / factor);
        this.objectTransform.rotate(-angle, midX, midY);
        this.objectTransform.translate(midX - width / 2.0, midY - height / 2.0);
        if (this.boundsRect2DPanelCoordinates != null) {
            try {
                AffineTransform at = this.objectTransform.createInverse();
                PointDouble p1 = new PointDouble(this.boundsRect2DPanelCoordinates.getMinX(), this.boundsRect2DPanelCoordinates.getMinY());
                PointDouble p2 = new PointDouble();
                this.panelTransform.transform(p1, p2);
                at.transform(p2, p1);
                double width1 = this.boundsRect2DPanelCoordinates.getWidth() * at.getScaleX();
                double height1 = this.boundsRect2DPanelCoordinates.getHeight() * at.getScaleY();
                this.boundsRect2DObjectCoordinates = new Rectangle2D.Double(p1.getX(), p1.getY(), width1, height1);
            }
            catch (Exception exception) {}
        } else {
            this.boundsRect2DPageCoordinates = null;
        }
    }

    public double getZoomfactor() {
        return this.zoomfactor;
    }

    @Override
    public double getDotsPerCm() {
        return this.dotsPerCm;
    }

    public int getPageOffsetX() {
        return this.pageOffsetX;
    }

    public int getPageOffsetY() {
        return this.pageOffsetY;
    }

    @Override
    public boolean isPrinter() {
        return false;
    }

    public void setPanelCoordinates() {
        this.g2d.setTransform(this.panelTransform);
        this.g2d.setClip(this.oldClip);
        this.coordinateSystem = GraphicContext.CoordinateSystem.panel;
    }

    public PointInt PageToPanel(PointDouble p) {
        double factor = this.dotsPerCm * this.zoomfactor;
        PointInt pint = new PointInt((int)Math.round(p.getX() * factor + (double)this.pageOffsetX), (int)Math.round(p.getY() * factor + (double)this.pageOffsetY));
        return pint;
    }

    @Override
    public void setObjectCoordinates() {
        this.setBoundsRect2D(this.boundsRect2DObjectCoordinates);
        this.g2d.setTransform(this.objectTransform);
        this.coordinateSystem = GraphicContext.CoordinateSystem.object;
    }

    @Override
    public void setPageCoordinates(boolean clipped) {
        this.setBoundsRect2D(this.boundsRect2DPageCoordinates);
        this.g2d.setTransform(this.panelTransform);
        this.g2d.setClip(this.oldClip);
        this.g2d.setTransform(this.pageTransform);
        if (clipped) {
            Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, this.pageWidthCm, this.pageHeightCm);
            this.g2d.clip(r2d);
        }
        this.coordinateSystem = GraphicContext.CoordinateSystem.page;
    }

    @Override
    public int pageCmToPixel(double cm) {
        double factor = this.dotsPerCm * this.zoomfactor;
        return (int)Math.round(cm * factor);
    }

    @Override
    public double pixelToPageCm(int pixel) {
        double factor = this.dotsPerCm * this.zoomfactor;
        return (double)pixel / factor;
    }

    public PointDouble PanelToPage(PointInt p) {
        double factor = this.dotsPerCm * this.zoomfactor;
        PointDouble pdouble = new PointDouble((double)(p.getX() - this.pageOffsetX) / factor, (double)(p.getY() - this.pageOffsetY) / factor);
        return pdouble;
    }

    @Override
    public void drawString(String str, float x, float y) {
        AffineTransform oldTransform = this.g2d.getTransform();
        AffineTransform transformToPanel = this.g2d.getTransform();
        Point2D.Float p = new Point2D.Float(x, y);
        Point2D.Float pPanel = new Point2D.Float();
        transformToPanel.transform(p, pPanel);
        float dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        double fontZoomfactor = this.zoomfactor * (double)dpi / 72.0;
        ((Point2D)pPanel).setLocation(((Point2D)pPanel).getX() / fontZoomfactor, ((Point2D)pPanel).getY() / fontZoomfactor);
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        at.scale(fontZoomfactor, fontZoomfactor);
        if (this.coordinateSystem == GraphicContext.CoordinateSystem.object) {
            at.rotate(-this.angle, ((Point2D)pPanel).getX(), ((Point2D)pPanel).getY());
        }
        this.g2d.setTransform(at);
        this.g2d.drawString(str, (float)((Point2D)pPanel).getX(), (float)((Point2D)pPanel).getY());
        this.g2d.setTransform(oldTransform);
    }

    public void drawSpellCheckLine(float x1, float x2, float y) {
        AffineTransform at = this.g2d.getTransform();
        AffineTransform at1 = new AffineTransform();
        at1.setToIdentity();
        this.g2d.setTransform(at1);
        PointDouble p1 = new PointDouble(x1, y);
        PointDouble p2 = new PointDouble(x2, y);
        PointDouble p1int = new PointDouble();
        PointDouble p2int = new PointDouble();
        at.transform(p1, p1int);
        at.transform(p2, p2int);
        Object antialiasingkey = this.g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        p1int.y -= 2.0;
        p2int.y -= 2.0;
        Color oldColor = this.g2d.getColor();
        this.g2d.setColor(Color.red);
        this.g2d.setStroke(this.stroke1);
        Line2D.Double line1 = new Line2D.Double((int)p1int.x, (int)p1int.y - 1, (int)p2int.x, (int)p2int.y - 1);
        this.g2d.draw(line1);
        this.g2d.setStroke(this.stroke2);
        Line2D.Double line2 = new Line2D.Double((int)p1int.x, (int)p1int.y, (int)p2int.x, (int)p2int.y);
        this.g2d.draw(line2);
        this.g2d.setStroke(this.stroke3);
        Line2D.Double line3 = new Line2D.Double((int)p1int.x - 1, (int)p1int.y + 1, (int)p2int.x, (int)p2int.y + 1);
        this.g2d.draw(line3);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasingkey);
        this.g2d.setColor(oldColor);
        this.g2d.setTransform(at);
    }

    public void drawHyphenationLine(float x1, float y1, float y2) {
        AffineTransform at = this.g2d.getTransform();
        AffineTransform at1 = new AffineTransform();
        at1.setToIdentity();
        this.g2d.setTransform(at1);
        double factor = at.getScaleX();
        double onePixel = 1.0 / factor;
        PointDouble p1 = new PointDouble(x1, y1);
        PointDouble p2 = new PointDouble((double)x1 - onePixel * 3.0, (double)y1 + onePixel * 4.0);
        PointDouble p3 = new PointDouble((double)x1 + onePixel * 3.0, (double)y1 + onePixel * 4.0);
        PointDouble p1int = new PointDouble();
        PointDouble p2int = new PointDouble();
        PointDouble p3int = new PointDouble();
        at.transform(p1, p1int);
        at.transform(p2, p2int);
        at.transform(p3, p3int);
        Object antialiasingkey = this.g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = this.g2d.getColor();
        this.g2d.setColor(new Color(34816));
        this.g2d.setStroke(this.hyphenationStroke);
        GeneralPath polyLine = new GeneralPath();
        polyLine.moveTo(p1int.x, p1int.y);
        polyLine.lineTo(p2int.x, p2int.y);
        polyLine.lineTo(p3int.x, p3int.y);
        polyLine.closePath();
        this.g2d.draw(polyLine);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasingkey);
        this.g2d.setColor(oldColor);
        this.g2d.setTransform(at);
    }

    @Override
    public void setPageCoordinates() {
        this.setBoundsRect2D(this.boundsRect2DPageCoordinates);
        this.g2d.setTransform(this.pageTransform);
        this.coordinateSystem = GraphicContext.CoordinateSystem.page;
    }

    public double getPageWidthCm() {
        return this.pageWidthCm;
    }

    public double getPageHeightCm() {
        return this.pageHeightCm;
    }

    public AffineTransform getInversePanelTransform() {
        return this.inversePanelTransform;
    }
}

