/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.handles;

import commands.StretchHorVertCommand;
import document.MyObject;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.autoarrange.SnapPosition;
import gui.components.pageviewport.autoarrange.SnapPositions;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.handles.ArrowHandle;
import util.math.MyMath;
import util.math.PointDouble;

public class HorVertStretchHandleController
extends HandleController {
    Direction direction;
    PointDouble referencedPoint;

    public HorVertStretchHandleController(MyObject originalObject, float midX, float midY, double angle, PointDouble referencedPoint, Direction direction, PageViewport pageViewPort) {
        this.originalObject = originalObject;
        this.referencedPoint = referencedPoint.getCopy();
        this.direction = direction;
        this.handle = new ArrowHandle();
        this.setPositionAngle(midX, midY, angle);
        this.pageViewPortController = pageViewPort.getController();
    }

    @Override
    public void transformByPulling(PointDouble mousePosition, boolean shiftPressed, boolean ctrlPressed, boolean transformOriginal, MarkedObjectsAndHandles stateInfo) {
        SnapPosition snapY;
        PageController pc = this.pageViewPortController.getPageController(this.originalObject.getPage());
        SnapPositions snapPositions = pc.getSnapPositions();
        snapPositions.clearActivePositions();
        double maxSnapDistance = this.pageViewPortController.getSnapDeltaCm();
        PointDouble center = new PointDouble(this.originalObject.getMidX(), this.originalObject.getMidY());
        if (!ctrlPressed) {
            center.setX(2.0 * (center.getX() - this.referencedPoint.getX()) + this.referencedPoint.getX());
            center.setY(2.0 * (center.getY() - this.referencedPoint.getY()) + this.referencedPoint.getY());
        }
        PointDouble mouseDelta = mousePosition.getCopy();
        mouseDelta.sub(this.startPoint);
        PointDouble oldVector = new PointDouble(this.referencedPoint.getX() - center.getX(), this.referencedPoint.getY() - center.getY());
        PointDouble newPosition = this.referencedPoint.getCopy();
        newPosition.add(mouseDelta);
        this.pageViewPortController.setAllArtificialAndBorderLinesToInactive();
        SnapInfo snapInfo = new SnapInfo();
        this.pageViewPortController.snapToGridAndArtificialLines(newPosition, newPosition, snapInfo);
        PointDouble posAfterArtificialLineGridSnap = newPosition.getCopy();
        SnapPosition snapX = snapPositions.isNearPosition(newPosition, maxSnapDistance, SnapPositions.Type.horizontal);
        if (snapX != null) {
            newPosition.setX(snapX.x);
        }
        if ((snapY = snapPositions.isNearPosition(newPosition, maxSnapDistance, SnapPositions.Type.vertical)) != null) {
            newPosition.setY(snapY.y);
        }
        if (snapInfo.xCoordinateGotSnapped) {
            newPosition.x = posAfterArtificialLineGridSnap.x;
        }
        if (snapInfo.yCoordinateGotSnapped) {
            newPosition.y = posAfterArtificialLineGridSnap.y;
        }
        PointDouble newVector = newPosition.getCopy();
        newVector.sub(center);
        MyMath.rotate(oldVector, 0.0, 0.0, -this.originalObject.getAngle());
        MyMath.rotate(newVector, 0.0, 0.0, -this.originalObject.getAngle());
        double factorHor = 1.0;
        double factorVert = 1.0;
        if (Math.abs(oldVector.getX()) > 1.0E-6) {
            factorHor = newVector.getX() / oldVector.getX();
        }
        if (Math.abs(oldVector.getY()) > 1.0E-6) {
            factorVert = newVector.getY() / oldVector.getY();
        }
        if (this.direction == Direction.horizontal) {
            factorVert = 1.0;
        } else {
            factorHor = 1.0;
        }
        if (transformOriginal) {
            StretchHorVertCommand command = new StretchHorVertCommand(stateInfo, this.originalObject, center, factorHor, factorVert);
        } else {
            this.originalObject.copyToPreviewObject();
            MyObject objectToTransform = this.originalObject.getPreviewObject();
            objectToTransform.stretch(center, factorHor, factorVert);
        }
    }

    public static enum Direction {
        horizontal,
        vertical;

    }
}

