/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.handles;

import commands.SetLineEndpointCommand;
import document.MyLine;
import document.MyObject;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.autoarrange.SnapPosition;
import gui.components.pageviewport.autoarrange.SnapPositions;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.handles.LineHandle;
import util.math.PointDouble;

public class LineHandleController
extends HandleController {
    PointDouble referencedPoint;
    int pointIndex;

    public LineHandleController(MyObject originalObject, int pointIndex, float midX, float midY, double angle, PointDouble referencedPoint, PageViewport pageViewPort) {
        this.originalObject = originalObject;
        this.pointIndex = pointIndex;
        this.referencedPoint = referencedPoint.getCopy();
        this.handle = new LineHandle();
        this.setPositionAngle(midX, midY, angle);
        this.pageViewPortController = pageViewPort.getController();
    }

    @Override
    public void transformByPulling(PointDouble mousePosition, boolean shiftPressed, boolean ctrlPressed, boolean transformOriginal, MarkedObjectsAndHandles stateInfo) {
        SnapPosition snapY;
        PageController pc = this.pageViewPortController.getPageController(this.originalObject.getPage());
        SnapPositions snapPositions = pc.getSnapPositions();
        snapPositions.clearActivePositions();
        double maxSnapDistance = this.pageViewPortController.getSnapDeltaCm();
        PointDouble mouseDelta = mousePosition.getCopy();
        mouseDelta.sub(this.startPoint);
        PointDouble newPosition = this.referencedPoint.getCopy();
        newPosition.add(mouseDelta);
        this.pageViewPortController.setAllArtificialAndBorderLinesToInactive();
        SnapInfo snapInfo = new SnapInfo();
        this.pageViewPortController.snapToGridAndArtificialLines(newPosition, newPosition, snapInfo);
        PointDouble posAfterArtificialLineGridSnap = newPosition.getCopy();
        SnapPosition snapX = snapPositions.isNearPosition(newPosition, maxSnapDistance, SnapPositions.Type.horizontal);
        if (snapX != null) {
            newPosition.setX(snapX.x);
        }
        if ((snapY = snapPositions.isNearPosition(newPosition, maxSnapDistance, SnapPositions.Type.vertical)) != null) {
            newPosition.setY(snapY.y);
        }
        if (snapInfo.xCoordinateGotSnapped) {
            newPosition.x = posAfterArtificialLineGridSnap.x;
        }
        if (snapInfo.yCoordinateGotSnapped) {
            newPosition.y = posAfterArtificialLineGridSnap.y;
        }
        PointDouble mid = new PointDouble(this.originalObject.getMidX(), this.originalObject.getMidY());
        if (shiftPressed) {
            double distance = newPosition.distance(mid);
            double oldDistance = this.referencedPoint.distance(mid);
            double signumX = 0.0;
            signumX = newPosition.x - mid.x >= 0.0 ? 1.0 : -1.0;
            double signumY = 0.0;
            signumY = newPosition.y - mid.y >= 0.0 ? 1.0 : -1.0;
            if (oldDistance > 1.0E-6) {
                PointDouble p = this.referencedPoint.getCopy();
                p.x = Math.abs(p.x - mid.x) * signumX * distance / oldDistance + mid.x;
                p.y = Math.abs(p.y - mid.y) * signumY * distance / oldDistance + mid.y;
                newPosition = p;
            }
        }
        MyObject objectToTransform = null;
        if (!transformOriginal) {
            this.originalObject.copyToPreviewObject();
            objectToTransform = this.originalObject.getPreviewObject();
        }
        PointDouble pSecond = new PointDouble(2.0 * mid.x - newPosition.x, 2.0 * mid.y - newPosition.y);
        if (transformOriginal) {
            SetLineEndpointCommand command1 = new SetLineEndpointCommand((MyLine)this.originalObject, this.pointIndex, newPosition);
            if (ctrlPressed) {
                SetLineEndpointCommand setLineEndpointCommand = new SetLineEndpointCommand((MyLine)this.originalObject, 3 - this.pointIndex, pSecond);
            }
        } else {
            ((MyLine)objectToTransform).setEndPoint(this.pointIndex, newPosition);
            if (ctrlPressed) {
                ((MyLine)objectToTransform).setEndPoint(3 - this.pointIndex, pSecond);
            }
        }
    }
}

