/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.paintjobs;

import document.AbstractKeyboardFocusable;
import document.MyPage;
import gui.components.pageviewport.CursorController;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import gui.components.pageviewport.paintjobs.PaintJob;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class PaintJobPaintTextField
extends PaintJob {
    private AbstractKeyboardFocusable object;
    PageViewPortController controller;
    boolean useBuffer;
    boolean onlyRenderDirtyRegions;
    boolean paintIntoBuffer;

    public PaintJobPaintTextField(AbstractKeyboardFocusable object, PageViewPortController controller, boolean useBuffer, boolean onlyRenderDirtyRegions, boolean paintIntoBuffer) {
        this.object = object;
        this.controller = controller;
        this.useBuffer = useBuffer;
        this.onlyRenderDirtyRegions = onlyRenderDirtyRegions;
        this.paintIntoBuffer = paintIntoBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(PageViewport pageViewPort, Graphics2D g2d) {
        CursorController cc = pageViewPort.getController().getCursorController();
        boolean cursorEnabled = cc.isEnabled();
        cc.setEnabled(false);
        cc.clearCursor(g2d);
        boolean isRotated = Math.abs(this.object.getAngle()) > 1.0E-6;
        Graphics2D g2dBuffer = null;
        if (this.useBuffer) {
            g2dBuffer = pageViewPort.paintObjectToBufferPrepareBuffer(g2d);
            if (!this.paintIntoBuffer) {
                pageViewPort.paintObjectToBufferFlushBuffer(g2d);
            }
        }
        AbstractKeyboardFocusable abstractKeyboardFocusable = this.object;
        synchronized (abstractKeyboardFocusable) {
            MyPage page = this.object.getPage();
            PageViewport viewPort = this.controller.getPageViewport();
            PageController pc = this.controller.getPageController(page);
            double dotsPerCm = viewPort.getScreenResolutioncm();
            double zoomfactor = viewPort.getZoomFactor().getFactor();
            int pageOffsetX = pc.getLeftPixel();
            int pageOffsetY = pc.getTopPixel();
            ViewportGraphicContext vgc = null;
            if (this.paintIntoBuffer) {
                Graphics2D g2dz = this.paintIntoBuffer ? g2dBuffer : g2d;
                vgc = new ViewportGraphicContext(dotsPerCm, zoomfactor, pageOffsetX, pageOffsetY, page.getWidthcm(), page.getHeightcm(), g2dz, null);
            } else {
                vgc = this.controller.getPageViewport().getObjectBufferContext(this.object);
                if (isRotated) {
                    Rectangle r = this.controller.getPanelRect(this.object);
                    vgc.setPanelCoordinates();
                    vgc.setColor(Color.red);
                    vgc.fillRect(0, 0, 100, 100);
                    vgc.translate(-r.x, -r.y);
                    this.controller.getPageViewport().repaintRectangleWithBackgroundimage(r, vgc);
                    vgc.setPageCoordinates();
                }
            }
            vgc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            vgc.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
            this.object.renderActiveTextfield(vgc, this.onlyRenderDirtyRegions && !isRotated && this.controller.getPageViewport().isOldObjectBuffer(), this.controller);
            if (this.object.iconUpdateNecessary() && this.onlyRenderDirtyRegions) {
                this.controller.doRepaint();
            }
            vgc.setPanelCoordinates();
            if (this.paintIntoBuffer) {
                pageViewPort.paintObjectToBufferFlushBuffer(g2d);
            }
            if (this.useBuffer) {
                this.controller.drawIcons(g2d);
            }
            if (!this.paintIntoBuffer) {
                this.controller.getPageViewport().flushObjectBuffer(g2d, this.object);
            }
            viewPort.getPaintJobs().clearDrawCursorJobs();
            cc.setNextPaintBlack();
            cc.setEnabled(cursorEnabled);
        }
    }

    public String toString() {
        return "PaintActiveTextfield";
    }
}

