/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.ruler;

import java.util.ArrayList;
import java.util.Iterator;

public class RulerInfo {
    ArrayList<PageRulerInfo> pageRulerInfoHor = new ArrayList();
    ArrayList<PageRulerInfo> pageRulerInfoVert = new ArrayList();
    double pixelPerCm;

    public RulerInfo(double pixelPerCm) {
        this.pixelPerCm = pixelPerCm;
    }

    public PageRulerIterator getIterator(int fromPixel, int toPixel, Direction direction) {
        if (direction == Direction.horizontal) {
            return new PageRulerIterator(fromPixel, toPixel, this.pageRulerInfoHor);
        }
        return new PageRulerIterator(fromPixel, toPixel, this.pageRulerInfoVert);
    }

    public void addPageRulerInfo(int fromPixel, double lengthCm, Direction rulerDirection) {
        boolean rulerInfoExists = false;
        ArrayList<PageRulerInfo> pageRulerInfo = rulerDirection == Direction.horizontal ? this.pageRulerInfoHor : this.pageRulerInfoVert;
        for (PageRulerInfo pri : pageRulerInfo) {
            if (!pri.isEqual(fromPixel, lengthCm)) continue;
            rulerInfoExists = true;
            break;
        }
        if (!rulerInfoExists) {
            PageRulerInfo pri;
            pri = new PageRulerInfo(fromPixel, lengthCm);
            int insertIndex = pageRulerInfo.size();
            int i = 0;
            while (i < pageRulerInfo.size()) {
                if (pageRulerInfo.get((int)i).fromPixel > pri.fromPixel) {
                    insertIndex = i;
                    break;
                }
                ++i;
            }
            pageRulerInfo.add(insertIndex, pri);
        }
    }

    public double getPixelPerCm() {
        return this.pixelPerCm;
    }

    public static enum Direction {
        horizontal,
        vertical;

    }

    class PageRulerInfo {
        int fromPixel;
        double lengthCm;

        public PageRulerInfo(int fromPixel, double lengthCm) {
            this.fromPixel = fromPixel;
            this.lengthCm = lengthCm;
        }

        public boolean isEqual(int fromPixel, double lengthCm) {
            return this.fromPixel == fromPixel && Math.abs(this.lengthCm - lengthCm) < 1.0E-6;
        }
    }

    public class PageRulerIterator
    implements Iterator<PageRulerInfo> {
        int index;
        int toPixel;
        ArrayList<PageRulerInfo> pageRulerInfo;

        public PageRulerIterator(int fromPixel, int toPixel, ArrayList<PageRulerInfo> pageRulerInfo) {
            this.pageRulerInfo = pageRulerInfo;
            this.index = pageRulerInfo.size();
            this.toPixel = toPixel;
            int i = 0;
            while (i < pageRulerInfo.size()) {
                PageRulerInfo pri = pageRulerInfo.get(i);
                if ((double)pri.fromPixel + pri.lengthCm * RulerInfo.this.pixelPerCm > (double)fromPixel) {
                    this.index = i;
                    break;
                }
                ++i;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.pageRulerInfo.size() && this.pageRulerInfo.get((int)this.index).fromPixel <= this.toPixel;
        }

        @Override
        public PageRulerInfo next() {
            ++this.index;
            return this.pageRulerInfo.get(this.index - 1);
        }

        @Override
        public void remove() {
        }
    }
}

