/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import commands.DrawObjectCommand;
import document.MyLine;
import document.MyObject;
import document.MyPage;
import gui.actions.MyAction;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.autoarrange.SnapInfo;
import gui.components.pageviewport.autoarrange.SnapPositions;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.LeftUpCallBack;
import gui.components.pageviewport.states.StateIdle;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import util.math.MyMath;
import util.math.PointDouble;

public class StatePullDrawingLine
extends AbstractState
implements LeftUpCallBack {
    private PageViewPortController controller;
    private static StatePullDrawingLine instance;
    private PointDouble positionButtonPressed;
    private MyObject object;
    private MyAction action;
    private PointDouble pos = new PointDouble();

    private StatePullDrawingLine(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, PointDouble positionButtonPressed, MyObject object, MyAction action) {
        if (instance == null) {
            instance = new StatePullDrawingLine(controller);
        }
        StatePullDrawingLine.instance.controller = controller;
        StatePullDrawingLine.instance.positionButtonPressed = positionButtonPressed;
        StatePullDrawingLine.instance.object = object;
        StatePullDrawingLine.instance.action = action;
        return instance;
    }

    @Override
    public void ESCpressed() {
        this.controller.getStateInfo().setObjectToDraw(null);
        this.controller.doRepaint();
        this.action.setSelected(false);
        this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(0));
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
        this.controller.addLeftUpCallBack(e, info, this);
        this.controller.doRepaint();
    }

    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        this.changeObject(e, info);
        this.controller.addJobMouseMoveUpdate();
        this.controller.doRepaint();
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
    }

    private void changeObject(MouseEvent e, MouseDocumentInfo info) {
        MyPage page = this.object.getPage();
        info.setPagePoint(this.controller.pixelToPageCm(info.getPPanel(), page));
        this.pos = info.getPPage();
        if (page != null) {
            PageController pc = this.controller.getPageController(page);
            this.controller.setAllArtificialAndBorderLinesToInactive();
            SnapInfo snapInfo = new SnapInfo();
            this.controller.snapToGridAndArtificialLines(this.pos, this.pos, snapInfo);
            PointDouble posAfterArtificialLineGridSnap = this.pos.getCopy();
            SnapPositions snapPositions = pc.getSnapPositions();
            snapPositions.clearActivePositions();
            if (snapPositions.isEmpty()) {
                pc.renewSnapPositions(null);
            }
            double maxDistance = this.controller.getSnapDeltaCm();
            snapPositions.snapPoint(this.pos, this.pos, SnapPositions.Type.horizontal, maxDistance);
            snapPositions.snapPoint(this.pos, this.pos, SnapPositions.Type.vertical, maxDistance);
            if (snapInfo.xCoordinateGotSnapped) {
                this.pos.x = posAfterArtificialLineGridSnap.x;
            }
            if (snapInfo.yCoordinateGotSnapped) {
                this.pos.y = posAfterArtificialLineGridSnap.y;
            }
        }
        if (this.positionButtonPressed.distanceTo(info.getPPage()) > 1.0E-6) {
            PointDouble p1 = this.positionButtonPressed.getCopy();
            PointDouble p2 = info.getPPage().getCopy();
            if (e.isShiftDown()) {
                PointDouble v1 = new PointDouble(1.0, 0.0);
                PointDouble v2 = p2.getCopy();
                v2.sub(p1);
                double angle = MyMath.angle(v1, new PointDouble(0.0, 0.0), v2);
                angle = 0.2617993877991494 * (double)Math.round(angle / 0.2617993877991494);
                double length = p2.distance(p1);
                p2.x = Math.cos(angle) * length + p1.x;
                p2.y = -Math.sin(angle) * length + p1.y;
            }
            if (e.isControlDown()) {
                p1.x = 2.0 * this.positionButtonPressed.x - p2.x;
                p1.y = 2.0 * this.positionButtonPressed.y - p2.y;
            }
            MyLine line = (MyLine)this.object;
            line.setStartPointEndPoint(p1, p2);
        }
    }

    @Override
    public void leftUpCallBack(MouseEvent e, MouseDocumentInfo info) {
        this.controller.getStateInfo().setObjectToDraw(null);
        DrawObjectCommand command = new DrawObjectCommand(this.object, this.object.getPage(), info.getMarkedObjectsAndHandles());
        info.getMarkedObjectsAndHandles().addMarkedObject(this.object);
        info.getMarkedObjectsAndHandles().getHandlesOfMarkedObjects();
        this.controller.doRepaint();
        this.action.setSelected(false);
        this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(0));
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

