/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.LeftUpCallBack;
import gui.components.pageviewport.states.StateIdle;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import util.math.PointDouble;

public class StatePullHandle
extends AbstractState
implements LeftUpCallBack {
    private boolean pullingBlocked = false;
    private Object semaphor = new Object();
    private PageViewPortController controller;
    private PointDouble mouseMoveBegin;
    private HandleController handle;
    private static StatePullHandle instance;

    private StatePullHandle(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, PointDouble mouseMoveBegin, HandleController handle) {
        if (instance == null) {
            instance = new StatePullHandle(controller);
        }
        StatePullHandle.instance.controller = controller;
        instance.setMouseMoveBegin(mouseMoveBegin);
        StatePullHandle.instance.handle = handle;
        return instance;
    }

    @Override
    public void ESCpressed() {
        this.controller.stateChanged(StateIdle.enter(this.controller));
        this.controller.getStateInfo().getHandlesOfMarkedObjects();
        this.controller.doRepaint();
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
        this.controller.addLeftUpCallBack(e, info, this);
        this.controller.doRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        Object object = this.semaphor;
        synchronized (object) {
            if (!this.pullingBlocked) {
                this.pullingBlocked = true;
                MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
                info.setPagePoint(this.controller.pixelToPageCm(info.getPPanel(), stateInfo.getMarkedObjects().getPage()));
                this.handle.pull(new PointDouble(info.getXCm(), info.getYCm()), e.isShiftDown(), e.isControlDown(), stateInfo);
                this.controller.addJobMouseMoveUpdate();
                this.controller.doRepaint();
            }
        }
        object = this.semaphor;
        synchronized (object) {
            this.pullingBlocked = false;
        }
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
    }

    public PointDouble getMouseMoveBegin() {
        return this.mouseMoveBegin;
    }

    public void setMouseMoveBegin(PointDouble mouseMoveBegin) {
        this.mouseMoveBegin = mouseMoveBegin;
    }

    @Override
    public void leftUpCallBack(MouseEvent e, MouseDocumentInfo info) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        info.setPagePoint(this.controller.pixelToPageCm(info.getPPanel(), stateInfo.getMarkedObjects().getPage()));
        this.handle.endPulling(new PointDouble(info.getXCm(), info.getYCm()), e.isShiftDown(), e.isControlDown(), stateInfo);
        this.controller.stateChanged(StateIdle.enter(this.controller));
        this.controller.getStateInfo().getHandlesOfMarkedObjects();
        this.controller.doRepaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

