/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states;

import document.MyObject;
import gui.actions.editgroupzorder.CopyAction;
import gui.actions.editgroupzorder.CutAction;
import gui.actions.editgroupzorder.GroupAction;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.AbstractStateWithContextMenu;
import gui.components.pageviewport.states.StateIdle;
import gui.components.pageviewport.states.StateMoveObject;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import gui.components.popupmenus.contextmenu.ContextmenuPopup;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import util.math.PointDouble;

public class StateRightDownOnObject
extends AbstractStateWithContextMenu {
    private PageViewPortController controller;
    private static StateRightDownOnObject instance;
    private PointDouble positionButtonPressed;
    private MyObject object;
    private boolean popupOpenThereforeNoMove = false;

    private StateRightDownOnObject(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, PointDouble positionButtonPressed, MyObject object) {
        if (instance == null) {
            instance = new StateRightDownOnObject(controller);
        }
        StateRightDownOnObject.instance.controller = controller;
        StateRightDownOnObject.instance.object = object;
        StateRightDownOnObject.instance.positionButtonPressed = positionButtonPressed;
        StateRightDownOnObject.instance.popupOpenThereforeNoMove = false;
        return instance;
    }

    @Override
    public void ESCpressed() {
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        if (!this.popupOpenThereforeNoMove) {
            MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
            if (this.object != null) {
                if (!stateInfo.isMarked(this.object)) {
                    stateInfo.clearMarkedObjects();
                    stateInfo.addMarkedObject(this.object);
                }
                stateInfo.getMarkedObjects().makePreview();
                this.controller.beginMouseMove();
                this.controller.stateChanged(StateMoveObject.enter(this.controller, this.positionButtonPressed));
            } else {
                this.ESCpressed();
            }
        }
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
        MarkedObjectsAndHandles stateInfo = this.controller.getStateInfo();
        if (!stateInfo.getMarkedObjects().getObjects().contains(this.object)) {
            stateInfo.clearMarkedObjects();
            stateInfo.addMarkedObject(this.object);
            stateInfo.getHandlesOfMarkedObjects();
            this.controller.doRepaint();
        }
        ContextmenuPopup popupMenu = ContextmenuPopup.getInstance(this, info.getPPage(), info.getPage(), info.getObject());
        CopyAction.getInstance().setEnabled(stateInfo.getMarkedObjects().getObjects().size() > 0);
        CutAction.getInstance().setEnabled(stateInfo.getMarkedObjects().getObjects().size() > 0);
        GroupAction.getInstance().setEnabled(stateInfo.getMarkedObjects().getObjects().size() > 1);
        this.popupOpenThereforeNoMove = true;
        this.controller.getPageViewport().setCursor(Cursor.getPredefinedCursor(0));
        popupMenu.show(this.controller.getPageViewport(), info.getX(), info.getY());
    }

    @Override
    public void actionAfterContextMenuPopup() {
        this.popupOpenThereforeNoMove = false;
        this.controller.stateChanged(StateIdle.enter(this.controller));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

