/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states.data;

import document.AbstractKeyboardFocusable;
import document.MarkedObjects;
import document.MyDataSharingObject;
import document.MyObject;
import document.Scriptable;
import document.TextStyleChangeable;
import document.events.Eventtype;
import document.text.MyTextField;
import gui.actions.editgroupzorder.AllowDenyEditingAction;
import gui.actions.editgroupzorder.CopyAction;
import gui.actions.editgroupzorder.CutAction;
import gui.actions.editgroupzorder.EditPropertiesAction;
import gui.actions.editgroupzorder.PasteAction;
import gui.actions.objectalignment.ObjectAlignmentBottomAction;
import gui.actions.objectalignment.ObjectAlignmentHorizontalCenterAction;
import gui.actions.objectalignment.ObjectAlignmentHorizontalJustifiedAction;
import gui.actions.objectalignment.ObjectAlignmentLeftAction;
import gui.actions.objectalignment.ObjectAlignmentRightAction;
import gui.actions.objectalignment.ObjectAlignmentTopAction;
import gui.actions.objectalignment.ObjectAlignmentVerticalCenterAction;
import gui.actions.objectalignment.ObjectAlignmentVerticalJustifiedAction;
import gui.actions.textstyle.SetAlignmentCenterAction;
import gui.actions.textstyle.SetAlignmentJustifiedAction;
import gui.actions.textstyle.SetAlignmentLeftAction;
import gui.actions.textstyle.SetAlignmentRightAction;
import gui.actions.textstyle.SetBoldAction;
import gui.actions.textstyle.SetItalicsAction;
import gui.actions.textstyle.SetUnderlinedAction;
import gui.components.mainpanel.MainPanelController;
import gui.components.pageviewport.PageController;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.PageViewport;
import gui.components.pageviewport.handles.HandleController;
import gui.components.pageviewport.paintjobs.PaintJobDrawHandle;
import gui.components.popupmenus.contextmenu.ContextmenuPopup;
import gui.components.toolbars.CommandBar;
import gui.components.toolbars.DrawBar;
import gui.components.toolbars.EditBar;
import gui.components.toolbars.fontchooser.FontNameChooserComboBox;
import gui.components.toolbars.fontchooser.FontSizeChooserComboBox;
import init.Settings;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import util.objectclipboard.ObjectClipboard;

public class MarkedObjectsAndHandles {
    PageViewPortController pageViewPortController;
    private MarkedObjects markedObjects = new MarkedObjects();
    private ArrayList<HandleController> handles = new ArrayList();
    private HandleController highlightedHandle = null;
    private MyObject objectToDraw = null;
    private AbstractKeyboardFocusable keyboardFocusableObject = null;
    private boolean isPopupMenu;
    private boolean openBemerkungsPanelPending;

    public AbstractKeyboardFocusable getKeyboardFocusableObject() {
        return this.keyboardFocusableObject;
    }

    public void setKeyboardFocusableObject(AbstractKeyboardFocusable focusableObject) {
        if (this.isPopupMenu) {
            this.isPopupMenu = false;
        } else {
            if (this.keyboardFocusableObject != null) {
                this.pageViewPortController.getCursorController().addLastClearJobAndSetDisabled();
                this.keyboardFocusableObject.setFocus(false, this.pageViewPortController);
            }
            this.keyboardFocusableObject = focusableObject;
            if (focusableObject != null) {
                if (this.markedObjects.size() > 0) {
                    this.clearMarkedObjects();
                    this.pageViewPortController.addJobPaintAll();
                    this.pageViewPortController.doRepaint();
                }
                focusableObject.setFocus(true, this.pageViewPortController);
                this.pageViewPortController.updateCursor(true);
                if (focusableObject.getCursorShape() != null) {
                    this.pageViewPortController.getCursorController().setEnabled(true);
                }
            } else {
                this.pageViewPortController.doRepaint();
            }
            this.setActionState();
            MainPanelController mpc = MainPanelController.getInstance();
            if (mpc.isBemerkungspanelOpen()) {
                if (focusableObject == null || !(focusableObject instanceof MyTextField)) {
                    mpc.enableBemerkungsSplitPane(false);
                    this.openBemerkungsPanelPending = true;
                } else {
                    MyTextField tf = (MyTextField)focusableObject;
                    if (tf.getScript(Eventtype.TEXTFIELD_CHOOSE_BEMERKUNG) != null) {
                        tf.fireEvent(Eventtype.TEXTFIELD_CHOOSE_BEMERKUNG);
                    } else {
                        mpc.enableBemerkungsSplitPane(false);
                    }
                }
            } else if (this.openBemerkungsPanelPending && focusableObject instanceof MyTextField && ((MyTextField)focusableObject).getScript(Eventtype.TEXTFIELD_CHOOSE_BEMERKUNG) != null) {
                this.openBemerkungsPanelPending = false;
                ((MyTextField)focusableObject).fireEvent(Eventtype.TEXTFIELD_CHOOSE_BEMERKUNG);
            }
        }
    }

    public MarkedObjectsAndHandles(PageViewPortController pageViewPortController) {
        this.pageViewPortController = pageViewPortController;
        this.setActionState();
    }

    public void clearMarkedObjects() {
        this.markedObjects.clear();
        this.clearHandles();
        this.setActionState();
    }

    public MarkedObjects getMarkedObjects() {
        return this.markedObjects;
    }

    public ArrayList<HandleController> getHandles() {
        return this.handles;
    }

    public void clearHandles() {
        this.handles.clear();
        this.highlightedHandle = null;
    }

    public void drawHandles() {
        PageViewport pageViewPort = this.pageViewPortController.getPageViewport();
        Graphics2D g2d = (Graphics2D)pageViewPort.getGraphics();
        this.drawHandles(g2d);
    }

    public void drawHandle(HandleController handle) {
        PageViewport pageViewPort = this.pageViewPortController.getPageViewport();
        Graphics2D g2d = (Graphics2D)pageViewPort.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        pageViewPort.repaintRectangleWithBackgroundimage(handle.getBounds(), g2d);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        handle.draw(g2d);
    }

    public void drawHandles(Graphics2D g2d) {
        for (HandleController handle : this.handles) {
            handle.draw(g2d);
        }
    }

    public void getHandlesOfMarkedObjects() {
        this.clearHandles();
        this.markedObjects.setMetrics();
        this.markedObjects.getHandles(this.handles, this.pageViewPortController.getPageViewport());
    }

    public void addMarkedObject(MyObject object) {
        if (this.markedObjects.size() > 0) {
            if (this.markedObjects.getPage() == object.getPage()) {
                this.markedObjects.add(object);
                this.setActionState();
            }
        } else {
            this.markedObjects.add(object);
            this.markedObjects.setPage(object.getPage());
            this.setActionState();
        }
    }

    public boolean isMarked(MyObject object) {
        return this.markedObjects.getObjects().contains(object);
    }

    public HandleController getHighlightedHandle() {
        return this.highlightedHandle;
    }

    public void setHighlightedHandle(HandleController highlightedHandle) {
        PageViewport viewport = this.pageViewPortController.getPageViewport();
        Rectangle repaintRect = null;
        if (this.highlightedHandle != null) {
            repaintRect = this.highlightedHandle.getBounds();
        }
        if (highlightedHandle != null) {
            if (repaintRect == null) {
                repaintRect = highlightedHandle.getBounds();
            } else {
                repaintRect.add(highlightedHandle.getBounds());
            }
        }
        if (this.highlightedHandle != highlightedHandle) {
            PaintJobDrawHandle job;
            if (this.highlightedHandle != null) {
                this.highlightedHandle.setHighlightState(false);
                job = new PaintJobDrawHandle(this.highlightedHandle);
                viewport.addJob(job);
            }
            if (highlightedHandle != null) {
                highlightedHandle.setHighlightState(true);
                this.highlightedHandle = highlightedHandle;
                job = new PaintJobDrawHandle(this.highlightedHandle);
                viewport.addJob(job);
            }
            viewport.repaint(repaintRect);
            this.highlightedHandle = highlightedHandle;
        }
    }

    public MyObject getObjectToDraw() {
        return this.objectToDraw;
    }

    public void setObjectToDraw(MyObject objectToDraw) {
        this.objectToDraw = objectToDraw;
    }

    public PageController getMarkedObjectsPageController() {
        return this.pageViewPortController.getPageController(this.markedObjects.getPage());
    }

    public void unMarkObject(MyObject object) {
        this.markedObjects.remove(object);
    }

    public void removeMarkedObject(MyObject object) {
        this.markedObjects.remove(object);
    }

    public PageViewPortController getPageViewPortController() {
        return this.pageViewPortController;
    }

    public void setActionState() {
        if (this.getKeyboardFocusableObject() == null && this.markedObjects.size() > 0 || this.getKeyboardFocusableObject() != null && this.getKeyboardFocusableObject().hasMarking()) {
            CopyAction.getInstance().setEnabled(true);
            CutAction.getInstance().setEnabled(true);
        } else {
            CopyAction.getInstance().setEnabled(false);
            CutAction.getInstance().setEnabled(false);
        }
        PasteAction.getInstance().setEnabled(this.getKeyboardFocusableObject() != null || ObjectClipboard.getInstance().hasContent());
        if (this.markedObjects.size() > 0) {
            EditBar.getInstance().setEnabled(true);
            ContextmenuPopup.getMenuForeGroundBackGround().setEnabled(true);
            AllowDenyEditingAction.getInstance().setEnabled(true);
            AllowDenyEditingAction.setState(this.markedObjects.getIsEditingAllowedInFillinModus());
        } else {
            EditBar.getInstance().setEnabled(false);
            ContextmenuPopup.getMenuForeGroundBackGround().setEnabled(false);
            AllowDenyEditingAction.getInstance().setEnabled(false);
        }
        DrawBar.getInstance().setFillColorChooserEnabled(this.markedObjects.size() > 0);
        DrawBar.getInstance().setLineStylesEnabled(this.markedObjects.size() > 0);
        CommandBar.getInstance().setButtonsEnabled(this.markedObjects.size() > 0);
        EditPropertiesAction.getInstance().setEnabled((this.markedObjects.size() == 1 || this.markedObjects.size() == 0) && this.getKeyboardFocusableObject() == null);
        if (this.markedObjects.size() == 1 && this.markedObjects.get(0) instanceof TextStyleChangeable && this.getKeyboardFocusableObject() == null) {
            ContextmenuPopup.getMenuTextfieldVerticalAlignment().setEnabled(true);
        } else {
            ContextmenuPopup.getMenuTextfieldVerticalAlignment().setEnabled(false);
        }
        if (this.markedObjects.size() > 1 && this.keyboardFocusableObject == null) {
            ObjectAlignmentLeftAction.getInstance().setEnabled(true);
            ObjectAlignmentRightAction.getInstance().setEnabled(true);
            ObjectAlignmentTopAction.getInstance().setEnabled(true);
            ObjectAlignmentBottomAction.getInstance().setEnabled(true);
            ObjectAlignmentHorizontalCenterAction.getInstance().setEnabled(true);
            ObjectAlignmentVerticalCenterAction.getInstance().setEnabled(true);
            ContextmenuPopup.getMenuAlignment().setEnabled(true);
        } else {
            ObjectAlignmentLeftAction.getInstance().setEnabled(false);
            ObjectAlignmentRightAction.getInstance().setEnabled(false);
            ObjectAlignmentTopAction.getInstance().setEnabled(false);
            ObjectAlignmentBottomAction.getInstance().setEnabled(false);
            ObjectAlignmentHorizontalCenterAction.getInstance().setEnabled(false);
            ObjectAlignmentVerticalCenterAction.getInstance().setEnabled(false);
            ContextmenuPopup.getMenuAlignment().setEnabled(false);
        }
        if (this.markedObjects.size() > 2 && this.getKeyboardFocusableObject() == null) {
            ObjectAlignmentHorizontalJustifiedAction.getInstance().setEnabled(true);
            ObjectAlignmentVerticalJustifiedAction.getInstance().setEnabled(true);
        } else {
            ObjectAlignmentHorizontalJustifiedAction.getInstance().setEnabled(false);
            ObjectAlignmentVerticalJustifiedAction.getInstance().setEnabled(false);
        }
        if (this.keyboardFocusableObject != null || this.markedObjects.size() == 1 && this.markedObjects.get(0) instanceof TextStyleChangeable && !(this.markedObjects.get(0) instanceof MyTextField)) {
            SetAlignmentCenterAction.getInstance().setEnabled(true);
            SetAlignmentJustifiedAction.getInstance().setEnabled(true);
            SetAlignmentRightAction.getInstance().setEnabled(true);
            SetAlignmentLeftAction.getInstance().setEnabled(true);
        } else {
            SetAlignmentCenterAction.getInstance().setEnabled(false);
            SetAlignmentJustifiedAction.getInstance().setEnabled(false);
            SetAlignmentRightAction.getInstance().setEnabled(false);
            SetAlignmentLeftAction.getInstance().setEnabled(false);
        }
        boolean isKeyboardFocusableObject = this.keyboardFocusableObject != null;
        SetBoldAction.getInstance().setEnabled(isKeyboardFocusableObject);
        SetItalicsAction.getInstance().setEnabled(isKeyboardFocusableObject);
        SetUnderlinedAction.getInstance().setEnabled(isKeyboardFocusableObject);
        FontNameChooserComboBox.getInstance().setEnabled(isKeyboardFocusableObject);
        FontSizeChooserComboBox.getInstance().setEnabled(isKeyboardFocusableObject);
        MyObject potentialDataSharingObject = null;
        if (this.getKeyboardFocusableObject() != null && this.getKeyboardFocusableObject() instanceof Scriptable) {
            MainPanelController.getInstance().setScriptable(this.getKeyboardFocusableObject());
            potentialDataSharingObject = this.getKeyboardFocusableObject();
        } else if (this.markedObjects.size() == 1 && this.markedObjects.get(0) instanceof Scriptable) {
            MainPanelController.getInstance().setScriptable(this.markedObjects.get(0));
            potentialDataSharingObject = this.markedObjects.get(0);
        } else {
            MainPanelController.getInstance().setScriptable(this.pageViewPortController.getDocument());
        }
        if (Settings.getInstance().isEditMode()) {
            if (potentialDataSharingObject != null && potentialDataSharingObject instanceof MyDataSharingObject) {
                MainPanelController.getInstance().getAttributePanelController().setNamedObject((MyDataSharingObject)potentialDataSharingObject);
            } else {
                MainPanelController.getInstance().getAttributePanelController().setNamedObject(null);
            }
        }
    }

    public void setPopupMenu(boolean isPopupMenu) {
        this.isPopupMenu = isPopupMenu;
    }

    public void setOpenBemerkungsPanelPending(boolean openBemerkungsPanelPending) {
        this.openBemerkungsPanelPending = openBemerkungsPanelPending;
    }
}

