/*
 * Decompiled with CFR 0.152.
 */
package gui.components.pageviewport.states.taborderedit;

import commands.SetTabOrderCommand;
import document.AbstractKeyboardFocusable;
import gui.actions.ToggleTabOrderEditAction;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.paintjobs.PaintJobPaintTabArrows;
import gui.components.pageviewport.states.AbstractState;
import gui.components.pageviewport.states.data.MouseDocumentInfo;
import gui.components.pageviewport.states.taborderedit.StateTOEIdle;
import init.Settings;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import util.math.PointDouble;

public class StateLeftDownDraggingFocusArrow
extends AbstractState {
    private PageViewPortController controller;
    private static StateLeftDownDraggingFocusArrow instance;
    private AbstractKeyboardFocusable akfSource;

    private StateLeftDownDraggingFocusArrow(PageViewPortController controller) {
        this.controller = controller;
    }

    public static AbstractState enter(PageViewPortController controller, AbstractKeyboardFocusable akf) {
        if (instance == null) {
            instance = new StateLeftDownDraggingFocusArrow(controller);
        }
        StateLeftDownDraggingFocusArrow.instance.controller = controller;
        StateLeftDownDraggingFocusArrow.instance.akfSource = akf;
        return instance;
    }

    @Override
    public void ESCpressed() {
        Settings.getInstance().setTabOrderEditModus(false);
        ToggleTabOrderEditAction.getInstance().setState();
    }

    @Override
    public void keyboardpressed(KeyEvent e) {
    }

    @Override
    public void mouseLeftDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseLeftUp(MouseEvent e, MouseDocumentInfo info) {
        if (info.getObject() != null && info.getObject() instanceof AbstractKeyboardFocusable) {
            AbstractKeyboardFocusable akfDest = (AbstractKeyboardFocusable)info.getObject();
            SetTabOrderCommand command = new SetTabOrderCommand(this.akfSource, akfDest);
        } else {
            SetTabOrderCommand setTabOrderCommand = new SetTabOrderCommand(this.akfSource, null);
        }
        this.controller.stateChanged(StateTOEIdle.enter(this.controller));
    }

    @Override
    public void mouseMoved(MouseEvent e, MouseDocumentInfo info) {
        if (info.getObject() != null && info.getObject() instanceof AbstractKeyboardFocusable && info.getObject() != this.akfSource) {
            AbstractKeyboardFocusable akfDest = (AbstractKeyboardFocusable)info.getObject();
            this.controller.getPageViewport().addJob(new PaintJobPaintTabArrows(this.akfSource, akfDest, null, this.controller, false));
        } else {
            this.controller.getPageViewport().addJob(new PaintJobPaintTabArrows(this.akfSource, null, new PointDouble(info.getPPanel().getX(), info.getPPanel().getY()), this.controller, false));
        }
        this.controller.doRepaint();
    }

    @Override
    public void mouseRightDown(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void mouseRightUp(MouseEvent e, MouseDocumentInfo info) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

