/*
 * Decompiled with CFR 0.152.
 */
package gui.components.popupmenus.contextmenu;

import commands.DeleteCurrrentPageCommand;
import commands.NewPageCommand;
import commands.baseclasses.AbstractCommand;
import commands.cutcopypaste.PasteObjectsCommand;
import commands.objectaligngroupzorder.ObjectsUngroupCommand;
import document.MyGroup;
import document.MyObject;
import document.MyPage;
import gui.actions.editgroupzorder.AllowDenyEditingAction;
import gui.actions.editgroupzorder.CopyAction;
import gui.actions.editgroupzorder.CutAction;
import gui.actions.editgroupzorder.EditPropertiesAction;
import gui.actions.editgroupzorder.GroupAction;
import gui.actions.objectalignment.ObjectAlignmentBottomAction;
import gui.actions.objectalignment.ObjectAlignmentHorizontalCenterAction;
import gui.actions.objectalignment.ObjectAlignmentHorizontalJustifiedAction;
import gui.actions.objectalignment.ObjectAlignmentLeftAction;
import gui.actions.objectalignment.ObjectAlignmentRightAction;
import gui.actions.objectalignment.ObjectAlignmentTopAction;
import gui.actions.objectalignment.ObjectAlignmentVerticalCenterAction;
import gui.actions.objectalignment.ObjectAlignmentVerticalJustifiedAction;
import gui.actions.objectalignment.ObjectsMoveBackwardsAction;
import gui.actions.objectalignment.ObjectsMoveForwardsAction;
import gui.actions.objectalignment.ObjectsToBackGroundAction;
import gui.actions.objectalignment.ObjectsToForeGroundAction;
import gui.actions.textstyle.SetVerticalTextfieldAlignmentBottomAction;
import gui.actions.textstyle.SetVerticalTextfieldAlignmentCenterAction;
import gui.actions.textstyle.SetVerticalTextfieldAlignmentTopAction;
import gui.components.mainmenu.MyJMenu;
import gui.components.mainmenu.MyJMenuItem;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.AbstractStateWithContextMenu;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;
import util.language.Lang;
import util.math.PointDouble;
import util.objectclipboard.ObjectClipboard;

public class ContextmenuPopup
extends JPopupMenu
implements ActionListener {
    private static ContextmenuPopup instance;
    private AbstractStateWithContextMenu state;
    private static MyJMenu menuAlignment;
    private static MyJMenu menuForegroundBackground;
    private static MyJMenu menuTextfieldVerticalAlignment;
    private static MyJMenuItem insert;
    private static MyJMenuItem unGroup;
    private static MyJMenuItem deletePage;
    private static MyJMenuItem insertPageBefore;
    private static MyJMenuItem insertPageAfter;
    private static MyJMenu menuInsertPage;
    private PointDouble mousePosition;
    private MyPage page;
    private MyObject objectUnderMouseCursor;

    static {
        menuAlignment = new MyJMenu(Lang.get("Ausrichten"));
        menuForegroundBackground = new MyJMenu(Lang.get("Reihenfolge..."));
        menuTextfieldVerticalAlignment = new MyJMenu(Lang.get("Text vertikal ausrichten..."));
        menuInsertPage = new MyJMenu(Lang.get("Seite einf\u00fcgen..."));
    }

    public static ContextmenuPopup getInstance(AbstractStateWithContextMenu stateRightDownOnObject, PointDouble mousePosition, MyPage page, MyObject objectUnderMouseCursor) {
        if (instance == null) {
            instance = new ContextmenuPopup();
        }
        ContextmenuPopup.instance.state = stateRightDownOnObject;
        ContextmenuPopup.instance.mousePosition = mousePosition;
        ContextmenuPopup.instance.page = page;
        ContextmenuPopup.instance.objectUnderMouseCursor = objectUnderMouseCursor;
        insert.setEnabled(page != null && ObjectClipboard.getInstance().hasContent());
        unGroup.setEnabled(objectUnderMouseCursor instanceof MyGroup);
        deletePage.setEnabled(page != null);
        menuInsertPage.setEnabled(page != null);
        return instance;
    }

    public ContextmenuPopup() {
        this.add(CopyAction.getInstance());
        this.add(CutAction.getInstance());
        insert = new MyJMenuItem("Einf\u00fcgen", "data/img/menu/16/editpaste.png");
        insert.addActionListener(this);
        this.add(insert);
        this.addSeparator();
        this.add(GroupAction.getInstance());
        unGroup = new MyJMenuItem("Gruppierung aufheben", "data/img/menu/16/shape_ungroup.png");
        unGroup.addActionListener(this);
        this.add(unGroup);
        menuAlignment.add(ObjectAlignmentLeftAction.getInstance());
        menuAlignment.add(ObjectAlignmentRightAction.getInstance());
        menuAlignment.addSeparator();
        menuAlignment.add(ObjectAlignmentTopAction.getInstance());
        menuAlignment.add(ObjectAlignmentBottomAction.getInstance());
        menuAlignment.addSeparator();
        menuAlignment.add(ObjectAlignmentHorizontalCenterAction.getInstance());
        menuAlignment.add(ObjectAlignmentVerticalCenterAction.getInstance());
        menuAlignment.addSeparator();
        menuAlignment.add(ObjectAlignmentHorizontalJustifiedAction.getInstance());
        menuAlignment.add(ObjectAlignmentVerticalJustifiedAction.getInstance());
        this.add(menuAlignment);
        this.addSeparator();
        menuForegroundBackground.add(ObjectsToForeGroundAction.getInstance());
        menuForegroundBackground.add(ObjectsToBackGroundAction.getInstance());
        menuForegroundBackground.add(ObjectsMoveForwardsAction.getInstance());
        menuForegroundBackground.add(ObjectsMoveBackwardsAction.getInstance());
        this.add(menuForegroundBackground);
        this.addSeparator();
        menuTextfieldVerticalAlignment.add(SetVerticalTextfieldAlignmentTopAction.getInstance());
        menuTextfieldVerticalAlignment.add(SetVerticalTextfieldAlignmentCenterAction.getInstance());
        menuTextfieldVerticalAlignment.add(SetVerticalTextfieldAlignmentBottomAction.getInstance());
        this.add(menuTextfieldVerticalAlignment);
        this.add(EditPropertiesAction.getInstance());
        this.addSeparator();
        this.add(AllowDenyEditingAction.getInstance());
        this.addSeparator();
        deletePage = new MyJMenuItem(Lang.get("Seite l\u00f6schen"), "data/img/menu/16/delete_page.png");
        deletePage.addActionListener(this);
        this.add(deletePage);
        insertPageBefore = new MyJMenuItem(Lang.get("...vor aktueller Seite"), "data/img/menu/16/insert_page_before.png");
        insertPageBefore.addActionListener(this);
        insertPageAfter = new MyJMenuItem(Lang.get("...hinter aktueller Seite"), "data/img/menu/16/insert_page_after.png");
        insertPageAfter.addActionListener(this);
        menuInsertPage.add(insertPageBefore);
        menuInsertPage.add(insertPageAfter);
        this.add(menuInsertPage);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NewPageCommand newPageCommand;
        AbstractCommand command;
        DocumentTabbedPaneController dTPC = DocumentTabbedPaneController.getInstance();
        PageViewPortController controller = dTPC.getActivePageScrollPaneController().getPageViewPortController();
        MarkedObjectsAndHandles stateInfo = controller.getStateInfo();
        if (e.getSource() == insert) {
            command = new PasteObjectsCommand(this.page, this.mousePosition, false);
            DocumentTabbedPaneController.getInstance().getTabbedPane().repaint();
        }
        if (e.getSource() == deletePage) {
            command = new DeleteCurrrentPageCommand(controller, this.page);
        }
        if (e.getSource() == insertPageAfter) {
            int index = controller.getView().indexOfPage(this.page);
            newPageCommand = new NewPageCommand(controller, false, index + 1);
        }
        if (e.getSource() == insertPageBefore) {
            int index = controller.getView().indexOfPage(this.page);
            newPageCommand = new NewPageCommand(controller, false, index);
        }
        if (e.getSource() == unGroup && this.objectUnderMouseCursor instanceof MyGroup) {
            ObjectsUngroupCommand command2 = new ObjectsUngroupCommand(stateInfo, (MyGroup)this.objectUnderMouseCursor);
            DocumentTabbedPaneController.getInstance().getTabbedPane().repaint();
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.state.actionAfterContextMenuPopup();
        }
        super.setVisible(b);
    }

    public static MyJMenu getMenuAlignment() {
        return menuAlignment;
    }

    public static MyJMenu getMenuForeGroundBackGround() {
        return menuForegroundBackground;
    }

    public static MyJMenu getMenuTextfieldVerticalAlignment() {
        return menuTextfieldVerticalAlignment;
    }
}

