/*
 * Decompiled with CFR 0.152.
 */
package gui.components.popupmenus.textpopupmenu;

import commands.changetext.InsertCharactersCommand;
import document.text.AttributedText;
import document.text.MyTextField;
import document.text.TextFieldController;
import document.text.TextStyle;
import document.text.menutext.TextMenu;
import gui.components.pageviewport.PageViewPortController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TextPopupMenu
extends JPopupMenu
implements ActionListener {
    private TextMenu textMenu;
    private PageViewPortController controller;
    private MyTextField textfield;
    private boolean textfieldHasFocus;
    private JMenuItem[] menuitems;

    public TextPopupMenu(TextMenu textMenu, PageViewPortController controller, MyTextField textfield) {
        this.textMenu = textMenu;
        this.controller = controller;
        this.textfield = textfield;
        this.textfieldHasFocus = textfield.hasFocus();
        this.menuitems = new JMenuItem[textMenu.getMenuitems().size()];
        int i = 0;
        while (i < this.menuitems.length) {
            this.menuitems[i] = new JMenuItem(textMenu.getItem(i));
            this.menuitems[i].addActionListener(this);
            this.add(this.menuitems[i]);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)e.getSource();
            int itemIndex = -1;
            int i = 0;
            while (i < this.menuitems.length) {
                JMenuItem mi = this.menuitems[i];
                if (mi == item) {
                    itemIndex = i;
                    break;
                }
                ++i;
            }
            if (itemIndex != -1) {
                String newText = this.textMenu.getItem(itemIndex);
                TextFieldController tc = this.textfield.getTextfieldController();
                AttributedText at = tc.getAttributedText();
                int start = at.getStartOfTextMenu(this.textMenu);
                int end = at.getEndOfTextMenu(this.textMenu);
                int cursorBefore = tc.getCursorPos();
                int cursorAfter = cursorBefore <= start ? cursorBefore : cursorBefore + newText.length() - (end - start);
                if (start != -1 && end != -1) {
                    TextStyle textStyle = at.getTextStyle(start);
                    InsertCharactersCommand ic = new InsertCharactersCommand(start, cursorBefore, cursorAfter, start, end, newText, textStyle, tc, this.textfield.getDocument().getCommandManager(), this.textMenu);
                    if (this.textfieldHasFocus) {
                        this.controller.getPageViewport().grabFocus();
                        this.controller.getStateInfo().setKeyboardFocusableObject(this.textfield);
                        this.textfield.getTextfieldController().setCursor(cursorAfter);
                        this.controller.updateCursor(true);
                    }
                    this.textfield.getTextfieldController().reformatWholeLayout();
                    this.controller.doRepaint();
                }
            }
        }
    }
}

