/*
 * Decompiled with CFR 0.152.
 */
package gui.components.toolbars.colorchooser;

import gui.components.toolbars.colorchooser.ColorButton;
import gui.components.toolbars.colorchooser.ColorChooserListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import util.language.Lang;
import util.language.LanguageComponent;

public class ColorChooserPanel
extends JPanel
implements LanguageComponent,
ChangeListener {
    private int columns = 7;
    private int maxLastUsedColors = this.columns * 2;
    private ColorButton[] lastUsedColors = new ColorButton[this.maxLastUsedColors];
    private boolean[] isUsed = new boolean[this.maxLastUsedColors];
    private JPanel lastUsedColorsPanel;
    private int nextFreeUsedColor = 0;
    private int rowsOfFixedColors = 6;
    private ColorButton[] fixedColors = new ColorButton[this.columns * this.rowsOfFixedColors];
    private static int[] colors;
    private JPanel fixedColorsPanel;
    private JSlider alphaSlider = new JSlider(0, 255, 0);
    private JLabel transparencyLabel = new JLabel();
    private JPanel sliderPanel;
    private JButton moreColorsButton = new JButton();
    private JButton withOutColorButton = new JButton();
    private String withOutColorText;
    private ColorChooserListener colorChooserListener;

    static {
        int[] nArray = new int[42];
        nArray[0] = 0x333333;
        nArray[1] = 0x5A5A5A;
        nArray[2] = 0x808080;
        nArray[3] = 0x999999;
        nArray[4] = 0xC0C0C0;
        nArray[5] = 0xE0E0E0;
        nArray[6] = 0xFFFFFF;
        nArray[8] = 13209;
        nArray[9] = 13107;
        nArray[10] = 13056;
        nArray[11] = 0x663300;
        nArray[12] = 0x800000;
        nArray[13] = 0x993333;
        nArray[14] = 128;
        nArray[15] = 26367;
        nArray[16] = 32896;
        nArray[17] = 32768;
        nArray[18] = 0x808000;
        nArray[19] = 0xFF0000;
        nArray[20] = 0x996666;
        nArray[21] = 255;
        nArray[22] = 39423;
        nArray[23] = 52377;
        nArray[24] = 0x669933;
        nArray[25] = 0xCCCC33;
        nArray[26] = 0xFF6633;
        nArray[27] = 0x800080;
        nArray[28] = 0xFF00FF;
        nArray[29] = 52479;
        nArray[30] = 65535;
        nArray[31] = 65280;
        nArray[32] = 0xFFFF00;
        nArray[33] = 0xFFCC00;
        nArray[34] = 0x663399;
        nArray[35] = 0xCC99FF;
        nArray[36] = 0x99CCFF;
        nArray[37] = 0x99FFFF;
        nArray[38] = 0xCCFFCC;
        nArray[39] = 0xFFFFCC;
        nArray[40] = 0xFFCC99;
        nArray[41] = 0xFF99CC;
        colors = nArray;
    }

    public void colorButtonPressed(Color color) {
        this.colorChooserListener.colorPicked(color);
    }

    public ColorChooserPanel(ColorChooserListener colorChooserListener, boolean withAlphaValueSlider, String withOutColorText) {
        Lang.registerComponent(this);
        this.withOutColorText = withOutColorText;
        this.colorChooserListener = colorChooserListener;
        this.languageChanged();
        int i = 0;
        while (i < this.isUsed.length) {
            this.isUsed[i] = false;
            ++i;
        }
        i = 0;
        while (i < this.lastUsedColors.length) {
            this.lastUsedColors[i] = new ColorButton(Color.black, this);
            ++i;
        }
        this.makePanels();
        this.makeLastUsedColorsPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.lastUsedColorsPanel);
        this.add(new JPopupMenu.Separator());
        this.add(this.fixedColorsPanel);
        this.moreColorsButton.setFocusable(false);
        JPanel moreColorsPanel = new JPanel(new BorderLayout());
        moreColorsPanel.add((Component)this.moreColorsButton, "Center");
        this.add(moreColorsPanel);
        this.withOutColorButton.setFocusable(false);
        JPanel withoutColorPanel = new JPanel(new BorderLayout());
        withoutColorPanel.add((Component)this.withOutColorButton, "Center");
        this.add(withoutColorPanel);
        this.add(new JPopupMenu.Separator());
        if (withAlphaValueSlider) {
            this.add(this.sliderPanel);
        }
        this.withOutColorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ColorChooserPanel.this.withoutColorButtonPressed();
                super.mouseClicked(e);
            }
        });
        this.moreColorsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ColorChooserPanel.this.moreColorsButtonPressed();
                super.mouseClicked(e);
            }
        });
    }

    private void makeLastUsedColorsPanel() {
        int count = 0;
        int i = 0;
        while (i < this.isUsed.length) {
            if (!this.isUsed[i]) break;
            count = i + 1;
            ++i;
        }
        int rows = (count - 1) / this.columns + 1;
        this.lastUsedColorsPanel.removeAll();
        this.lastUsedColorsPanel.setLayout(new GridLayout(rows, this.columns, 1, 1));
        int i2 = 0;
        while (i2 < count) {
            this.lastUsedColorsPanel.add(this.lastUsedColors[i2]);
            ++i2;
        }
        Dimension d = new Dimension(ColorButton.getButtonWidth(), ColorButton.getButtonWidth());
        if (count % this.columns > 0) {
            int i3 = count;
            while (i3 < rows * this.columns) {
                JPanel panel = new JPanel();
                panel.setPreferredSize(d);
                this.lastUsedColorsPanel.add(panel);
                ++i3;
            }
        }
    }

    private void makePanels() {
        this.lastUsedColorsPanel = new JPanel();
        this.fixedColorsPanel = new JPanel(new GridLayout(this.rowsOfFixedColors, this.columns, 1, 1));
        this.makeFixedColorButton1s();
        int i = 0;
        while (i < this.fixedColors.length) {
            this.fixedColorsPanel.add(this.fixedColors[i]);
            ++i;
        }
        this.sliderPanel = new JPanel();
        Dimension alphaSliderSize = this.alphaSlider.getPreferredSize();
        alphaSliderSize.width = 50;
        this.alphaSlider.setPreferredSize(alphaSliderSize);
        this.sliderPanel.setLayout(new BorderLayout());
        this.sliderPanel.add(this.transparencyLabel);
        this.sliderPanel.add((Component)this.alphaSlider, "South");
        this.sliderPanel.setFocusable(false);
        this.alphaSlider.setFocusable(false);
        this.alphaSlider.addChangeListener(this);
    }

    private void makeFixedColorButton1s() {
        int i = 0;
        while (i < colors.length) {
            this.fixedColors[i] = new ColorButton(new Color(colors[i]), this);
            ++i;
        }
    }

    @Override
    public void languageChanged() {
        this.transparencyLabel.setText(Lang.get("Transparenz:"));
        this.moreColorsButton.setText(Lang.get("Weitere Farben..."));
        this.withOutColorButton.setText(Lang.get(this.withOutColorText));
    }

    public void addLastUsedColor(Color c) {
        this.isUsed[this.nextFreeUsedColor] = true;
        this.lastUsedColors[this.nextFreeUsedColor].setColor(c);
        ++this.nextFreeUsedColor;
        if (this.nextFreeUsedColor == this.maxLastUsedColors) {
            this.nextFreeUsedColor = 0;
        }
        this.makeLastUsedColorsPanel();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        this.colorChooserListener.alphaChanged(255 - source.getValue(), source.getValueIsAdjusting());
    }

    public void moreColorsButtonPressed() {
        Color newColor = JColorChooser.showDialog(this, "Choose Background Color", Color.black);
        if (newColor != null) {
            this.colorChooserListener.colorPicked(newColor);
            this.addLastUsedColor(newColor);
            this.makeLastUsedColorsPanel();
        }
    }

    public void withoutColorButtonPressed() {
        this.colorChooserListener.withoutColorPicked();
    }
}

