/*
 * Decompiled with CFR 0.152.
 */
package gui.forms;

import commands.StretchHorVertCommand;
import document.MarkedObjects;
import document.MyObject;
import document.MyPage;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.components.tabbedpane.DocumentTabbedPaneController;
import gui.forms.StretchFrame;
import util.math.PointDouble;

public class StretchFrameController {
    private MarkedObjectsAndHandles stateInfo;
    private StretchFrame stretchFrame;

    public StretchFrameController(MarkedObjectsAndHandles stateInfo) {
        this.stateInfo = stateInfo;
        MarkedObjects mo = stateInfo.getMarkedObjects();
        this.stretchFrame = new StretchFrame(this, (float)mo.getWidth(), (float)mo.getHeight());
    }

    public void showWindow() {
        this.stretchFrame.setVisible(true);
    }

    public void executeStretchCommand(float width, float height, MyObject.DirectionX dirX, MyObject.DirectionY dirY) {
        MyPage page = this.stateInfo.getMarkedObjects().getPage();
        if (page != null) {
            MarkedObjects mo = this.stateInfo.getMarkedObjects();
            PointDouble stretchCenter = mo.getEdgeRotated(dirX, dirY);
            double factorHor = 1.0;
            if (Math.abs(mo.getWidth()) > 1.0E-8) {
                factorHor = (double)width / mo.getWidth();
            }
            double factorVert = 1.0;
            if (Math.abs(mo.getHeight()) > 1.0E-8) {
                factorVert = (double)height / mo.getHeight();
            }
            StretchHorVertCommand stretchHorVertCommand = new StretchHorVertCommand(this.stateInfo, mo, stretchCenter, factorHor, factorVert);
        }
        this.stateInfo.clearHandles();
        this.stateInfo.getHandlesOfMarkedObjects();
        DocumentTabbedPaneController.getInstance().getTabbedPane().repaint();
    }
}

