/*
 * Decompiled with CFR 0.152.
 */
package gui.handles;

import gui.handles.HandleGui;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import util.math.MyMath;
import util.math.PointDouble;
import util.svg.SVGPathParser;

public abstract class PathHandle
implements HandleGui {
    String svgPath;
    GeneralPath path;
    float x1;
    float y1;
    float x2;
    float y2;
    float midX;
    float midY;
    Color startNormal;
    Color endNormal;
    Color startHighlight;
    Color endHighlight;
    Color lineColor;
    int lineWidthNormal;
    int lineWidthHighlighted;
    GeneralPath transformedPath;
    Rectangle boundingBox;
    GradientPaint gradientPaintNormal;
    GradientPaint gradientPaintHighLighted;
    Color colorNormal;
    Color colorHightlighted;
    boolean isGradientFilling = true;

    public void setColors(Color startNormal, Color endNormal, float x1, float y1, Color startHighlight, Color endHighlight, float x2, float y2, Color lineColor, int lineWidthNormal, int lineWidthHighlighted) {
        this.startNormal = startNormal;
        this.endNormal = endNormal;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.startHighlight = startHighlight;
        this.endHighlight = endHighlight;
        this.lineColor = lineColor;
        this.lineWidthNormal = lineWidthNormal;
        this.lineWidthHighlighted = lineWidthHighlighted;
        this.isGradientFilling = true;
    }

    public void setColors(Color colorNormal, Color colorHighlighted, Color lineColor, int lineWidthNormal, int lineWidthHighlighted) {
        this.colorNormal = colorNormal;
        this.colorHightlighted = colorHighlighted;
        this.lineColor = lineColor;
        this.lineWidthNormal = lineWidthNormal;
        this.lineWidthHighlighted = lineWidthHighlighted;
        this.isGradientFilling = false;
    }

    public void setSVGPath(String svgPath) {
        this.svgPath = svgPath;
        SVGPathParser parser = new SVGPathParser();
        this.path = parser.createGeneralPath(svgPath);
    }

    @Override
    public boolean contains(int x, int y) {
        boolean inside = this.boundingBox.contains(x, y);
        if (inside) {
            inside = this.transformedPath.contains(x, y);
        }
        return inside;
    }

    @Override
    public void translateRotate(Point2D mid, double angle, Graphics2D g2d) {
        AffineTransform g2dTrafo = g2d.getTransform();
        PointDouble midPanel = new PointDouble();
        g2dTrafo.transform(mid, midPanel);
        float x = (float)midPanel.getX();
        float y = (float)midPanel.getY();
        this.translateRotate(x, y, angle);
    }

    @Override
    public void draw(Graphics2D g2d, boolean highlighted) {
        if (highlighted) {
            if (this.isGradientFilling) {
                g2d.setPaint(this.gradientPaintHighLighted);
            } else {
                g2d.setPaint(this.colorHightlighted);
            }
            g2d.fill(this.transformedPath);
            g2d.setStroke(new BasicStroke(this.lineWidthHighlighted));
            g2d.setColor(this.lineColor);
            g2d.draw(this.transformedPath);
        } else {
            if (this.isGradientFilling) {
                g2d.setPaint(this.gradientPaintNormal);
            } else {
                g2d.setPaint(this.colorNormal);
            }
            g2d.fill(this.transformedPath);
            g2d.setStroke(new BasicStroke(this.lineWidthNormal));
            g2d.setColor(this.lineColor);
            g2d.draw(this.transformedPath);
        }
    }

    @Override
    public void translateRotate(float midX, float midY, double angle) {
        this.midX = midX;
        this.midY = midY;
        angle = -angle;
        AffineTransform at = new AffineTransform();
        at.setToIdentity();
        at.translate(midX, midY);
        at.rotate(angle);
        this.transformedPath = (GeneralPath)this.path.clone();
        this.transformedPath.transform(at);
        this.boundingBox = this.transformedPath.getBounds();
        PointDouble p1 = new PointDouble(midX + this.x1, midY + this.y1);
        MyMath.rotate(p1, midX, midY, -angle);
        PointDouble p2 = new PointDouble(midX + this.x2, midY + this.y2);
        MyMath.rotate(p2, midX, midY, -angle);
        float xs = (float)p1.getX();
        float ys = (float)p1.getY();
        float xe = (float)p2.getX();
        float ye = (float)p2.getY();
        if (this.isGradientFilling) {
            this.gradientPaintNormal = new GradientPaint(xs, ys, this.startNormal, xe, ye, this.endNormal);
            this.gradientPaintHighLighted = new GradientPaint(xs, ys, this.startHighlight, xe, ye, this.endHighlight);
        }
    }

    @Override
    public Rectangle getBounds() {
        Rectangle r = this.transformedPath.getBounds();
        r.x -= 4;
        r.width += 2;
        r.y -= 4;
        r.height += 2;
        return r;
    }

    public int getLineWidthNormal() {
        return this.lineWidthNormal;
    }

    public void setLineWidthNormal(int lineWidthNormal) {
        this.lineWidthNormal = lineWidthNormal;
    }

    public int getLineWidthHighlighted() {
        return this.lineWidthHighlighted;
    }

    public void setLineWidthHighlighted(int lineWidthHighlighted) {
        this.lineWidthHighlighted = lineWidthHighlighted;
    }
}

