/*
 * Decompiled with CFR 0.152.
 */
package gui.icons;

import document.MyObject;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.graphiccontext.ViewportGraphicContext;
import gui.icons.ImageLoader;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import util.math.PointDouble;

public class ViewportIcon {
    private IconPosition iconPosition;
    private PointDouble offsetCm;
    private Point offsetPixel;
    private MyObject object;
    private Image normalStateImage = null;
    private Image hoverStateImage = null;
    private Image clickedStateImage = null;
    private MouseState mouseState = MouseState.normal;

    public ViewportIcon(String pathToNormalStateImage, String pathToHoverStateImage, String pathToClickedStateImage, IconPosition iconPosition, PointDouble offsetCm, Point offsetPixel, MyObject object) {
        this.normalStateImage = ImageLoader.getImage(pathToNormalStateImage);
        this.hoverStateImage = ImageLoader.getImage(pathToHoverStateImage);
        this.clickedStateImage = ImageLoader.getImage(pathToClickedStateImage);
        this.iconPosition = iconPosition;
        this.offsetCm = offsetCm;
        this.offsetPixel = offsetPixel;
        this.object = object;
        if (object == null) {
            iconPosition = IconPosition.absoluteOnPage;
        }
    }

    public void render(ViewportGraphicContext vgc, PageViewPortController controller) {
        vgc.setPageCoordinates();
        AffineTransform atPage = vgc.getTransform();
        atPage.preConcatenate(vgc.getInversePanelTransform());
        vgc.setPanelCoordinates();
        Image image = this.normalStateImage;
        if (this.mouseState == MouseState.hover && this.hoverStateImage != null) {
            image = this.hoverStateImage;
        }
        if (this.mouseState == MouseState.clicked && this.clickedStateImage != null) {
            image = this.clickedStateImage;
        }
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        Point p = this.computePosition(atPage, imageWidth, imageHeight);
        controller.getPageViewport().repaintRectangleWithBackgroundimage(new Rectangle(p.x, p.y, imageWidth, imageHeight), vgc);
        if (this.mouseState != MouseState.invisible) {
            vgc.drawImage(image, p.x, p.y, null);
        }
        vgc.setPanelCoordinates();
    }

    private Point computePosition(AffineTransform atPage, int imageWidth, int imageHeight) {
        PointDouble pos;
        switch (this.iconPosition) {
            case absoluteOnPage: {
                pos = new PointDouble(0.0, 0.0);
                break;
            }
            case bottomBorderLeft: 
            case leftBorderBottom: {
                pos = new PointDouble(this.object.getMidX() - this.object.getWidth() / 2.0, this.object.getMidY() + this.object.getHeight() / 2.0);
                break;
            }
            case rightBorderBottom: 
            case bottomBorderRight: {
                pos = new PointDouble(this.object.getMidX() + this.object.getWidth() / 2.0, this.object.getMidY() + this.object.getHeight() / 2.0);
                break;
            }
            case topBorderLeft: 
            case leftBorderTop: {
                pos = new PointDouble(this.object.getMidX() - this.object.getWidth() / 2.0, this.object.getMidY() - this.object.getHeight() / 2.0);
                break;
            }
            case topBorderRight: 
            case rightBorderTop: {
                pos = new PointDouble(this.object.getMidX() + this.object.getWidth() / 2.0, this.object.getMidY() - this.object.getHeight() / 2.0);
                break;
            }
            default: {
                pos = null;
            }
        }
        PointDouble posPanel = new PointDouble();
        atPage.transform(pos, posPanel);
        switch (this.iconPosition) {
            case leftBorderTop: {
                posPanel.x -= (double)imageWidth;
                break;
            }
            case leftBorderBottom: {
                posPanel.x -= (double)imageWidth;
                posPanel.y -= (double)imageHeight;
                break;
            }
            case bottomBorderRight: {
                posPanel.x -= (double)imageWidth;
                break;
            }
            case rightBorderBottom: {
                posPanel.y -= (double)imageHeight;
                break;
            }
            case topBorderLeft: {
                posPanel.y -= (double)imageHeight;
                break;
            }
            case topBorderRight: {
                posPanel.y -= (double)imageHeight;
                posPanel.x -= (double)imageWidth;
                break;
            }
        }
        posPanel.x += (double)this.offsetPixel.x;
        posPanel.x += (double)this.offsetPixel.y;
        Point p = new Point((int)posPanel.x, (int)posPanel.y);
        return p;
    }

    public MouseState getMouseState() {
        return this.mouseState;
    }

    public void setMouseState(MouseState mouseState) {
        this.mouseState = mouseState;
    }

    public PointDouble getOffsetCm() {
        return this.offsetCm;
    }

    public void setOffsetCm(PointDouble offsetCm) {
        this.offsetCm = offsetCm;
    }

    public Point getOffsetPixel() {
        return this.offsetPixel;
    }

    public int getWidthPixel() {
        return this.normalStateImage.getWidth(null);
    }

    public int getHeightPixel() {
        return this.normalStateImage.getHeight(null);
    }

    public Image getNormalStateImage() {
        return this.normalStateImage;
    }

    public static enum IconPosition {
        absoluteOnPage,
        topBorderLeft,
        topBorderRight,
        rightBorderTop,
        rightBorderBottom,
        bottomBorderLeft,
        bottomBorderRight,
        leftBorderTop,
        leftBorderBottom;

    }

    public static enum MouseState {
        normal,
        hover,
        clicked,
        invisible;

    }
}

