/*
 * Decompiled with CFR 0.152.
 */
package gui.nbcomponents.components;

import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import util.language.Lang;
import util.language.LanguageComponent;

public class MyJTabbedPane
extends JTabbedPane
implements Serializable,
LanguageComponent {
    private HashMap<Component, String> componentTexts = new HashMap();
    private HashMap<String, Component> textComponents = new HashMap();

    public MyJTabbedPane() {
        Lang.registerComponent(this);
    }

    public void setEnabled(String componentTitle, boolean enabled) {
        if (enabled) {
            this.addComponent(componentTitle);
        } else {
            this.remove(this.textComponents.get(componentTitle));
        }
    }

    public void addComponent(String title) {
        boolean exists = false;
        int i = 0;
        while (i < this.getComponentCount()) {
            if (this.textComponents.get(title) == this.getComponent(i)) {
                exists = true;
                break;
            }
            ++i;
        }
        if (!exists) {
            this.add(title, this.textComponents.get(title));
        }
    }

    public HashMap<Component, String> getComponentTexts() {
        return this.componentTexts;
    }

    @Override
    public void addTab(String title, Component component) {
        super.addTab(title, component);
        this.componentTexts.put(component, title);
        this.textComponents.put(title, component);
        this.languageChanged();
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        super.addTab(title, icon, component);
        this.componentTexts.put(component, title);
        this.languageChanged();
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        this.componentTexts.put(component, title);
        this.languageChanged();
    }

    @Override
    public void languageChanged() {
        int i = 0;
        while (i < this.getTabCount()) {
            Component component = this.getComponentAt(i);
            this.setTitleAt(i, Lang.get(this.componentTexts.get(component)));
            ++i;
        }
    }
}

