/*
 * Decompiled with CFR 0.152.
 */
package gui.netbeansforms;

import commands.RotateCommand;
import commands.SetDataSourceCommand;
import commands.SetNameCommand;
import commands.StretchHorVertCommand;
import commands.baseclasses.MarkedObjectsPreserveCommand;
import commands.changemarkfield.SetMarkModelCommand;
import commands.changemarkfield.SetTextfieldBordersCommand;
import document.MyDataSharingObject;
import document.MyDocument;
import document.MyObject;
import document.MyPage;
import document.Renderable;
import document.TextStyleChangeable;
import document.marks.BorderType;
import document.marks.MarkModelFactory;
import document.marks.MyMarkField;
import document.view.MyView;
import gui.components.pageviewport.PageViewPortController;
import gui.components.pageviewport.states.data.MarkedObjectsAndHandles;
import gui.nbcomponents.frames.AbstractPropertyEditorController;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import util.io.IO;
import util.language.Lang;
import util.math.MyMath;
import util.math.PointDouble;

public class PropertyEditorController
extends AbstractPropertyEditorController {
    private static PropertyEditorController instance;
    private PageViewPortController viewportController;
    private ArrayList<MyObject> possibleDataSource;
    private MyObject object;

    public static PropertyEditorController getInstance() {
        if (instance == null) {
            instance = new PropertyEditorController();
        }
        return instance;
    }

    private PropertyEditorController() {
        this.setComboBoxMarkModelItems(MarkModelFactory.getInstance().getTypeNames());
        this.propertyEditor.setIconImage(IO.loadImage("data/img/menu/16/edit_properties.png").getImage());
    }

    public void showPropertyEditor(PageViewPortController viewportController) {
        this.viewportController = viewportController;
        MarkedObjectsAndHandles stateInfo = viewportController.getStateInfo();
        if (stateInfo.getMarkedObjects().size() == 1) {
            boolean isDataSharingObject;
            boolean isMarkField;
            this.showWidthHeightAngle(stateInfo);
            boolean isTextfield = this.object instanceof TextStyleChangeable;
            if (isTextfield) {
                this.showTextfieldBorders();
            }
            if (isMarkField = this.object instanceof MyMarkField) {
                MyMarkField markfield = (MyMarkField)this.object;
                this.setComboBoxMarkModelSelection(MarkModelFactory.getInstance().getIndex(markfield.getModel()));
            }
            if (isDataSharingObject = this.object instanceof MyDataSharingObject) {
                this.showDataSharer();
                MyDataSharingObject mds = (MyDataSharingObject)this.object;
                this.propertyEditor.getTextFieldName().setText(mds.getName());
            }
            boolean isQuadratic = this.object.isDrawOnlyQuadratic();
            this.showPropertyEditor(true, isTextfield, isMarkField, isDataSharingObject, isQuadratic);
        }
    }

    private void showDataSharer() {
        JList listDataSharer = this.propertyEditor.getListDataSharers();
        MyDataSharingObject mds = (MyDataSharingObject)this.object;
        Object[] dataSharerNames = new Object[mds.getDataSharers().size()];
        int i = 0;
        while (i < mds.getDataSharers().size()) {
            dataSharerNames[i] = mds.getDataSharers().get(i).getName();
            ++i;
        }
        listDataSharer.setListData(dataSharerNames);
        JComboBox comboBoxDataSource = this.propertyEditor.getComboBoxDataSource();
        MyDocument document = mds.getDocument();
        this.possibleDataSource = this.getObjectList(document, mds);
        String[] dataSource = new String[this.possibleDataSource.size() + 1];
        int i2 = 0;
        while (i2 < this.possibleDataSource.size()) {
            MyDataSharingObject mdo = (MyDataSharingObject)this.possibleDataSource.get(i2);
            dataSource[i2 + 1] = mdo.getName();
            ++i2;
        }
        dataSource[0] = Lang.get("keines");
        comboBoxDataSource.setModel(new DefaultComboBoxModel<String>(dataSource));
        if (mds.getDataSource() != null) {
            int index = this.possibleDataSource.indexOf(mds.getDataSource());
            comboBoxDataSource.setSelectedIndex(index + 1);
        } else {
            comboBoxDataSource.setSelectedIndex(0);
        }
    }

    private void showTextfieldBorders() {
        TextStyleChangeable textField = (TextStyleChangeable)((Object)this.object);
        this.propertyEditor.getUnitSpinnerTextfieldLeft().setValue(new Double(textField.getBorder(BorderType.left)));
        this.propertyEditor.getUnitSpinnerTextfieldRight().setValue(new Double(textField.getBorder(BorderType.right)));
        this.propertyEditor.getUnitSpinnerTextfieldTop().setValue(new Double(textField.getBorder(BorderType.top)));
        this.propertyEditor.getUnitSpinnerTextfieldBottom().setValue(new Double(textField.getBorder(BorderType.bottom)));
    }

    private void showWidthHeightAngle(MarkedObjectsAndHandles stateInfo) {
        this.object = stateInfo.getMarkedObjects().get(0);
        this.propertyEditor.getUnitSpinnerWidth().setValue(this.object.getWidth());
        this.propertyEditor.getUnitSpinnerHeight().setValue(this.object.getHeight());
        this.propertyEditor.getUnitSpinnerAngle().setValue(this.object.getAngleInDegrees());
    }

    private ArrayList<MyObject> getObjectList(MyDocument document, MyObject typeObject) {
        ArrayList<MyObject> list = new ArrayList<MyObject>();
        for (MyView view : document.views) {
            for (MyPage page : view.pages) {
                for (MyObject object : page.objects) {
                    if (object.getType() != typeObject.getType()) continue;
                    if (object.getType() == Renderable.ObjectType.markfield) {
                        MyMarkField mTypeObject = (MyMarkField)typeObject;
                        MyMarkField mObject = (MyMarkField)object;
                        if (mTypeObject.getType() != mObject.getType() || mTypeObject == mObject || mObject.getDataSource() != null) continue;
                        list.add(object);
                        continue;
                    }
                    if (object == typeObject || ((MyDataSharingObject)object).getDataSource() != null) continue;
                    list.add(object);
                }
            }
        }
        return list;
    }

    @Override
    public void buttonOKActionPerformed() {
        this.setNewMyObjectValues();
        if (this.object instanceof TextStyleChangeable) {
            this.setNewMyTextFieldValues();
        }
        if (this.object instanceof MyMarkField) {
            this.setNewMyMarkfieldValues();
        }
        if (this.object instanceof MyDataSharingObject) {
            MyDataSharingObject mds = (MyDataSharingObject)this.object;
            this.setDataSharing();
            String newName = this.propertyEditor.getTextFieldName().getText();
            if (newName.compareTo(mds.getName()) != 0) {
                SetNameCommand setNameCommand = new SetNameCommand(mds, newName);
            }
        }
        this.propertyEditor.setVisible(false);
        this.viewportController.getStateInfo().getHandlesOfMarkedObjects();
        this.viewportController.doRepaint();
    }

    private void setDataSharing() {
        JComboBox comboBoxDataSource = this.propertyEditor.getComboBoxDataSource();
        int index = comboBoxDataSource.getSelectedIndex();
        MyDataSharingObject newDataSource = index == 0 ? null : (MyDataSharingObject)this.possibleDataSource.get(index - 1);
        MyDataSharingObject mds = (MyDataSharingObject)this.object;
        if (mds.getDataSource() != newDataSource) {
            SetDataSourceCommand setDataSourceCommand = new SetDataSourceCommand(mds, newDataSource);
        }
    }

    private void setNewMyMarkfieldValues() {
        int newIndex;
        MyMarkField markfield = (MyMarkField)this.object;
        int oldIndex = MarkModelFactory.getInstance().getIndex(markfield.getModel());
        if (oldIndex != (newIndex = this.getComboBoxMarkModelSelection())) {
            SetMarkModelCommand setMarkModelCommand = new SetMarkModelCommand(MarkModelFactory.getInstance().getMarkType(newIndex, markfield), markfield);
        }
    }

    private void setNewMyTextFieldValues() {
        TextStyleChangeable textfield = (TextStyleChangeable)((Object)this.object);
        float newBorderTop = ((Double)this.propertyEditor.getUnitSpinnerTextfieldTop().getValue()).floatValue();
        float newBorderBottom = ((Double)this.propertyEditor.getUnitSpinnerTextfieldBottom().getValue()).floatValue();
        float newBorderLeft = ((Double)this.propertyEditor.getUnitSpinnerTextfieldLeft().getValue()).floatValue();
        float newBorderRight = ((Double)this.propertyEditor.getUnitSpinnerTextfieldRight().getValue()).floatValue();
        boolean nothingToDo = true;
        if ((double)Math.abs(newBorderTop - textfield.getBorder(BorderType.top)) < 0.001) {
            newBorderTop = textfield.getBorder(BorderType.top);
        } else {
            nothingToDo = false;
        }
        if ((double)Math.abs(newBorderBottom - textfield.getBorder(BorderType.bottom)) < 0.001) {
            newBorderBottom = textfield.getBorder(BorderType.bottom);
        } else {
            nothingToDo = false;
        }
        if ((double)Math.abs(newBorderLeft - textfield.getBorder(BorderType.left)) < 0.001) {
            newBorderLeft = textfield.getBorder(BorderType.left);
        } else {
            nothingToDo = false;
        }
        if ((double)Math.abs(newBorderRight - textfield.getBorder(BorderType.right)) < 0.001) {
            newBorderRight = textfield.getBorder(BorderType.right);
        } else {
            nothingToDo = false;
        }
        if (!nothingToDo) {
            SetTextfieldBordersCommand setTextfieldBordersCommand = new SetTextfieldBordersCommand(textfield, newBorderTop, newBorderBottom, newBorderLeft, newBorderRight);
        }
    }

    private void setNewMyObjectValues() {
        MarkedObjectsPreserveCommand markedObjectsPreserveCommand;
        double newHeight;
        boolean isQuadratic = this.object.isDrawOnlyQuadratic();
        double newWidth = (Double)this.propertyEditor.getUnitSpinnerWidth().getValue();
        double newAngle = this.object.getAngleInDegrees();
        if (isQuadratic) {
            newHeight = newWidth;
        } else {
            newHeight = (Double)this.propertyEditor.getUnitSpinnerHeight().getValue();
            newAngle = (Double)this.propertyEditor.getUnitSpinnerAngle().getValue() / 180.0 * Math.PI;
        }
        if (Math.abs(this.object.getWidth() - newWidth) < 0.001) {
            newWidth = this.object.getWidth();
        }
        if (Math.abs(this.object.getHeight() - newHeight) < 0.001) {
            newHeight = this.object.getHeight();
        }
        if (Math.abs(this.object.getAngleInDegrees() - newAngle) < 1.0E-4) {
            newAngle = this.object.getAngleInDegrees();
        }
        if ((!MyMath.isZero(newWidth - this.object.getWidth()) || !MyMath.isZero(newHeight - this.object.getHeight())) && newWidth > 0.0 && newWidth < 50.0 && newHeight > 0.0 && newHeight < 50.0) {
            markedObjectsPreserveCommand = new StretchHorVertCommand(this.viewportController.getStateInfo(), this.object, new PointDouble(this.object.getMidX(), this.object.getMidY()), newWidth / this.object.getWidth(), newHeight / this.object.getHeight());
        }
        if (!MyMath.isZero(MyMath.normalizeAngle(newAngle) - MyMath.normalizeAngle(this.object.getAngle()))) {
            markedObjectsPreserveCommand = new RotateCommand(this.viewportController.getStateInfo(), this.object, new PointDouble(this.object.getMidX(), this.object.getMidY()), newAngle - this.object.getAngle());
        }
    }
}

