/*
 * Decompiled with CFR 0.152.
 */
package init;

import com.stibocatalog.Hunspell;
import data.DataObject;
import data.localdatabase.DBExchangeObject;
import data.localdatabase.DataProvider;
import data.test.TestDatabase;
import gui.components.mainframe.MainFrameController;
import init.Settings;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import javax.swing.UIManager;
import util.io.IO;
import util.language.Lang;
import util.logging.Log;

public class App {
    public static String PROJECT_NAME = "Zeugniseditor";
    public static String VERSION = "0.5";
    public static String PROJECT_NAME_VERSION = String.valueOf(PROJECT_NAME) + " " + VERSION;
    private static App app;
    private MainFrameController mainFrameController;
    private static boolean jnafound;

    static {
        jnafound = false;
    }

    public static boolean jnafound() {
        return jnafound;
    }

    public static App getInstance() {
        if (app == null) {
            Log.initNoLog();
            app = new App();
        }
        return app;
    }

    public void initApplication(ApplicationMode applicationMode) {
        Settings.getInstance().setApplicationMode(applicationMode);
        if (Settings.getInstance().isEditMode()) {
            Settings.getInstance().setToggleEditModus(Settings.ToggleEditModus.edit);
        }
        long time = System.currentTimeMillis();
        this.paintSplashScreen();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Lang.loadLanguage("de");
        try {
            InputStream is = IO.openDataFile("lib/jna.jar");
            is.close();
            jnafound = true;
        }
        catch (Exception ex) {
            System.out.println("App.java: Konnte die Datei jna.jar nicht finden.");
            jnafound = false;
        }
        if (jnafound) {
            try {
                Hunspell.getInstance();
            }
            catch (Exception ex) {
                System.out.println("App.java: Konnte die Rechtschreibpr\u00fcfung nicht starten.");
                System.out.println(ex.toString());
                System.out.println(ex.getStackTrace());
                jnafound = false;
            }
        }
        this.mainFrameController = new MainFrameController();
        if (applicationMode == ApplicationMode.userMode_in_ASV) {
            DataObject.setDatabaseInterface(new TestDatabase());
        }
        DataProvider dp = new DataProvider(new DBExchangeObject());
        this.mainFrameController.init(applicationMode, dp);
        while (System.currentTimeMillis() < time + 2000L) {
        }
        this.mainFrameController.show();
    }

    private void paintSplashScreen() {
        SplashScreen splash = SplashScreen.getSplashScreen();
        Graphics2D g2d = splash.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int ymin = 260;
        g2d.setFont(new Font("Arial", 0, 28));
        String title = String.valueOf(PROJECT_NAME_VERSION) + "(Studie)";
        int width = g2d.getFontMetrics().stringWidth(title);
        int x = (splash.getSize().width - width) / 2;
        int textheight = g2d.getFontMetrics().getMaxAscent() + g2d.getFontMetrics().getMaxDescent();
        int y = ymin + 10;
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.setPaint(new Color(0x20202020, true));
        int rleft = x - 10;
        int rtop = y - g2d.getFontMetrics().getMaxAscent() - 2;
        int rwidth = width + 20;
        int rheight = textheight + 4;
        Rectangle2D.Double r = new Rectangle2D.Double(rleft, rtop, rwidth, rheight);
        g2d.fill(r);
        r = new Rectangle2D.Double(rleft + 1, rtop + 1, rwidth - 2, rheight - 2);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(new Color(-6291456, true));
        g2d.draw(r);
        g2d.setColor(new Color(-16777216, true));
        g2d.drawString(title, x, y);
        g2d.setColor(new Color(-2236963, true));
        g2d.drawString(title, x - 2, y - 2);
        splash.update();
    }

    public static enum ApplicationMode {
        userMode_in_ASV,
        editMode_in_ASV,
        standalone_userMode,
        standalone_editMode;

    }
}

