/*
 * Decompiled with CFR 0.152.
 */
package util.logging;

import util.logging.AppletLog;
import util.logging.ApplicationLog;
import util.logging.LogInterface;
import util.logging.NoLog;

public class Log {
    private static LogInterface log = null;
    public static final int ALL = 0;
    public static final int DEBUG = 1;
    public static final int MESSAGE = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final int COMMAND = 5;

    public static void initNoLog() {
        log = new NoLog();
    }

    public static void initApplicationLog(String logFileName) {
        log = new ApplicationLog(logFileName);
    }

    public static void initAppletLog() {
        log = new AppletLog();
    }

    public static void log(int level, Object sender, String msg) {
        Log.ensureInit();
        log.log(level, sender, msg);
    }

    public static void log(int level, String msg) {
        Log.ensureInit();
        log.log(level, msg);
    }

    public static void log(Object sender, Exception e) {
        Log.ensureInit();
        log.log(sender, e);
    }

    public static void log(Exception e) {
        Log.ensureInit();
        log.log(e);
    }

    public static void log(int level, Object sender, Exception e) {
        Log.ensureInit();
        log.log(level, sender, e);
    }

    public static void setLoggingLevel(int Level2) {
        Log.ensureInit();
        log.setLoggingLevel(Level2);
    }

    public static void close() {
        Log.ensureInit();
        log.close();
    }

    public static String getLogFilename() {
        Log.ensureInit();
        return log.getLogFilename();
    }

    private static void ensureInit() {
        if (log == null) {
            Log.initApplicationLog("data/app.log");
        }
    }

    static void println(String s) {
        System.out.println(s);
    }

    static void print(String s) {
        System.out.print(s);
    }
}

